/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.diagnostic.LogMessageEx;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.source.PsiFileWithStubSupport;
import com.intellij.psi.stubs.ObjectStubTree;
import com.intellij.psi.stubs.PsiFileStubImpl;
import com.intellij.psi.stubs.StubProcessingHelperBase;
import com.intellij.psi.stubs.StubTree;
import com.intellij.psi.stubs.StubTreeLoader;
import com.intellij.util.indexing.FileBasedIndex;
import org.jetbrains.annotations.NotNull;

public class StubProcessingHelper
extends StubProcessingHelperBase {
    private final FileBasedIndex myFileBasedIndex;

    public StubProcessingHelper(FileBasedIndex fileBasedIndex) {
        this.myFileBasedIndex = fileBasedIndex;
    }

    @Override
    protected void onInternalError(final VirtualFile file) {
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                StubProcessingHelper.this.myFileBasedIndex.requestReindex(file);
            }
        }, ModalityState.NON_MODAL);
    }

    @Override
    protected Object stubTreeAndIndexDoNotMatch(@NotNull ObjectStubTree stubTree, PsiFileWithStubSupport psiFile) {
        if (stubTree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stubTree", "com/intellij/psi/stubs/StubProcessingHelper", "stubTreeAndIndexDoNotMatch"));
        }
        VirtualFile virtualFile = psiFile.getVirtualFile();
        StubTree stubTreeFromIndex = (StubTree)StubTreeLoader.getInstance().readFromVFile(psiFile.getProject(), virtualFile);
        String details = "Please report the problem to JetBrains with the file attached";
        details = details + StubTreeLoader.getInstance().getStubAstMismatchDiagnostics(virtualFile, psiFile, stubTree, null);
        details = details + "\n" + DebugUtil.currentStackTrace();
        String fileText = psiFile instanceof PsiCompiledElement ? "compiled" : psiFile.getText();
        return LogMessageEx.createEvent("PSI and index do not match", details, new Attachment(virtualFile.getPath() + "_file.txt", fileText), new Attachment("stubTree.txt", ((PsiFileStubImpl)stubTree.getRoot()).printTree()), new Attachment("stubTreeFromIndex.txt", stubTreeFromIndex == null ? "null" : ((PsiFileStubImpl)stubTreeFromIndex.getRoot()).printTree()));
    }
}

