/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.actions;

import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.SyntheticElement;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.actions.BaseRefactoringAction;
import com.intellij.refactoring.rename.PsiElementRenameHandler;
import com.intellij.refactoring.rename.RenameHandlerRegistry;
import org.jetbrains.annotations.NotNull;

public class RenameElementAction
extends BaseRefactoringAction {
    public RenameElementAction() {
        this.setInjectedContext(true);
    }

    @Override
    public boolean isAvailableInEditorOnly() {
        return false;
    }

    @Override
    public boolean isEnabledOnElements(@NotNull PsiElement[] elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/refactoring/actions/RenameElementAction", "isEnabledOnElements"));
        }
        if (elements.length != 1) {
            return false;
        }
        PsiElement element = elements[0];
        return element instanceof PsiNamedElement && !(element instanceof SyntheticElement) && !PsiElementRenameHandler.isVetoed(element);
    }

    @Override
    public RefactoringActionHandler getHandler(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/refactoring/actions/RenameElementAction", "getHandler"));
        }
        return RenameHandlerRegistry.getInstance().getRenameHandler(dataContext);
    }

    @Override
    protected boolean hasAvailableHandler(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/refactoring/actions/RenameElementAction", "hasAvailableHandler"));
        }
        return this.isEnabledOnDataContext(dataContext);
    }

    @Override
    protected boolean isEnabledOnDataContext(DataContext dataContext) {
        return RenameHandlerRegistry.getInstance().hasAvailableHandler(dataContext);
    }

    @Override
    protected boolean isAvailableForLanguage(Language language) {
        return true;
    }

    @Override
    protected boolean isAvailableOnElementInEditorAndFile(@NotNull PsiElement element, @NotNull Editor editor, @NotNull PsiFile file, @NotNull DataContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/refactoring/actions/RenameElementAction", "isAvailableOnElementInEditorAndFile"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/refactoring/actions/RenameElementAction", "isAvailableOnElementInEditorAndFile"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/refactoring/actions/RenameElementAction", "isAvailableOnElementInEditorAndFile"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/refactoring/actions/RenameElementAction", "isAvailableOnElementInEditorAndFile"));
        }
        return RenameHandlerRegistry.getInstance().hasAvailableHandler(context);
    }
}

