/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomNameStrategy;
import com.intellij.util.xml.EvaluatedXmlName;
import com.intellij.util.xml.JavaMethod;
import com.intellij.util.xml.ModelMergerUtil;
import com.intellij.util.xml.XmlName;
import com.intellij.util.xml.impl.AbstractCollectionChildDescription;
import com.intellij.util.xml.impl.DomChildDescriptionImpl;
import com.intellij.util.xml.impl.DomImplUtil;
import com.intellij.util.xml.impl.DomInvocationHandler;
import com.intellij.util.xml.impl.DomManagerImpl;
import com.intellij.util.xml.reflect.DomCollectionChildDescription;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CollectionChildDescriptionImpl
extends DomChildDescriptionImpl
implements DomCollectionChildDescription,
AbstractCollectionChildDescription {
    private final Collection<JavaMethod> myGetterMethods;

    public CollectionChildDescriptionImpl(XmlName tagName, Type type, Collection<JavaMethod> getterMethods) {
        super(tagName, type);
        this.myGetterMethods = getterMethods;
    }

    public String toString() {
        return "CollectionChildDescription:" + this.getXmlName();
    }

    List<XmlTag> getCollectionSubTags(DomInvocationHandler<?, ?> handler2, @NotNull XmlTag tag) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/util/xml/impl/CollectionChildDescriptionImpl", "getCollectionSubTags"));
        }
        return DomImplUtil.findSubTags(tag, handler2.createEvaluatedXmlName(this.getXmlName()), handler2.getFile());
    }

    public DomElement addValue(@NotNull DomElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/util/xml/impl/CollectionChildDescriptionImpl", "addValue"));
        }
        assert (element.getGenericInfo().getCollectionChildrenDescriptions().contains(this));
        return this.addChild(element, this.getType(), Integer.MAX_VALUE);
    }

    private DomElement addChild(DomElement element, Type type, int index) {
        try {
            DomInvocationHandler handler2 = DomManagerImpl.getDomInvocationHandler(element);
            assert (handler2 != null);
            return handler2.addCollectionChild(this, type, index);
        }
        catch (IncorrectOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public DomElement addValue(@NotNull DomElement element, int index) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/util/xml/impl/CollectionChildDescriptionImpl", "addValue"));
        }
        return this.addChild(element, this.getType(), index);
    }

    public DomElement addValue(@NotNull DomElement parent, Type type) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/util/xml/impl/CollectionChildDescriptionImpl", "addValue"));
        }
        return this.addValue(parent, type, Integer.MAX_VALUE);
    }

    public final DomElement addValue(@NotNull DomElement parent, Type type, int index) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/util/xml/impl/CollectionChildDescriptionImpl", "addValue"));
        }
        return this.addChild(parent, type, index);
    }

    @Nullable
    public final JavaMethod getGetterMethod() {
        Collection<JavaMethod> methods = this.myGetterMethods;
        return methods.isEmpty() ? null : methods.iterator().next();
    }

    @NotNull
    public List<? extends DomElement> getValues(@NotNull DomElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/util/xml/impl/CollectionChildDescriptionImpl", "getValues"));
        }
        DomInvocationHandler handler2 = DomManagerImpl.getDomInvocationHandler(element);
        if (handler2 != null) {
            List<DomElement> list = handler2.getCollectionChildren(this);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/impl/CollectionChildDescriptionImpl", "getValues"));
            }
            return list;
        }
        JavaMethod getterMethod = this.getGetterMethod();
        if (getterMethod == null) {
            List collection = ModelMergerUtil.getFilteredImplementations((Object)element);
            List list = ContainerUtil.concat((Iterable)collection, (Function)new Function<DomElement, Collection<? extends DomElement>>(){

                public Collection<? extends DomElement> fun(DomElement domElement) {
                    DomInvocationHandler handler2 = DomManagerImpl.getDomInvocationHandler(domElement);
                    assert (handler2 != null) : domElement;
                    return handler2.getCollectionChildren(CollectionChildDescriptionImpl.this);
                }
            });
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/impl/CollectionChildDescriptionImpl", "getValues"));
            }
            return list;
        }
        List list = (List)getterMethod.invoke((Object)element, ArrayUtil.EMPTY_OBJECT_ARRAY);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/impl/CollectionChildDescriptionImpl", "getValues"));
        }
        return list;
    }

    @NotNull
    public String getCommonPresentableName(@NotNull DomNameStrategy strategy) {
        if (strategy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strategy", "com/intellij/util/xml/impl/CollectionChildDescriptionImpl", "getCommonPresentableName"));
        }
        String words = strategy.splitIntoWords(this.getXmlElementName());
        String string = StringUtil.capitalizeWords((String)(words.endsWith("es") ? words : StringUtil.pluralize((String)words)), (boolean)true);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/impl/CollectionChildDescriptionImpl", "getCommonPresentableName"));
        }
        return string;
    }

    @Override
    @Nullable
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        Annotation annotation;
        JavaMethod method = this.getGetterMethod();
        if (method != null && (annotation = method.getAnnotation(annotationClass)) != null) {
            return (T)annotation;
        }
        Type elemType = this.getType();
        return elemType instanceof AnnotatedElement ? ((AnnotatedElement)((Object)elemType)).getAnnotation(annotationClass) : super.getAnnotation(annotationClass);
    }

    @Override
    public List<XmlTag> getSubTags(DomInvocationHandler handler2, XmlTag[] subTags, XmlFile file) {
        return DomImplUtil.findSubTags(subTags, handler2.createEvaluatedXmlName(this.getXmlName()), file);
    }

    @Override
    public EvaluatedXmlName createEvaluatedXmlName(DomInvocationHandler parent, XmlTag childTag) {
        return parent.createEvaluatedXmlName(this.getXmlName());
    }
}

