/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.dependency;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.reference.RefClass;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefJavaVisitor;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.codeInspection.ui.SingleIntegerFieldOptionsPanel;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseGlobalInspection;
import com.siyeh.ig.dependency.DependencyUtils;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class ClassWithTooManyDependenciesInspection
extends BaseGlobalInspection {
    public int limit = 10;

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("class.with.too.many.dependencies.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/dependency/ClassWithTooManyDependenciesInspection", "getDisplayName"));
        }
        return string;
    }

    public void runInspection(@NotNull AnalysisScope scope, final @NotNull InspectionManager inspectionManager, @NotNull GlobalInspectionContext globalInspectionContext, final @NotNull ProblemDescriptionsProcessor problemDescriptionsProcessor) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/siyeh/ig/dependency/ClassWithTooManyDependenciesInspection", "runInspection"));
        }
        if (inspectionManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inspectionManager", "com/siyeh/ig/dependency/ClassWithTooManyDependenciesInspection", "runInspection"));
        }
        if (globalInspectionContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "globalInspectionContext", "com/siyeh/ig/dependency/ClassWithTooManyDependenciesInspection", "runInspection"));
        }
        if (problemDescriptionsProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "problemDescriptionsProcessor", "com/siyeh/ig/dependency/ClassWithTooManyDependenciesInspection", "runInspection"));
        }
        RefManager refManager = globalInspectionContext.getRefManager();
        refManager.iterate((RefVisitor)new RefJavaVisitor(){

            public void visitClass(@NotNull RefClass refClass) {
                if (refClass == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refClass", "com/siyeh/ig/dependency/ClassWithTooManyDependenciesInspection$1", "visitClass"));
                }
                super.visitClass(refClass);
                if (refClass.getOwner() instanceof RefClass) {
                    return;
                }
                Set<RefClass> dependencies = DependencyUtils.calculateDependenciesForClass(refClass);
                int numDependencies = dependencies.size();
                if (numDependencies <= ClassWithTooManyDependenciesInspection.this.limit) {
                    return;
                }
                String errorString = InspectionGadgetsBundle.message("class.with.too.many.dependencies.problem.descriptor", refClass.getName(), numDependencies, ClassWithTooManyDependenciesInspection.this.limit);
                CommonProblemDescriptor[] descriptors = new CommonProblemDescriptor[]{inspectionManager.createProblemDescriptor(errorString, new QuickFix[0])};
                problemDescriptionsProcessor.addProblemElement((RefEntity)refClass, descriptors);
            }
        });
    }

    public JComponent createOptionsPanel() {
        return new SingleIntegerFieldOptionsPanel(InspectionGadgetsBundle.message("class.with.too.many.dependencies.max.option", new Object[0]), (InspectionProfileEntry)this, "limit");
    }
}

