/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.builtInWebServer;

import com.google.common.net.InetAddresses;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.QueryStringDecoder;
import kotlin.StringsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.builtInWebServer.BuiltInWebServerKt;
import org.jetbrains.ide.HttpRequestHandler;
import org.jetbrains.io.NettyKt;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"%\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u0003!-Q\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005a\u0001!G\u0001\u0019\u0002\u0005\u0016\u0011kA\u0001\t\u0003\u0015BAa\u0003E\u0002\u001b\u0005A\"!G\u0002\t\u00065\t\u0001dA\u0013\u0011\t-A9!D\u0001\u0019\u0005e\u0019\u0001\u0002B\u0007\u00021\u0013I2\u0001#\u0002\u000e\u0003a\u0019\u0011d\u0001\u0005\u0006\u001b\u0005AZ\u0001"}, strings={"Lorg/jetbrains/builtInWebServer/BuiltInWebServer;", "Lorg/jetbrains/ide/HttpRequestHandler;", "()V", "isSupported", "", "request", "Lio/netty/handler/codec/http/FullHttpRequest;", "process", "urlDecoder", "Lio/netty/handler/codec/http/QueryStringDecoder;", "context", "Lio/netty/channel/ChannelHandlerContext;"}, moduleName="built-in-server")
public final class BuiltInWebServer
extends HttpRequestHandler {
    public boolean isSupported(@NotNull FullHttpRequest request) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        return super.isSupported(request) || Intrinsics.areEqual((Object)request.method(), (Object)HttpMethod.POST);
    }

    public boolean process(@NotNull QueryStringDecoder urlDecoder, @NotNull FullHttpRequest request, @NotNull ChannelHandlerContext context) {
        String projectName;
        boolean isIpv6;
        Intrinsics.checkParameterIsNotNull((Object)urlDecoder, (String)"urlDecoder");
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        String host = NettyKt.getHost((HttpRequest)request);
        if (StringsKt.isNullOrEmpty((CharSequence)host)) {
            return false;
        }
        int portIndex = StringsKt.indexOf$default((CharSequence)host, (char)':', (int)0, (boolean)false, (int)6);
        if (portIndex > 0) {
            host = StringsKt.substring((String)host, (int)0, (int)portIndex);
        }
        boolean bl = isIpv6 = host.charAt(0) == '[' && host.length() > 2 && host.charAt(host.length() - 1) == ']';
        if (isIpv6) {
            host = StringsKt.substring((String)host, (int)1, (int)(host.length() - 1));
        }
        if (isIpv6 || InetAddresses.isInetAddress((String)host) || BuiltInWebServerKt.isOwnHostName(host) || StringsKt.endsWith$default((String)host, (String)".ngrok.io", (boolean)false, (int)2)) {
            if (urlDecoder.path().length() < 2) {
                return false;
            }
            projectName = null;
        } else {
            projectName = host;
        }
        return BuiltInWebServerKt.access$doProcess(request, context, projectName);
    }
}

