/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.builtInWebServer.ssi;

import io.netty.buffer.ByteBufUtf8Writer;
import java.text.ParseException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.builtInWebServer.ssi.ExpressionParseTree;
import org.jetbrains.builtInWebServer.ssi.SsiCommand;
import org.jetbrains.builtInWebServer.ssi.SsiProcessingState;
import org.jetbrains.builtInWebServer.ssi.SsiStopProcessingException;

public class SsiConditional
implements SsiCommand {
    @Override
    public long process(@NotNull SsiProcessingState ssiProcessingState, @NotNull String commandName, @NotNull List<? extends String> paramNames, @NotNull String[] paramValues, @NotNull ByteBufUtf8Writer writer) {
        if (ssiProcessingState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ssiProcessingState", "org/jetbrains/builtInWebServer/ssi/SsiConditional", "process"));
        }
        if (commandName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandName", "org/jetbrains/builtInWebServer/ssi/SsiConditional", "process"));
        }
        if (paramNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paramNames", "org/jetbrains/builtInWebServer/ssi/SsiConditional", "process"));
        }
        if (paramValues == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paramValues", "org/jetbrains/builtInWebServer/ssi/SsiConditional", "process"));
        }
        if (writer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "writer", "org/jetbrains/builtInWebServer/ssi/SsiConditional", "process"));
        }
        long lastModified = System.currentTimeMillis();
        SsiProcessingState.SsiConditionalState state = ssiProcessingState.conditionalState;
        if ("if".equalsIgnoreCase(commandName)) {
            if (state.processConditionalCommandsOnly) {
                ++state.nestingCount;
                return lastModified;
            }
            state.nestingCount = 0;
            if (SsiConditional.evaluateArguments(paramNames, paramValues, ssiProcessingState)) {
                state.branchTaken = true;
            } else {
                state.processConditionalCommandsOnly = true;
                state.branchTaken = false;
            }
        } else if ("elif".equalsIgnoreCase(commandName)) {
            if (state.nestingCount > 0) {
                return lastModified;
            }
            if (state.branchTaken) {
                state.processConditionalCommandsOnly = true;
                return lastModified;
            }
            if (SsiConditional.evaluateArguments(paramNames, paramValues, ssiProcessingState)) {
                state.processConditionalCommandsOnly = false;
                state.branchTaken = true;
            } else {
                state.processConditionalCommandsOnly = true;
                state.branchTaken = false;
            }
        } else if ("else".equalsIgnoreCase(commandName)) {
            if (state.nestingCount > 0) {
                return lastModified;
            }
            state.processConditionalCommandsOnly = state.branchTaken;
            state.branchTaken = true;
        } else if ("endif".equalsIgnoreCase(commandName)) {
            if (state.nestingCount > 0) {
                --state.nestingCount;
                return lastModified;
            }
            state.processConditionalCommandsOnly = false;
            state.branchTaken = true;
        } else {
            throw new SsiStopProcessingException();
        }
        return lastModified;
    }

    private static boolean evaluateArguments(@NotNull List<? extends String> names, @NotNull String[] values, @NotNull SsiProcessingState ssiProcessingState) {
        String expression;
        if (names == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "names", "org/jetbrains/builtInWebServer/ssi/SsiConditional", "evaluateArguments"));
        }
        if (values == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "org/jetbrains/builtInWebServer/ssi/SsiConditional", "evaluateArguments"));
        }
        if (ssiProcessingState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ssiProcessingState", "org/jetbrains/builtInWebServer/ssi/SsiConditional", "evaluateArguments"));
        }
        String string = expression = "expr".equalsIgnoreCase(names.get(0)) ? values[0] : null;
        if (expression == null) {
            throw new SsiStopProcessingException();
        }
        try {
            return new ExpressionParseTree(expression, ssiProcessingState).evaluateTree();
        }
        catch (ParseException e) {
            throw new SsiStopProcessingException();
        }
    }
}

