/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.util.ThreeState;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XInlineDebuggerDataCallback;
import com.intellij.xdebugger.frame.XNavigatable;
import com.intellij.xdebugger.frame.XValueNode;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.CallFrame;
import org.jetbrains.debugger.DebuggerViewSupport;
import org.jetbrains.debugger.MemberFilter;
import org.jetbrains.debugger.Script;
import org.jetbrains.debugger.SourceInfo;
import org.jetbrains.debugger.ValueModifierUtil;
import org.jetbrains.debugger.Variable;
import org.jetbrains.debugger.VariableContext;
import org.jetbrains.debugger.VariableView;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.frame.CallFrameView;
import org.jetbrains.debugger.values.ObjectValue;
import org.jetbrains.debugger.values.Value;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"[\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\rQ!\u0001\u0005\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0011\u001d)\u0001!B\u0001\t!\u0015\u0001Q!\u0001E\u0006\t-a\u0001!G\u0001\u0019\u0002e\t\u0001$AQ\u0003#\u000e\t\u00012A\u0013\u0019\t-AQ!D\u0001\u0019\fe\u0019\u0001BB\u0007\u00021\u001bI2\u0001C\u0004\u000e\u0003a=\u0011d\u0001\u0005\t\u001b\u0005A\n\"G\u0002\t\u00135\t\u00014C\r\u0004\u0011)i\u0011\u0001'\u0006&1\u0011Y\u0001bC\u0007\u00021\u0017I2\u0001\u0003\u0004\u000e\u0003a]\u0011d\u0001\u0005\b\u001b\u0005Az!G\u0002\t\u00115\t\u0001\u0014C\r\u0004\u0011%i\u0011\u0001g\u0005\u001a\u0007!QQ\"\u0001M\u000bKG!1\u0002\u0003\u0007\u000e\u0016%1\u0011\"\u0002\t\u0004+\ta\t\u0001'\u0001\u0019\u0002a\u0015\u0011kA\u0001\u0005\be\u0019\u0001\u0002C\u0007\u00021#)s\u0002B\u0006\t\u001a5\t\u0001$D\r\u0007\u00117iA!\u0003\u0002\n\u0003ai\u0001DD\r\u0004\u0011;i\u0011\u0001G\b*(\u0011\u0011\u0005\u0002\u0003\u0002\u000e\u0016%1\u0011\"\u0002\t\u0004+\ta\t\u0001'\u0001\u0019\u0002a\u0015\u0011kA\u0001\u0005\bE\u001bA!\u0002\u0001\u000e\u0005\u0011!\u0001\u0012\u0002"}, strings={"Lorg/jetbrains/debugger/BasicDebuggerViewSupport;", "Lorg/jetbrains/debugger/MemberFilter;", "Lorg/jetbrains/debugger/DebuggerViewSupport;", "()V", "defaultMemberFilterPromise", "Lorg/jetbrains/concurrency/Promise;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getDefaultMemberFilterPromise", "()Lorg/jetbrains/concurrency/Promise;", "computeArrayPresentation", "", "value", "Lorg/jetbrains/debugger/values/Value;", "variable", "Lorg/jetbrains/debugger/Variable;", "context", "Lorg/jetbrains/debugger/VariableContext;", "node", "Lcom/intellij/xdebugger/frame/XValueNode;", "icon", "Ljavax/swing/Icon;", "computeObjectPresentation", "Lorg/jetbrains/debugger/values/ObjectValue;", "getMemberFilter", "propertyNamesToString", "", "list", "", "quotedAware", ""}, moduleName="script-debugger-ui")
public class BasicDebuggerViewSupport
implements MemberFilter,
DebuggerViewSupport {
    @NotNull
    private final Promise<MemberFilter> defaultMemberFilterPromise = Promise.resolve((Object)this);

    @NotNull
    protected final Promise<MemberFilter> getDefaultMemberFilterPromise() {
        return this.defaultMemberFilterPromise;
    }

    @Override
    @NotNull
    public String propertyNamesToString(@NotNull List<? extends String> list, boolean quotedAware) {
        Intrinsics.checkParameterIsNotNull(list, (String)"list");
        return ValueModifierUtil.INSTANCE.propertyNamesToString(list, quotedAware);
    }

    @Override
    public void computeObjectPresentation(@NotNull ObjectValue value, @NotNull Variable variable, @NotNull VariableContext context, @NotNull XValueNode node, @NotNull Icon icon) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        Intrinsics.checkParameterIsNotNull((Object)variable, (String)"variable");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull((Object)icon, (String)"icon");
        VariableView.Companion.setObjectPresentation(value, icon, node);
    }

    @Override
    public void computeArrayPresentation(@NotNull Value value, @NotNull Variable variable, @NotNull VariableContext context, @NotNull XValueNode node, @NotNull Icon icon) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        Intrinsics.checkParameterIsNotNull((Object)variable, (String)"variable");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull((Object)icon, (String)"icon");
        VariableView.Companion.setArrayPresentation(value, context, icon, node);
    }

    @Override
    @NotNull
    public Promise<MemberFilter> getMemberFilter(@NotNull VariableContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return this.defaultMemberFilterPromise;
    }

    @Override
    @NotNull
    public Collection<Variable> getAdditionalVariables() {
        return MemberFilter.DefaultImpls.getAdditionalVariables(this);
    }

    @Override
    public boolean hasNameMappings() {
        return MemberFilter.DefaultImpls.hasNameMappings(this);
    }

    @Override
    public boolean isMemberVisible(@NotNull Variable variable) {
        Intrinsics.checkParameterIsNotNull((Object)variable, (String)"variable");
        return MemberFilter.DefaultImpls.isMemberVisible(this, variable);
    }

    @Override
    @NotNull
    public String rawNameToSource(@NotNull Variable variable) {
        Intrinsics.checkParameterIsNotNull((Object)variable, (String)"variable");
        return MemberFilter.DefaultImpls.rawNameToSource(this, variable);
    }

    @Override
    @Nullable
    public String sourceNameToRaw(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return MemberFilter.DefaultImpls.sourceNameToRaw(this, name);
    }

    @Override
    @Nullable
    public Vm getVm() {
        return DebuggerViewSupport.DefaultImpls.getVm(this);
    }

    @Override
    @Nullable
    public SourceInfo getSourceInfo(@Nullable Script script, @NotNull CallFrame frame) {
        Intrinsics.checkParameterIsNotNull((Object)frame, (String)"frame");
        return DebuggerViewSupport.DefaultImpls.getSourceInfo(this, script, frame);
    }

    @Override
    @Nullable
    public SourceInfo getSourceInfo(@Nullable String functionName, @NotNull String scriptUrl, int line, int column) {
        Intrinsics.checkParameterIsNotNull((Object)scriptUrl, (String)"scriptUrl");
        return DebuggerViewSupport.DefaultImpls.getSourceInfo((DebuggerViewSupport)this, functionName, scriptUrl, line, column);
    }

    @Override
    @Nullable
    public SourceInfo getSourceInfo(@Nullable String functionName, @NotNull Script script, int line, int column) {
        Intrinsics.checkParameterIsNotNull((Object)script, (String)"script");
        return DebuggerViewSupport.DefaultImpls.getSourceInfo((DebuggerViewSupport)this, functionName, script, line, column);
    }

    @Override
    @NotNull
    public XDebuggerEvaluator createFrameEvaluator(@NotNull CallFrameView frame) {
        Intrinsics.checkParameterIsNotNull((Object)frame, (String)"frame");
        return DebuggerViewSupport.DefaultImpls.createFrameEvaluator(this, frame);
    }

    @Override
    public boolean canNavigateToSource(@NotNull Variable variable, @NotNull VariableContext context) {
        Intrinsics.checkParameterIsNotNull((Object)variable, (String)"variable");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return DebuggerViewSupport.DefaultImpls.canNavigateToSource(this, variable, context);
    }

    @Override
    public void computeSourcePosition(@NotNull String name, @Nullable Value value, @NotNull Variable variable, @NotNull VariableContext context, @NotNull XNavigatable navigatable) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)variable, (String)"variable");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)navigatable, (String)"navigatable");
        DebuggerViewSupport.DefaultImpls.computeSourcePosition(this, name, value, variable, context, navigatable);
    }

    @Override
    @NotNull
    public ThreeState computeInlineDebuggerData(@NotNull String name, @NotNull Variable variable, @NotNull VariableContext context, @NotNull XInlineDebuggerDataCallback callback) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)variable, (String)"variable");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)callback, (String)"callback");
        return DebuggerViewSupport.DefaultImpls.computeInlineDebuggerData(this, name, variable, context, callback);
    }

    @Override
    @Nullable
    public Promise<?> computeAdditionalObjectProperties(@NotNull ObjectValue value, @NotNull Variable variable, @NotNull VariableContext context, @NotNull XCompositeNode node) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        Intrinsics.checkParameterIsNotNull((Object)variable, (String)"variable");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        return DebuggerViewSupport.DefaultImpls.computeAdditionalObjectProperties(this, value, variable, context, node);
    }

    @Override
    @Nullable
    public Value transformErrorOnGetUsedReferenceValue(@Nullable Value value, @Nullable String error) {
        return DebuggerViewSupport.DefaultImpls.transformErrorOnGetUsedReferenceValue(this, value, error);
    }

    @Override
    public boolean isInLibraryContent(@NotNull SourceInfo sourceInfo, @Nullable Script script) {
        Intrinsics.checkParameterIsNotNull((Object)sourceInfo, (String)"sourceInfo");
        return DebuggerViewSupport.DefaultImpls.isInLibraryContent(this, sourceInfo, script);
    }
}

