/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger.connection;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.components.JBList;
import java.util.Collection;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import kotlin.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.PromiseKt;
import org.jetbrains.debugger.connection.RemoteVmConnectionKt;

@KotlinFileFacade(version={1, 0, 0}, abiVersion=32, data={"!\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!\u0011!B\u0001\t\u001f\u0015\u0001Q!\u0001\u0005\u0005\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003!9Q\u0001AG \u0011\u0001iA!\u0003\u0002\n\u0003\u0011\n\u0001\u0014A\t\u0003\t\u0001A\u0011!\u0007\u0004\t\u00045!\u0011BA\u0005\u0002I\u0005A\"!G\u0002\t\u00065\t\u0001dA\r\n\u0011\u000fiq!\u0003\u0002\n\u0003\u0011\n\u0011BA\u0005\u00021\u0013AB\u0001V\u0002\u0006"}, strings={"chooseDebuggee", "Lorg/jetbrains/concurrency/Promise;", "T", "targets", "", "selectedIndex", "", "itemToString", "Lkotlin/Function1;", "", "RemoteVmConnectionKt"}, moduleName="script-debugger-ui")
public final class RemoteVmConnectionKt {
    @NotNull
    public static final <T> Promise<T> chooseDebuggee(@NotNull Collection<? extends T> targets, int selectedIndex, @NotNull Function1<? super T, ? extends String> itemToString) {
        Intrinsics.checkParameterIsNotNull(targets, (String)"targets");
        Intrinsics.checkParameterIsNotNull(itemToString, (String)"itemToString");
        if (targets.size() == 1) {
            return PromiseKt.resolvedPromise(CollectionsKt.first((Iterable)targets));
        }
        if (targets.isEmpty()) {
            return PromiseKt.rejectedPromise("No tabs to inspect");
        }
        AsyncPromise result2 = new AsyncPromise();
        ApplicationManager.getApplication().invokeLater(new Runnable(targets, itemToString, selectedIndex, result2){
            final /* synthetic */ Collection $targets;
            final /* synthetic */ Function1 $itemToString;
            final /* synthetic */ int $selectedIndex;
            final /* synthetic */ AsyncPromise $result;

            public final void run() {
                JBList list = new JBList(this.$targets);
                list.setCellRenderer((ListCellRenderer)new ColoredListCellRenderer.KotlinFriendlyColoredListCellRenderer<T>(this){
                    final /* synthetic */ chooseDebuggee.1 this$0;

                    protected void customizeCellRenderer(T value, int index, boolean selected, boolean hasFocus) {
                        this.append((String)this.this$0.$itemToString.invoke(value));
                    }
                    {
                        this.this$0 = $outer;
                    }
                });
                if (this.$selectedIndex != -1) {
                    list.setSelectedIndex(this.$selectedIndex);
                }
                JBPopupFactory.getInstance().createListPopupBuilder((JList)list).setTitle("Choose Page to Debug").setItemChoosenCallback(new Runnable(this, list){
                    final /* synthetic */ chooseDebuggee.1 this$0;
                    final /* synthetic */ JBList $list;

                    public final void run() {
                        Object value = this.$list.getSelectedValue();
                        if (value == null) {
                            this.this$0.$result.setError("No target to inspect");
                        } else {
                            this.this$0.$result.setResult(value);
                        }
                    }
                    {
                        this.this$0 = var1_1;
                        this.$list = jBList;
                    }
                }).createPopup().showInFocusCenter();
            }
            {
                this.$targets = collection;
                this.$itemToString = function1;
                this.$selectedIndex = n;
                this.$result = asyncPromise;
            }
        });
        return (Promise)result2;
    }
}

