/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger.sourcemap;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Url;
import com.intellij.util.UrlImpl;
import com.intellij.util.Urls;
import com.intellij.util.containers.ObjectIntHashMap;
import com.intellij.util.containers.UtilKt;
import gnu.trove.TObjectIntHashMap;
import java.util.List;
import kotlin.ArraysKt;
import kotlin.IntRange;
import kotlin.StringsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.sourcemap.MappingEntry;
import org.jetbrains.debugger.sourcemap.MappingList;
import org.jetbrains.debugger.sourcemap.SourceMap;
import org.jetbrains.debugger.sourcemap.SourceResolverKt;
import org.jetbrains.io.LocalFileFinder;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"c\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0001!B\u0001\t!\u0015\t\u0001bB\u0003\u0001\u000b\u0005AY!\u0002\u0001\u0006\u00031\tQ!\u0001\u0003\u0003\u000b\u0005a\u0011!\u0002\u0001\u0006\u0003!EQ!\u0001\u0003\u0003\u000b\u0005a\u0011!B\u0001\u0005\u0007\u0015\t\u0001\u0002B\u0003\u0001\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u00031\tQ!\u0001C\u0002\u000b\u0005a\u0011!B\u0001\u0005\u0007\u0011YA\u0002\u0001I\u00173\u0005A\n!HA\u0017/\u0005~\u0012B\u0002\u0005\u0002\u001b\u0011I!!C\u0001\u0019\u0005a\r\u0011b\u0001E\u0003\u001b\u0005A2!\u0003\u0003\t\b5\u0011A\u0012\u0001\r\u0005\u0013\u001dAI!D\u0003\n\u0005%\t\u0001D\u0001G\u00011\u0007IA\u0001B\u0001\t\u000b5\t\u0001dA)\u0004\u0003!-Q%\u0007\u0003\u000b\u0011/i\u0011\u0001\u0007\u0003\u001a\u0007!aQ\"\u0001\r\u00033\u0011AI\"\u0004\u0002\r\u0002a!\u0011d\u0001E\u0003\u001b\u0005A2!G\u0002\t\u001b5\t\u00014D\r\u0004\u0011\u0015i\u0011\u0001G\u0002&\u001b\u0011\t\u0001BD\u0007\u0003\u0019\u0003Aj\"G\u0002\t\u001f5\t\u0001tD\r\u0004\u0011Ai\u0011\u0001'\t&#!\tRB\u0001G\u00011;IB\u0001\u0003\t\u000e\u00051\u0005\u0001\u0014E\r\u0004\u0011=i\u0011\u0001g\b\u001a\u0007!\rR\"\u0001\r\u0013KQA\u0011#\u0004\u0002\r\u0002au\u0011D\u0002E\u0013\u001b\u0011I!!C\u0001\u0019\ta\r\u0011d\u0001\u0005\u0010\u001b\u0005Az\"\u0007\u0003\t!5\u0011A\u0012\u0001M\u0011K!A1#\u0004\u0002\r\u0002a\u0011\u0011d\u0001E\u0014\u001b\u0005AB#\n\u0005\t*5\u0011A\u0012\u0001\r\u00033\rA9#D\u0001\u0019)\u0015B\u0001\"F\u0007\u0003\u0019\u0003AB!G\u0002\t(5\t\u0001\u0004F\u0013\t\u0011Wi!\u0001$\u0001\u0019\u0005e\u0019\u0001\"D\u0007\u000217)\u0003\u0002c\u000b\u000e\u00051\u0005\u0001DA\r\u0004\u0011Oi\u0011\u0001\u0007\u000b&\u000f!1R\"\u0001M\u000e3\rAA\"D\u0001\u0019\t%ZA!\u0011\u000f\t\r5)\u0011BA\u0005\u00021\ta\t\u0001'\u0004R\u0007\u0005)\u0001!\u000b\b\u0005\u0001\"Aq!\u0004\u0003\n\u0005%\t\u0001\u0004\u0002M\b#\u000e)Q!\u0001\u0005\n\u001b\t!\u0001\u0002#\u0005*\u0015\u0011\t\u0005\u0002c\u0005\u000e\t%\u0011\u0011\"\u0001\r\u00051)\t6!A\u0003\u0001S)!\u0011\t\u0003\u0005\u0002\u001b\u0011I!!C\u0001\u0019\u0005a\r\u0011kA\u0001\u0006\u0001%ZA!\u0011\u0005\t\n5)\u0011BA\u0005\u00021\ta\t\u0001g\u0001R\u0007\u0005)\u0001!K\u0007\u0005\u0003rA)\"\u0004\u0004\n\u0007%\u0011A\u0012\u0001\r\u0003\u0019\u0003Az!U\u0002\u0003\u000b\u0005A1\u0002"}, strings={"Lorg/jetbrains/debugger/sourcemap/SourceResolver;", "", "rawSources", "", "", "trimFileScheme", "", "baseFileUrl", "Lcom/intellij/util/Url;", "sourceContents", "baseUrlIsFile", "(Ljava/util/List;ZLcom/intellij/util/Url;Ljava/util/List;Z)V", "absoluteLocalPathToSourceIndex", "Lgnu/trove/TObjectIntHashMap;", "canonicalizedSources", "", "getCanonicalizedSources$script_debugger_backend", "()[Lcom/intellij/util/Url;", "[Lcom/intellij/util/Url;", "canonicalizedSourcesMap", "Lcom/intellij/util/containers/ObjectIntHashMap;", "sourceIndexToAbsoluteLocalPath", "[Ljava/lang/String;", "canonicalizeUrl", "url", "baseUrl", "sourceIndex", "", "findByFile", "Lorg/jetbrains/debugger/sourcemap/MappingList;", "sourceMap", "Lorg/jetbrains/debugger/sourcemap/SourceMap;", "sourceFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "findMappings", "resolver", "Lorg/jetbrains/debugger/sourcemap/SourceResolver$Resolver;", "sourceUrls", "getLocalFilePath", "entry", "Lorg/jetbrains/debugger/sourcemap/MappingEntry;", "getRawSource", "getSource", "getSourceContent", "getSourceIndex", "Companion", "Resolver"}, moduleName="script-debugger-backend")
public class SourceResolver {
    private final ObjectIntHashMap<Url> canonicalizedSourcesMap;
    @NotNull
    private final Url[] canonicalizedSources;
    private TObjectIntHashMap<String> absoluteLocalPathToSourceIndex;
    private String[] sourceIndexToAbsoluteLocalPath;
    private final List<? extends String> rawSources;
    private final List<? extends String> sourceContents;
    public static final Companion Companion = org.jetbrains.debugger.sourcemap.SourceResolver$Companion.INSTANCE;

    @NotNull
    public final Url[] getCanonicalizedSources$script_debugger_backend() {
        return this.canonicalizedSources;
    }

    @NotNull
    protected Url canonicalizeUrl(@NotNull String url, @Nullable Url baseUrl, boolean trimFileScheme, int sourceIndex, boolean baseUrlIsFile) {
        VirtualFile file;
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        if (trimFileScheme && StringsKt.startsWith$default((String)url, (String)"file://", (boolean)false, (int)2)) {
            Url url2 = Urls.newLocalFileUrl(FileUtil.toCanonicalPath((String)StringsKt.substring((String)VfsUtilCore.toIdeaUrl((String)url, (boolean)true), (int)"file://".length()), (char)'/'));
            Intrinsics.checkExpressionValueIsNotNull((Object)url2, (String)"Urls.newLocalFileUrl(Fil\u2026COL_PREFIX.length), '/'))");
            return url2;
        }
        if (baseUrl == null || StringsKt.contains$default((CharSequence)url, (CharSequence)"://", (boolean)false, (int)2) || StringsKt.startsWith$default((String)url, (String)"data:", (boolean)false, (int)2) || StringsKt.startsWith$default((String)url, (String)"blob:", (boolean)false, (int)2) || StringsKt.startsWith$default((String)url, (String)"javascript:", (boolean)false, (int)2)) {
            Url url3 = Urls.parseEncoded(url);
            if (url3 == null) {
                url3 = new UrlImpl(url);
            }
            return url3;
        }
        String path = Companion.canonicalizePath(url, baseUrl, baseUrlIsFile);
        if (baseUrl.getScheme() == null && baseUrl.isInLocalFileSystem()) {
            Url url4 = Urls.newLocalFileUrl(path);
            Intrinsics.checkExpressionValueIsNotNull((Object)url4, (String)"Urls.newLocalFileUrl(path)");
            return url4;
        }
        if (Companion.isAbsolute(path) && (file = LocalFileFinder.findFile(path)) != null) {
            if (this.absoluteLocalPathToSourceIndex == null) {
                this.absoluteLocalPathToSourceIndex = (TObjectIntHashMap)SourceResolverKt.access$createStringIntMap(this.rawSources.size());
                this.sourceIndexToAbsoluteLocalPath = new String[this.rawSources.size()];
            }
            TObjectIntHashMap<String> tObjectIntHashMap = this.absoluteLocalPathToSourceIndex;
            if (tObjectIntHashMap == null) {
                Intrinsics.throwNpe();
            }
            tObjectIntHashMap.put((Object)path, sourceIndex);
            if (this.sourceIndexToAbsoluteLocalPath == null) {
                Intrinsics.throwNpe();
            }
            this.sourceIndexToAbsoluteLocalPath[sourceIndex] = path;
            String canonicalPath = file.getCanonicalPath();
            if (canonicalPath != null && Intrinsics.areEqual((Object)canonicalPath, (Object)path) ^ true) {
                TObjectIntHashMap<String> tObjectIntHashMap2 = this.absoluteLocalPathToSourceIndex;
                if (tObjectIntHashMap2 == null) {
                    Intrinsics.throwNpe();
                }
                tObjectIntHashMap2.put((Object)canonicalPath, sourceIndex);
            }
            Url url5 = Urls.newLocalFileUrl(path);
            Intrinsics.checkExpressionValueIsNotNull((Object)url5, (String)"Urls.newLocalFileUrl(path)");
            return url5;
        }
        return new UrlImpl(baseUrl.getScheme(), baseUrl.getAuthority(), path, null);
    }

    @Nullable
    public final Url getSource(@NotNull MappingEntry entry) {
        Intrinsics.checkParameterIsNotNull((Object)entry, (String)"entry");
        int index = entry.getSource();
        return index < 0 ? (Url)null : this.canonicalizedSources[index];
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    public final String getSourceContent(@NotNull MappingEntry entry) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)entry, (String)"entry");
        if (UtilKt.isNullOrEmpty(this.sourceContents)) {
            return null;
        }
        int index = entry.getSource();
        if (index >= 0) {
            List<? extends String> list = this.sourceContents;
            if (list == null) {
                Intrinsics.throwNpe();
            }
            if (index < list.size()) {
                string = this.sourceContents.get(index);
                return string;
            }
        }
        string = null;
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    public final String getSourceContent(int sourceIndex) {
        String string;
        if (UtilKt.isNullOrEmpty(this.sourceContents)) {
            return null;
        }
        if (sourceIndex >= 0) {
            List<? extends String> list = this.sourceContents;
            if (list == null) {
                Intrinsics.throwNpe();
            }
            if (sourceIndex < list.size()) {
                string = this.sourceContents.get(sourceIndex);
                return string;
            }
        }
        string = null;
        return string;
    }

    public final int getSourceIndex(@NotNull Url url) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        return ArrayUtil.indexOf((Object[])this.canonicalizedSources, (Object)url);
    }

    @Nullable
    public final String getRawSource(@NotNull MappingEntry entry) {
        Intrinsics.checkParameterIsNotNull((Object)entry, (String)"entry");
        int index = entry.getSource();
        return index < 0 ? (String)null : this.rawSources.get(index);
    }

    @Nullable
    public final String getLocalFilePath(@NotNull MappingEntry entry) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)entry, (String)"entry");
        int index = entry.getSource();
        if (index < 0 || this.sourceIndexToAbsoluteLocalPath == null) {
            string = null;
        } else {
            if (this.sourceIndexToAbsoluteLocalPath == null) {
                Intrinsics.throwNpe();
            }
            string = this.sourceIndexToAbsoluteLocalPath[index];
        }
        return string;
    }

    @Nullable
    public final MappingList findMappings(@Nullable VirtualFile sourceFile, @NotNull SourceMap sourceMap, @NotNull Resolver resolver) {
        Intrinsics.checkParameterIsNotNull((Object)sourceMap, (String)"sourceMap");
        Intrinsics.checkParameterIsNotNull((Object)resolver, (String)"resolver");
        int index = resolver.resolve(sourceFile, this.canonicalizedSourcesMap);
        return index < 0 ? (MappingList)null : sourceMap.getSourceIndexToMappings$script_debugger_backend()[index];
    }

    @Nullable
    public final MappingList findMappings(@NotNull List<? extends Url> sourceUrls, @NotNull SourceMap sourceMap, @Nullable VirtualFile sourceFile) {
        MappingList mappingList;
        Intrinsics.checkParameterIsNotNull(sourceUrls, (String)"sourceUrls");
        Intrinsics.checkParameterIsNotNull((Object)sourceMap, (String)"sourceMap");
        for (Url url : sourceUrls) {
            int index = this.canonicalizedSourcesMap.get((Object)url);
            if (index == -1) continue;
            return sourceMap.getSourceIndexToMappings$script_debugger_backend()[index];
        }
        if (sourceFile != null && (mappingList = this.findByFile(sourceMap, sourceFile)) != null) {
            return mappingList;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final MappingList findByFile(SourceMap sourceMap, VirtualFile sourceFile) {
        MappingList mappings = null;
        if (this.absoluteLocalPathToSourceIndex != null && sourceFile.isInLocalFileSystem()) {
            String sourceFileCanonicalPath;
            TObjectIntHashMap<String> tObjectIntHashMap = this.absoluteLocalPathToSourceIndex;
            if (tObjectIntHashMap == null) {
                Intrinsics.throwNpe();
            }
            if ((mappings = SourceResolver.Companion.getMappingsBySource(sourceMap, tObjectIntHashMap.get((Object)sourceFile.getPath()))) == null && (sourceFileCanonicalPath = sourceFile.getCanonicalPath()) != null) {
                TObjectIntHashMap<String> tObjectIntHashMap2 = this.absoluteLocalPathToSourceIndex;
                if (tObjectIntHashMap2 == null) {
                    Intrinsics.throwNpe();
                }
                mappings = SourceResolver.Companion.getMappingsBySource(sourceMap, tObjectIntHashMap2.get((Object)sourceFileCanonicalPath));
            }
        }
        if (mappings == null) {
            int n;
            int index = this.canonicalizedSourcesMap.get((Object)Urls.newFromVirtualFile(sourceFile).trimParameters());
            if (index != -1) {
                return sourceMap.getSourceIndexToMappings$script_debugger_backend()[index];
            }
            IntRange intRange = ArraysKt.getIndices((Object[])this.canonicalizedSources);
            int n2 = ((Number)intRange.getStart()).intValue();
            if (n2 <= (n = ((Number)intRange.getEnd()).intValue())) {
                while (true) {
                    void i;
                    Url url;
                    if (Urls.equalsIgnoreParameters(url = this.canonicalizedSources[i], sourceFile)) {
                        return sourceMap.getSourceIndexToMappings$script_debugger_backend()[i];
                    }
                    VirtualFile canonicalFile = sourceFile.getCanonicalFile();
                    if (canonicalFile != null && Intrinsics.areEqual((Object)canonicalFile, (Object)sourceFile) ^ true && Urls.equalsIgnoreParameters(url, canonicalFile)) {
                        return sourceMap.getSourceIndexToMappings$script_debugger_backend()[i];
                    }
                    if (i == n) break;
                    ++i;
                }
            }
        }
        return mappings;
    }

    /*
     * WARNING - void declaration
     */
    public SourceResolver(@NotNull List<? extends String> rawSources, boolean trimFileScheme, @Nullable Url baseFileUrl, @Nullable List<? extends String> sourceContents, boolean baseUrlIsFile) {
        Object[] objectArray;
        void size;
        Intrinsics.checkParameterIsNotNull(rawSources, (String)"rawSources");
        this.rawSources = rawSources;
        this.sourceContents = sourceContents;
        this.canonicalizedSourcesMap = SystemInfo.isFileSystemCaseSensitive ? new ObjectIntHashMap(this.rawSources.size()) : new ObjectIntHashMap(this.rawSources.size(), Urls.getCaseInsensitiveUrlHashingStrategy());
        int n = this.rawSources.size();
        SourceResolver sourceResolver = this;
        Url[] result2 = new Url[size];
        boolean bl = false;
        void var9_10 = size - true;
        if (bl <= var9_10) {
            void i;
            do {
                void i2;
                void var10_11 = ++i;
                void var17_15 = i;
                objectArray = result2;
                String rawSource = this.rawSources.get((int)i2);
                Url url = this.canonicalizeUrl(rawSource, baseFileUrl, trimFileScheme, (int)i2, baseUrlIsFile);
                this.canonicalizedSourcesMap.put((Object)url, (int)i2);
                Url url2 = url;
                objectArray[var17_15] = url2;
            } while (i != var9_10);
        }
        objectArray = result2;
        sourceResolver.canonicalizedSources = (Url[])objectArray;
    }

    public /* synthetic */ SourceResolver(List list, boolean bl, Url url, List list2, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            bl2 = true;
        }
        this(list, bl, url, list2, bl2);
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"\u001f\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0001!B\u0001\t\t\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u00031\tAa\r\u0007\u00013\u0005A\n!\n\t\u0005'!\tQ\"\u0001M\u00023\u0011A!!\u0004\u0002\r\u0002a\u0015\u0011D\u0002\u0005\u0004\u001b\u0011I!!C\u0001\u0019\ta\u001d\u0001"}, strings={"Lorg/jetbrains/debugger/sourcemap/SourceResolver$Resolver;", "", "resolve", "", "sourceFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "map", "Lcom/intellij/util/containers/ObjectIntHashMap;", "Lcom/intellij/util/Url;"}, moduleName="script-debugger-backend")
    public static interface Resolver {
        public int resolve(@Nullable VirtualFile var1, @NotNull ObjectIntHashMap<Url> var2);
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"5\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u0003!9Q!\u0001\u0003\u0002\u000b\u0005a\u0011!\u0002\u0001\u0006\u0003!-Q\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0005\u0005\u000b\u0005!\u0011\u0001Bb\u0002\u0019\u0001I\u0012\u0001'\u0001\"\b\u0011\t\u0011kA\u0001\t\u0003\u0015z\u00012A\u0007\u00021\tI2\u0001#\u0002\u000e\u0003a\u0011\u0011d\u0001\u0005\u0004\u001b\u0005A:!G\u0002\t\t5\t\u0001\u0014B\u0013\u000e\t\u0005AQ!\u0004\u0002\r\u0002a-\u0011d\u0001\u0005\u0007\u001b\u0005Aj!G\u0002\t\u000f5\t\u0001tB\u0013\b\u0011!i\u0011\u0001'\u0003\u001a\u0007!EQ\"\u0001\r\u0003"}, strings={"Lorg/jetbrains/debugger/sourcemap/SourceResolver$Companion;", "", "()V", "canonicalizePath", "", "url", "baseUrl", "Lcom/intellij/util/Url;", "baseUrlIsFile", "", "getMappingsBySource", "Lorg/jetbrains/debugger/sourcemap/MappingList;", "sourceMap", "Lorg/jetbrains/debugger/sourcemap/SourceMap;", "index", "", "isAbsolute", "path"}, moduleName="script-debugger-backend")
    public static final class Companion {
        public static final Companion INSTANCE;

        public final boolean isAbsolute(@NotNull String path) {
            Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
            return !StringsKt.isEmpty((CharSequence)path) && (path.charAt(0) == '/' || SystemInfo.isWindows && path.length() > 2 && path.charAt(1) == ':');
        }

        @NotNull
        public final String canonicalizePath(@NotNull String url, @NotNull Url baseUrl, boolean baseUrlIsFile) {
            Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
            Intrinsics.checkParameterIsNotNull((Object)baseUrl, (String)"baseUrl");
            String path = url;
            if (url.charAt(0) != '/') {
                String basePath = baseUrl.getPath();
                if (baseUrlIsFile) {
                    int lastSlashIndex = StringsKt.lastIndexOf$default((CharSequence)basePath, (char)'/', (int)0, (boolean)false, (int)6);
                    StringBuilder pathBuilder = new StringBuilder();
                    if (lastSlashIndex == -1) {
                        pathBuilder.append('/');
                    } else {
                        pathBuilder.append(basePath, 0, lastSlashIndex + 1);
                    }
                    String string = pathBuilder.append(url).toString();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"pathBuilder.append(url).toString()");
                    path = string;
                } else {
                    path = basePath + "/" + url;
                }
            }
            String string = FileUtil.toCanonicalPath((String)path, (char)'/');
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"FileUtil.toCanonicalPath(path, '/')");
            path = string;
            return path;
        }

        private final MappingList getMappingsBySource(SourceMap sourceMap, int index) {
            return index == -1 ? (MappingList)null : sourceMap.getSourceIndexToMappings$script_debugger_backend()[index];
        }

        static {
            new Companion();
        }

        private Companion() {
            INSTANCE = this;
        }
    }
}

