/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.debugger.breakpoints;

import com.intellij.debugger.InstanceFilter;
import com.intellij.debugger.ui.breakpoints.EditClassFiltersDialog;
import com.intellij.debugger.ui.breakpoints.EditInstanceFiltersDialog;
import com.intellij.ide.util.ClassFilter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.ui.FieldPanel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.MultiLineTooltipUI;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointCustomPropertiesPanel;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointBase;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToolTip;
import javax.swing.ToolTipManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.java.debugger.breakpoints.properties.JavaBreakpointProperties;

public class JavaBreakpointFiltersPanel<T extends JavaBreakpointProperties, B extends XBreakpoint<T>>
extends XBreakpointCustomPropertiesPanel<B> {
    private JPanel myConditionsPanel;
    private JPanel myInstanceFiltersPanel;
    private JCheckBox myInstanceFiltersCheckBox;
    private JPanel myInstanceFiltersFieldPanel;
    private JPanel myClassFiltersPanel;
    private JCheckBox myClassFiltersCheckBox;
    private JPanel myClassFiltersFieldPanel;
    private JPanel myPassCountPanel;
    private JCheckBox myPassCountCheckbox;
    private JTextField myPassCountField;
    private final FieldPanel myInstanceFiltersField;
    private final FieldPanel myClassFiltersField;
    private com.intellij.ui.classFilter.ClassFilter[] myClassFilters = com.intellij.ui.classFilter.ClassFilter.EMPTY_ARRAY;
    private com.intellij.ui.classFilter.ClassFilter[] myClassExclusionFilters = com.intellij.ui.classFilter.ClassFilter.EMPTY_ARRAY;
    private InstanceFilter[] myInstanceFilters = InstanceFilter.EMPTY_ARRAY;
    protected final Project myProject;
    private PsiClass myBreakpointPsiClass;

    public JavaBreakpointFiltersPanel(Project project) {
        this.myProject = project;
        this.$$$setupUI$$$();
        this.myInstanceFiltersField = new FieldPanel((JTextField)new MyTextField(), "", null, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JavaBreakpointFiltersPanel.this.reloadInstanceFilters();
                EditInstanceFiltersDialog _dialog = new EditInstanceFiltersDialog(JavaBreakpointFiltersPanel.this.myProject);
                _dialog.setFilters(JavaBreakpointFiltersPanel.this.myInstanceFilters);
                _dialog.show();
                if (_dialog.getExitCode() == 0) {
                    JavaBreakpointFiltersPanel.access$102(JavaBreakpointFiltersPanel.this, _dialog.getFilters());
                    JavaBreakpointFiltersPanel.this.updateInstanceFilterEditor(true);
                }
            }
        }, null);
        this.myClassFiltersField = new FieldPanel((JTextField)new MyTextField(), "", null, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JavaBreakpointFiltersPanel.this.reloadClassFilters();
                ClassFilter classFilter = JavaBreakpointFiltersPanel.this.createClassConditionFilter();
                EditClassFiltersDialog _dialog = new EditClassFiltersDialog(JavaBreakpointFiltersPanel.this.myProject, classFilter);
                _dialog.setFilters(JavaBreakpointFiltersPanel.this.myClassFilters, JavaBreakpointFiltersPanel.this.myClassExclusionFilters);
                _dialog.show();
                if (_dialog.getExitCode() == 0) {
                    JavaBreakpointFiltersPanel.access$402(JavaBreakpointFiltersPanel.this, _dialog.getFilters());
                    JavaBreakpointFiltersPanel.access$502(JavaBreakpointFiltersPanel.this, _dialog.getExclusionFilters());
                    JavaBreakpointFiltersPanel.this.updateClassFilterEditor(true);
                }
            }
        }, null);
        ActionListener updateListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JavaBreakpointFiltersPanel.this.updateCheckboxes();
            }
        };
        this.myPassCountCheckbox.addActionListener(updateListener);
        this.myInstanceFiltersCheckBox.addActionListener(updateListener);
        this.myClassFiltersCheckBox.addActionListener(updateListener);
        ToolTipManager.sharedInstance().registerComponent(this.myClassFiltersField.getTextField());
        ToolTipManager.sharedInstance().registerComponent(this.myInstanceFiltersField.getTextField());
        JavaBreakpointFiltersPanel.insert(this.myInstanceFiltersFieldPanel, (JComponent)this.myInstanceFiltersField);
        JavaBreakpointFiltersPanel.insert(this.myClassFiltersFieldPanel, (JComponent)this.myClassFiltersField);
        DebuggerUIUtil.focusEditorOnCheck(this.myPassCountCheckbox, this.myPassCountField);
        DebuggerUIUtil.focusEditorOnCheck(this.myInstanceFiltersCheckBox, this.myInstanceFiltersField.getTextField());
        DebuggerUIUtil.focusEditorOnCheck(this.myClassFiltersCheckBox, this.myClassFiltersField.getTextField());
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myConditionsPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/java/debugger/breakpoints/JavaBreakpointFiltersPanel", "getComponent"));
        }
        return jPanel;
    }

    public boolean isVisibleOnPopup(@NotNull B breakpoint) {
        if (breakpoint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakpoint", "org/jetbrains/java/debugger/breakpoints/JavaBreakpointFiltersPanel", "isVisibleOnPopup"));
        }
        JavaBreakpointProperties properties = (JavaBreakpointProperties)breakpoint.getProperties();
        if (properties != null) {
            return properties.isCOUNT_FILTER_ENABLED() || properties.isCLASS_FILTERS_ENABLED() || properties.isINSTANCE_FILTERS_ENABLED();
        }
        return false;
    }

    public void saveTo(@NotNull B breakpoint) {
        if (breakpoint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakpoint", "org/jetbrains/java/debugger/breakpoints/JavaBreakpointFiltersPanel", "saveTo"));
        }
        JavaBreakpointProperties properties = (JavaBreakpointProperties)breakpoint.getProperties();
        if (properties == null) {
            return;
        }
        boolean changed = false;
        try {
            int filter;
            String text = this.myPassCountField.getText().trim();
            int n = filter = !text.isEmpty() ? Integer.parseInt(text) : 0;
            if (filter < 0) {
                filter = 0;
            }
            changed = properties.setCOUNT_FILTER(filter);
        }
        catch (Exception exception) {
            // empty catch block
        }
        changed = properties.setCOUNT_FILTER_ENABLED(properties.getCOUNT_FILTER() > 0 && this.myPassCountCheckbox.isSelected()) || changed;
        this.reloadInstanceFilters();
        this.reloadClassFilters();
        this.updateInstanceFilterEditor(true);
        this.updateClassFilterEditor(true);
        changed = properties.setINSTANCE_FILTERS_ENABLED(this.myInstanceFiltersField.getText().length() > 0 && this.myInstanceFiltersCheckBox.isSelected()) || changed;
        changed = properties.setCLASS_FILTERS_ENABLED(this.myClassFiltersField.getText().length() > 0 && this.myClassFiltersCheckBox.isSelected()) || changed;
        changed = properties.setClassFilters(this.myClassFilters) || changed;
        changed = properties.setClassExclusionFilters(this.myClassExclusionFilters) || changed;
        boolean bl = changed = properties.setInstanceFilters(this.myInstanceFilters) || changed;
        if (changed) {
            ((XBreakpointBase)breakpoint).fireBreakpointChanged();
        }
    }

    private static void insert(JPanel panel, JComponent component) {
        panel.setLayout(new BorderLayout());
        panel.add((Component)component, "Center");
    }

    public void loadFrom(@NotNull B breakpoint) {
        if (breakpoint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakpoint", "org/jetbrains/java/debugger/breakpoints/JavaBreakpointFiltersPanel", "loadFrom"));
        }
        JavaBreakpointProperties properties = (JavaBreakpointProperties)breakpoint.getProperties();
        if (properties != null) {
            if (properties.getCOUNT_FILTER() > 0) {
                this.myPassCountField.setText(Integer.toString(properties.getCOUNT_FILTER()));
            } else {
                this.myPassCountField.setText("");
            }
            this.myPassCountCheckbox.setSelected(properties.isCOUNT_FILTER_ENABLED());
            this.myInstanceFiltersCheckBox.setSelected(properties.isINSTANCE_FILTERS_ENABLED());
            this.myInstanceFiltersField.setEnabled(properties.isINSTANCE_FILTERS_ENABLED());
            this.myInstanceFiltersField.getTextField().setEditable(properties.isINSTANCE_FILTERS_ENABLED());
            this.myInstanceFilters = properties.getInstanceFilters();
            this.updateInstanceFilterEditor(true);
            this.myClassFiltersCheckBox.setSelected(properties.isCLASS_FILTERS_ENABLED());
            this.myClassFiltersField.setEnabled(properties.isCLASS_FILTERS_ENABLED());
            this.myClassFiltersField.getTextField().setEditable(properties.isCLASS_FILTERS_ENABLED());
            this.myClassFilters = properties.getClassFilters();
            this.myClassExclusionFilters = properties.getClassExclusionFilters();
            this.updateClassFilterEditor(true);
            XSourcePosition xSourcePosition = breakpoint.getSourcePosition();
        }
        this.updateCheckboxes();
    }

    private void updateInstanceFilterEditor(boolean updateText) {
        ArrayList<String> filters = new ArrayList<String>();
        for (InstanceFilter instanceFilter : this.myInstanceFilters) {
            if (!instanceFilter.isEnabled()) continue;
            filters.add(Long.toString(instanceFilter.getId()));
        }
        if (updateText) {
            this.myInstanceFiltersField.setText(StringUtil.join(filters, (String)" "));
        }
        String tipText = JavaBreakpointFiltersPanel.concatWithEx(filters, " ", (int)Math.sqrt(this.myInstanceFilters.length) + 1, "\n");
        this.myInstanceFiltersField.getTextField().setToolTipText(tipText);
    }

    private void reloadClassFilters() {
        String filtersText = this.myClassFiltersField.getText();
        ArrayList<com.intellij.ui.classFilter.ClassFilter> classFilters = new ArrayList<com.intellij.ui.classFilter.ClassFilter>();
        ArrayList<com.intellij.ui.classFilter.ClassFilter> exclusionFilters = new ArrayList<com.intellij.ui.classFilter.ClassFilter>();
        int startFilter = -1;
        for (int i = 0; i <= filtersText.length(); ++i) {
            if (i < filtersText.length() && !Character.isWhitespace(filtersText.charAt(i))) {
                if (startFilter != -1) continue;
                startFilter = i;
                continue;
            }
            if (startFilter < 0) continue;
            if (filtersText.charAt(startFilter) == '-') {
                exclusionFilters.add(new com.intellij.ui.classFilter.ClassFilter(filtersText.substring(startFilter + 1, i)));
            } else {
                classFilters.add(new com.intellij.ui.classFilter.ClassFilter(filtersText.substring(startFilter, i)));
            }
            startFilter = -1;
        }
        for (com.intellij.ui.classFilter.ClassFilter classFilter : this.myClassFilters) {
            if (classFilter.isEnabled()) continue;
            classFilters.add(classFilter);
        }
        for (com.intellij.ui.classFilter.ClassFilter classFilter : this.myClassExclusionFilters) {
            if (classFilter.isEnabled()) continue;
            exclusionFilters.add(classFilter);
        }
        this.myClassFilters = classFilters.toArray(new com.intellij.ui.classFilter.ClassFilter[classFilters.size()]);
        this.myClassExclusionFilters = exclusionFilters.toArray(new com.intellij.ui.classFilter.ClassFilter[exclusionFilters.size()]);
    }

    private void reloadInstanceFilters() {
        String filtersText = this.myInstanceFiltersField.getText();
        ArrayList<InstanceFilter> idxs = new ArrayList<InstanceFilter>();
        int startNumber = -1;
        for (int i = 0; i <= filtersText.length(); ++i) {
            if (i < filtersText.length() && Character.isDigit(filtersText.charAt(i))) {
                if (startNumber != -1) continue;
                startNumber = i;
                continue;
            }
            if (startNumber < 0) continue;
            idxs.add(InstanceFilter.create(filtersText.substring(startNumber, i)));
            startNumber = -1;
        }
        for (InstanceFilter instanceFilter : this.myInstanceFilters) {
            if (instanceFilter.isEnabled()) continue;
            idxs.add(instanceFilter);
        }
        this.myInstanceFilters = idxs.toArray(new InstanceFilter[idxs.size()]);
    }

    private void updateClassFilterEditor(boolean updateText) {
        ArrayList<String> filters = new ArrayList<String>();
        for (com.intellij.ui.classFilter.ClassFilter classFilter : this.myClassFilters) {
            if (!classFilter.isEnabled()) continue;
            filters.add(classFilter.getPattern());
        }
        ArrayList<String> excludeFilters = new ArrayList<String>();
        for (com.intellij.ui.classFilter.ClassFilter classFilter : this.myClassExclusionFilters) {
            if (!classFilter.isEnabled()) continue;
            excludeFilters.add("-" + classFilter.getPattern());
        }
        if (updateText) {
            String editorText = StringUtil.join(filters, (String)" ");
            if (!filters.isEmpty()) {
                editorText = editorText + " ";
            }
            editorText = editorText + StringUtil.join(excludeFilters, (String)" ");
            this.myClassFiltersField.setText(editorText);
        }
        int width = (int)Math.sqrt(this.myClassExclusionFilters.length + this.myClassFilters.length) + 1;
        String tipText = JavaBreakpointFiltersPanel.concatWithEx(filters, " ", width, "\n");
        if (!filters.isEmpty()) {
            tipText = tipText + "\n";
        }
        tipText = tipText + JavaBreakpointFiltersPanel.concatWithEx(excludeFilters, " ", width, "\n");
        this.myClassFiltersField.getTextField().setToolTipText(tipText);
    }

    private static String concatWithEx(List<String> s, String concator, int N, String NthConcator) {
        String result2 = "";
        int i = 1;
        Iterator<String> iterator = s.iterator();
        while (iterator.hasNext()) {
            String str = iterator.next();
            result2 = result2 + str;
            if (iterator.hasNext()) {
                result2 = i % N == 0 ? result2 + NthConcator : result2 + concator;
            }
            ++i;
        }
        return result2;
    }

    protected ClassFilter createClassConditionFilter() {
        ClassFilter classFilter = this.myBreakpointPsiClass != null ? new ClassFilter(){

            public boolean isAccepted(PsiClass aClass) {
                return JavaBreakpointFiltersPanel.this.myBreakpointPsiClass == aClass || aClass.isInheritor(JavaBreakpointFiltersPanel.this.myBreakpointPsiClass, true);
            }
        } : null;
        return classFilter;
    }

    protected void updateCheckboxes() {
        boolean passCountApplicable = true;
        if (this.myInstanceFiltersCheckBox.isSelected() || this.myClassFiltersCheckBox.isSelected()) {
            passCountApplicable = false;
        }
        this.myPassCountCheckbox.setEnabled(passCountApplicable);
        boolean passCountSelected = this.myPassCountCheckbox.isSelected();
        this.myInstanceFiltersCheckBox.setEnabled(!passCountSelected);
        this.myClassFiltersCheckBox.setEnabled(!passCountSelected);
        this.myPassCountField.setEditable(this.myPassCountCheckbox.isSelected());
        this.myPassCountField.setEnabled(this.myPassCountCheckbox.isSelected());
        this.myInstanceFiltersField.setEnabled(this.myInstanceFiltersCheckBox.isSelected());
        this.myInstanceFiltersField.getTextField().setEditable(this.myInstanceFiltersCheckBox.isSelected());
        this.myClassFiltersField.setEnabled(this.myClassFiltersCheckBox.isSelected());
        this.myClassFiltersField.getTextField().setEditable(this.myClassFiltersCheckBox.isSelected());
    }

    static /* synthetic */ InstanceFilter[] access$102(JavaBreakpointFiltersPanel x0, InstanceFilter[] x1) {
        x0.myInstanceFilters = x1;
        return x1;
    }

    static /* synthetic */ com.intellij.ui.classFilter.ClassFilter[] access$402(JavaBreakpointFiltersPanel x0, com.intellij.ui.classFilter.ClassFilter[] x1) {
        x0.myClassFilters = x1;
        return x1;
    }

    static /* synthetic */ com.intellij.ui.classFilter.ClassFilter[] access$502(JavaBreakpointFiltersPanel x0, com.intellij.ui.classFilter.ClassFilter[] x1) {
        x0.myClassExclusionFilters = x1;
        return x1;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JCheckBox jCheckBox;
        JPanel jPanel;
        JPanel jPanel2;
        JCheckBox jCheckBox2;
        JPanel jPanel3;
        JPanel jPanel4;
        JCheckBox jCheckBox3;
        JPanel jPanel5;
        JPanel jPanel6;
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myConditionsPanel = jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(2, 2, 5, 5), -1, 7, false, false));
        jPanel6.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel7.add((Component)jPanel6, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 3, null, null, null));
        jPanel6.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)ResourceBundle.getBundle("messages/DebuggerBundle").getString("label.breakpoint.properties.panel.group.conditions"), (int)0, (int)0, null, null));
        this.myInstanceFiltersPanel = jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, 0, false, false));
        jPanel6.add((Component)jPanel5, new GridConstraints(0, 0, 1, 2, 0, 1, 3, 3, null, null, null));
        this.myInstanceFiltersCheckBox = jCheckBox3 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox3, ResourceBundle.getBundle("messages/DebuggerBundle").getString("breakpoint.properties.panel.option.instance.filters"));
        jCheckBox3.setMargin(new Insets(2, 2, 0, 2));
        jPanel5.add((Component)jCheckBox3, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel8, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel8.add((Component)spacer, new GridConstraints(0, 0, 1, 1, 0, 1, 0, 1, null, new Dimension(15, -1), null));
        this.myInstanceFiltersFieldPanel = jPanel4 = new JPanel();
        jPanel8.add((Component)jPanel4, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        this.myClassFiltersPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, 0, false, false));
        jPanel6.add((Component)jPanel3, new GridConstraints(1, 0, 1, 2, 0, 1, 3, 3, null, null, null));
        this.myClassFiltersCheckBox = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("messages/DebuggerBundle").getString("breakpoint.properties.panel.option.class.filters"));
        jCheckBox2.setMargin(new Insets(2, 2, 0, 2));
        jPanel3.add((Component)jCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel9, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myClassFiltersFieldPanel = jPanel2 = new JPanel();
        jPanel9.add((Component)jPanel2, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel9.add((Component)spacer2, new GridConstraints(0, 0, 1, 1, 0, 1, 0, 1, null, new Dimension(15, -1), null));
        this.myPassCountPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, 0, false, false));
        jPanel6.add((Component)jPanel, new GridConstraints(2, 0, 1, 2, 0, 1, 7, 3, null, null, null));
        this.myPassCountCheckbox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/DebuggerBundle").getString("breakpoint.properties.panel.option.pass.count"));
        jCheckBox.setMargin(new Insets(2, 2, 0, 2));
        jPanel.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel10, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myPassCountField = jTextField = new JTextField();
        ((Component)jTextField).setEnabled(false);
        jTextField.setHorizontalAlignment(10);
        jPanel10.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(15, -1), null));
        Spacer spacer3 = new Spacer();
        jPanel10.add((Component)spacer3, new GridConstraints(0, 0, 1, 1, 0, 1, 0, 1, null, new Dimension(15, -1), null));
        Spacer spacer4 = new Spacer();
        jPanel6.add((Component)spacer4, new GridConstraints(3, 1, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private class MyTextField
    extends JTextField {
        @Override
        public String getToolTipText(MouseEvent event) {
            JavaBreakpointFiltersPanel.this.reloadClassFilters();
            JavaBreakpointFiltersPanel.this.updateClassFilterEditor(false);
            JavaBreakpointFiltersPanel.this.reloadInstanceFilters();
            JavaBreakpointFiltersPanel.this.updateInstanceFilterEditor(false);
            String toolTipText = super.getToolTipText(event);
            return this.getToolTipText().length() == 0 ? null : toolTipText;
        }

        @Override
        public JToolTip createToolTip() {
            JToolTip toolTip = new JToolTip(){
                {
                    this.setUI((ComponentUI)new MultiLineTooltipUI());
                }
            };
            toolTip.setComponent(this);
            return toolTip;
        }
    }
}

