/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.structure.gradle;

import com.android.tools.idea.gradle.parser.GradleBuildFile;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.structure.EditorPanel;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.ui.components.JBScrollPane;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BuildFilePanel
extends EditorPanel {
    private static final Logger LOG = Logger.getInstance(BuildFilePanel.class);
    protected final Project myProject;
    @Nullable
    protected final GradleBuildFile myGradleBuildFile;
    protected boolean myModified;
    private final JPanel myPanel;
    @Nullable
    protected final Module myModule;

    public BuildFilePanel(@NotNull Project project, @NotNull String moduleGradlePath) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/structure/gradle/BuildFilePanel", "<init>"));
        }
        if (moduleGradlePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleGradlePath", "com/android/tools/idea/structure/gradle/BuildFilePanel", "<init>"));
        }
        super(new BorderLayout());
        this.myModified = false;
        this.myPanel = new JPanel();
        JBScrollPane scrollPane = new JBScrollPane((Component)this.myPanel);
        this.add((Component)scrollPane, "Center");
        this.myProject = project;
        this.myModule = GradleUtil.findModuleByGradlePath(this.myProject, moduleGradlePath);
        GradleBuildFile gradleBuildFile = this.myGradleBuildFile = this.myModule != null ? GradleBuildFile.get(this.myModule) : null;
        if (this.myGradleBuildFile == null) {
            LOG.info("Unable to find Gradle build file for module " + moduleGradlePath);
        }
    }

    public void init() {
        this.addItems(this.myPanel);
    }

    protected abstract void addItems(@NotNull JPanel var1);

    @Override
    public boolean isModified() {
        return this.myModified;
    }
}

