/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository.git;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SmartList;
import com.intellij.util.containers.hash.LinkedHashMap;
import java.io.Closeable;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.CollectionsKt;
import kotlin.PreconditionsKt;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.eclipse.jgit.api.errors.ConcurrentRefUpdateException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.diff.Sequence;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryState;
import org.eclipse.jgit.merge.MergeResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.settingsRepository.BaseRepositoryManagerKt;
import org.jetbrains.settingsRepository.MutableUpdateResult;
import org.jetbrains.settingsRepository.git.GitExKt;
import org.jetbrains.settingsRepository.git.JGitMergeProvider;
import org.jetbrains.settingsRepository.git.JGitMergeProviderKt;
import org.jetbrains.settingsRepository.git.MergeResultEx;
import org.jetbrains.settingsRepository.git.PullKt;
import org.jetbrains.settingsRepository.git.PullKt$WhenMappings;

@KotlinFileFacade(version={1, 0, 0}, abiVersion=32, data={"M\u0015\u0001Q!\u0001\u0005\u0011\u000b\u0005Aq!\u0002\u0001\u0006\u00031\tQ!\u0001\u0005\u0001\u000b\u0001)\u0011\u0001#\t\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001C\u0001\u0006\u0003\u0011\tQ!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001\u0007\u0002\u001bo!\u0011\u0001\u0003\u0001\u000e\t%\u0011\u0011\"\u0001\r\u00021\u0003Ir\u0001c\u0001\u000e\u000b%\u0019A\u0011A\u0005\u00021\u000bA\"!\u0007\u0004\t\u00075!\u0011BA\u0005\u00021\u0011A:!G\u0002\t\n5\t\u0001$\u0002+\u0004\f5mA!\u0001\u0005\u0001\u001b\u0005Ab!G\u0002\t\u000e5\t\u0001dB\r\u0004\u0011\u0013i\u0011\u0001G\u0003U\u0007\u0017i\u0019\u0002\u0002\u0001\t\u00105\t\u0001\u0004C\r\u0004\u0011\u0013i\u0011\u0001G\u0003U\u0007\u0017iY\u0003B\u0001\t\u00125\t\u0001\u0004C\r\u0004\u0011%i\u0011\u0001g\u0005\u001a\u0007!QQ\"\u0001M\u000b3\rA1\"D\u0001\u0019\u0016e\u0019\u0001\u0012B\u0007\u00021\u0015!61BG\b\t\u0001A9\"D\u0001\u0019\u0019U\t\u0001$\u0002+\u0004\f\u0001"}, strings={"resolveConflicts", "", "", "mergeProvider", "Lorg/jetbrains/settingsRepository/git/JGitMergeProvider;", "", "unresolvedFiles", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "repository", "Lorg/eclipse/jgit/lib/Repository;", "PullKt", "Lorg/jetbrains/settingsRepository/MutableUpdateResult;", "mergeResult", "Lorg/jetbrains/settingsRepository/git/MergeResultEx;", "resolveUnmergedConflicts", "", "updateHead", "refLogMessage", "Ljava/lang/StringBuilder;", "newHeadId", "Lorg/eclipse/jgit/lib/ObjectId;", "oldHeadID", "fixAndGetState", "Lorg/eclipse/jgit/lib/RepositoryState;"}, moduleName="settings-repository")
public final class PullKt {
    private static final void updateHead(StringBuilder refLogMessage, ObjectId newHeadId, ObjectId oldHeadID, Repository repository2) {
        RefUpdate.Result rc;
        RefUpdate refUpdate = repository2.updateRef("HEAD");
        refUpdate.setNewObjectId((AnyObjectId)newHeadId);
        refUpdate.setRefLogMessage(refLogMessage.toString(), false);
        refUpdate.setExpectedOldObjectId((AnyObjectId)oldHeadID);
        RefUpdate.Result result = rc = refUpdate.update();
        if (result != null) {
            switch (PullKt$WhenMappings.$EnumSwitchMapping$0[result.ordinal()]) {
                case 1: 
                case 2: {
                    return;
                }
                case 3: 
                case 4: {
                    throw (Throwable)new ConcurrentRefUpdateException(JGitText.get().couldNotLockHEAD, refUpdate.getRef(), rc);
                }
            }
        }
        throw (Throwable)new JGitInternalException(MessageFormat.format(JGitText.get().updatingRefFailed, "HEAD", newHeadId.toString(), rc));
    }

    private static final MutableUpdateResult resolveConflicts(MergeResultEx mergeResult, Repository repository2) {
        Object[] $receiver = mergeResult.getMergedCommits();
        PreconditionsKt.assert(($receiver.length == 2 ? 1 : 0) != 0);
        Map<String, MergeResult<? extends Sequence>> map = mergeResult.getConflicts();
        if (map == null) {
            Intrinsics.throwNpe();
        }
        Map<String, MergeResult<? extends Sequence>> conflicts = map;
        JGitMergeProvider<MergeResult<? extends Sequence>> mergeProvider2 = new JGitMergeProvider<MergeResult<? extends Sequence>>(repository2, conflicts, resolveConflicts.mergeProvider.1.INSTANCE);
        List<String> mergedFiles = PullKt.resolveConflicts(mergeProvider2, JGitMergeProviderKt.conflictsToVirtualFiles(conflicts), repository2);
        return mergeResult.getResult().toMutable().addChanged((Collection<? extends String>)mergedFiles);
    }

    private static final List<String> resolveConflicts(JGitMergeProvider<? extends Object> mergeProvider2, List<VirtualFile> unresolvedFiles, Repository repository2) {
        SmartList mergedFiles = new SmartList();
        while (true) {
            List<VirtualFile> resolvedFiles = BaseRepositoryManagerKt.resolveConflicts(unresolvedFiles, mergeProvider2);
            for (VirtualFile file : resolvedFiles) {
                mergedFiles.add((Object)file.getPath());
            }
            if (resolvedFiles.size() == unresolvedFiles.size()) break;
            CollectionsKt.removeAll((Collection)unresolvedFiles, (Collection)((Collection)mergedFiles));
        }
        GitExKt.commit$default(repository2, null, null, null, null, 15);
        return (List)mergedFiles;
    }

    @NotNull
    public static final RepositoryState fixAndGetState(Repository $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        RepositoryState state = $receiver.getRepositoryState();
        if (Intrinsics.areEqual((Object)state, (Object)RepositoryState.MERGING)) {
            PullKt.resolveUnmergedConflicts($receiver);
            state = $receiver.getRepositoryState();
        }
        RepositoryState repositoryState = state;
        Intrinsics.checkExpressionValueIsNotNull((Object)repositoryState, (String)"state");
        return repositoryState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static final void resolveUnmergedConflicts(@NotNull Repository repository2) {
        Intrinsics.checkParameterIsNotNull((Object)repository2, (String)"repository");
        LinkedHashMap conflicts = new LinkedHashMap();
        Closeable $receiver = (Closeable)repository2.newObjectReader();
        boolean closed = false;
        try {
            ObjectReader reader = (ObjectReader)$receiver;
            DirCache dirCache = repository2.readDirCache();
            int n = 0;
            int n2 = dirCache.getEntryCount() - 1;
            if (n <= n2) {
                while (true) {
                    void i;
                    DirCacheEntry entry;
                    if (!(entry = dirCache.getEntry((int)i)).isMerged()) {
                        Object object;
                        void key;
                        void $receiver2;
                        Map map = (Map)conflicts;
                        String string = entry.getPathString();
                        Object value = $receiver2.get(key);
                        if (value == null && !$receiver2.containsKey(key)) {
                            byte[][] answer = new byte[3][];
                            $receiver2.put(key, answer);
                            object = answer;
                        } else {
                            object = value;
                        }
                        ((byte[][])object)[entry.getStage() - 1] = reader.open((AnyObjectId)entry.getObjectId(), 3).getCachedBytes();
                    }
                    if (i == n2) break;
                    ++i;
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Exception e) {
            closed = true;
            try {
                $receiver.close();
            }
            catch (Exception closeException) {
                // empty catch block
            }
            throw (Throwable)e;
        }
        finally {
            if (!closed) {
                $receiver.close();
            }
        }
        PullKt.resolveConflicts(new JGitMergeProvider(repository2, (Map)conflicts, resolveUnmergedConflicts.2.INSTANCE), JGitMergeProviderKt.conflictsToVirtualFiles((Map)conflicts), repository2);
    }

    @NotNull
    public static final /* synthetic */ MutableUpdateResult access$resolveConflicts(@NotNull MergeResultEx mergeResult, @NotNull Repository repository2) {
        return PullKt.resolveConflicts(mergeResult, repository2);
    }

    public static final /* synthetic */ void access$updateHead(@NotNull StringBuilder refLogMessage, @NotNull ObjectId newHeadId, @NotNull ObjectId oldHeadID, @NotNull Repository repository2) {
        PullKt.updateHead(refLogMessage, newHeadId, oldHeadID, repository2);
    }
}

