/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.WorkingCopyFormat;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminAreaFactory;
import org.tmatesoft.svn.core.internal.wc2.SvnWcGeneration;
import org.tmatesoft.svn.core.wc2.SvnOperationFactory;

public class SvnFormatSelector {
    @NotNull
    public static WorkingCopyFormat findRootAndGetFormat(File path) {
        File root = SvnUtil.getWorkingCopyRootNew(path);
        WorkingCopyFormat workingCopyFormat = root != null ? SvnFormatSelector.getWorkingCopyFormat(root) : WorkingCopyFormat.UNKNOWN;
        if (workingCopyFormat == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnFormatSelector", "findRootAndGetFormat"));
        }
        return workingCopyFormat;
    }

    @NotNull
    public static WorkingCopyFormat getWorkingCopyFormat(File path) {
        WorkingCopyFormat format = SvnUtil.getFormat(path);
        WorkingCopyFormat workingCopyFormat = WorkingCopyFormat.UNKNOWN.equals((Object)format) ? SvnFormatSelector.detectWithSvnKit(path) : format;
        if (workingCopyFormat == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnFormatSelector", "getWorkingCopyFormat"));
        }
        return workingCopyFormat;
    }

    @NotNull
    private static WorkingCopyFormat detectWithSvnKit(File path) {
        block9: {
            WorkingCopyFormat workingCopyFormat;
            try {
                SvnWcGeneration svnWcGeneration = SvnOperationFactory.detectWcGeneration((File)path, (boolean)true);
                if (!SvnWcGeneration.V17.equals((Object)svnWcGeneration)) break block9;
                workingCopyFormat = WorkingCopyFormat.ONE_DOT_SEVEN;
            }
            catch (SVNException svnWcGeneration) {
                // empty catch block
            }
            if (workingCopyFormat == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnFormatSelector", "detectWithSvnKit"));
            }
            return workingCopyFormat;
        }
        int format = 0;
        try {
            format = SVNAdminAreaFactory.checkWC((File)path, (boolean)false);
        }
        catch (SVNException sVNException) {
            // empty catch block
        }
        try {
            if (format == 0 && path.getParentFile() != null) {
                format = SVNAdminAreaFactory.checkWC((File)path.getParentFile(), (boolean)false);
            }
        }
        catch (SVNException sVNException) {
            // empty catch block
        }
        WorkingCopyFormat workingCopyFormat = WorkingCopyFormat.getInstance(format);
        if (workingCopyFormat == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnFormatSelector", "detectWithSvnKit"));
        }
        return workingCopyFormat;
    }
}

