/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.scope.processor;

import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.ResolveState;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.scope.BaseScopeProcessor;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FilterScopeProcessor<T>
extends BaseScopeProcessor {
    protected final List<T> myResults;
    private PsiElement myCurrentDeclarationHolder;
    private final ElementFilter myFilter;
    private final PsiScopeProcessor myProcessor;

    public FilterScopeProcessor(@NotNull ElementFilter filter, @NotNull List<T> container) {
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/psi/scope/processor/FilterScopeProcessor", "<init>"));
        }
        if (container == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "com/intellij/psi/scope/processor/FilterScopeProcessor", "<init>"));
        }
        this(filter, null, container);
    }

    public FilterScopeProcessor(@NotNull ElementFilter filter, @NotNull PsiScopeProcessor processor) {
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/psi/scope/processor/FilterScopeProcessor", "<init>"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/scope/processor/FilterScopeProcessor", "<init>"));
        }
        this(filter, processor, new SmartList());
    }

    public FilterScopeProcessor(@NotNull ElementFilter filter) {
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/psi/scope/processor/FilterScopeProcessor", "<init>"));
        }
        this(filter, null, new SmartList());
    }

    public FilterScopeProcessor(@NotNull ElementFilter filter, @Nullable PsiScopeProcessor processor, @NotNull List<T> container) {
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/psi/scope/processor/FilterScopeProcessor", "<init>"));
        }
        if (container == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "com/intellij/psi/scope/processor/FilterScopeProcessor", "<init>"));
        }
        this.myFilter = filter;
        this.myProcessor = processor;
        this.myResults = container;
    }

    @Override
    public void handleEvent(@NotNull PsiScopeProcessor.Event event, Object associated) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/psi/scope/processor/FilterScopeProcessor", "handleEvent"));
        }
        if (this.myProcessor != null) {
            this.myProcessor.handleEvent(event, associated);
        }
        if (event == PsiScopeProcessor.Event.SET_DECLARATION_HOLDER && associated instanceof PsiElement) {
            this.myCurrentDeclarationHolder = (PsiElement)associated;
        }
    }

    @Override
    public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/scope/processor/FilterScopeProcessor", "execute"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/psi/scope/processor/FilterScopeProcessor", "execute"));
        }
        if (this.myFilter.isAcceptable(element, this.myCurrentDeclarationHolder)) {
            if (this.myProcessor != null) {
                return this.myProcessor.execute(element, state);
            }
            this.add(element, state.get(PsiSubstitutor.KEY));
        }
        return true;
    }

    protected void add(@NotNull PsiElement element, @NotNull PsiSubstitutor substitutor2) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/scope/processor/FilterScopeProcessor", "add"));
        }
        if (substitutor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "com/intellij/psi/scope/processor/FilterScopeProcessor", "add"));
        }
        this.myResults.add(element);
    }

    public <K> K getHint(@NotNull Key<K> hintKey) {
        if (hintKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hintKey", "com/intellij/psi/scope/processor/FilterScopeProcessor", "getHint"));
        }
        if (this.myProcessor != null) {
            return this.myProcessor.getHint(hintKey);
        }
        return null;
    }

    @NotNull
    public List<T> getResults() {
        List<T> list = this.myResults;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/scope/processor/FilterScopeProcessor", "getResults"));
        }
        return list;
    }
}

