/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.ItemPresentationProviders;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.List;
import kotlin.CollectionsKt;
import kotlin.PreconditionsKt;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.EditCommaSeparatedListHelper;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassInitializer;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationContainer;
import org.jetbrains.kotlin.psi.KtDelegationSpecifier;
import org.jetbrains.kotlin.psi.KtDelegationSpecifierList;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwnerStub;
import org.jetbrains.kotlin.psi.stubs.KotlinClassOrObjectStub;
import org.jetbrains.kotlin.psi.stubs.KotlinStubWithFqName;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"\u000b\u0004)\u0011\u0001D\u0001\u0006\u00031\tQ!\u0001\u0007\u0002\u000b\u0005a\u0011!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!\u0019!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0019\u0005)\u0011\u0001b\u0001\u0006\u00031\tQ!\u0001\u0003\u0002\u000b\u0005a\u0011!B\u0001\u0005\u0003\u0015\t\u0001\"A\u0003\u0001\u000b\u0005A\u0001#B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!\u0019!B\u0001\r\u0003\u0015\tA1A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!\u0002\u0001\u0006\u0003!-Q!\u0001\u0003\u0004\tMa\u0001!\u0007\u0005\n\r%)\u0011b\u0001C\u0001\u0013\u0005A\u0002\u0001G\u0001\u0019\u0002e\t\u00014A\r\u00021\t\t{\u0001B\u0006\n\u0007!\u0015Q\"\u0001\r\u0004#\u000e\t\u0001rAQ\u0014\t-Iq\u0001\u0003\u0003\u000e\u000b%\u0019A\u0011A\u0005\u00021\u0001A\u0012!C\u0004\t\n5)\u0011\"\u0001C\u0002\u0013\u0005!\u0019\u0001G\u0003R\u0007\u0005AY!J\u0004\t\r5\t\u0001TB\r\u0004\u0011\u001di\u0011\u0001'\u0004&\u0019!=Q\"\u0001M\u00073\rAq!D\u0001\u0019\u000ee!\u0001\u0002C\u0007\u0003\u0019\u0003A\n\"\n\u0007\t\u00135\t\u0001TB\r\u0004\u0011\u001di\u0011\u0001'\u0004\u001a\t!AQB\u0001G\u00011#)s\u0001c\u0005\u000e\u0003aQ\u0011d\u0001E\u000b\u001b\u0005A\"\"\n\u0003\u0005\u0017!YQ\"\u0001M\fK\u0019AA\"\u0004\u0003\n\u0005%\t\u0001$\u0004M\rK\u0011AY\"\u0004\u0002\r\u0002aqQe\u0003\u0003\f\u0011;i\u0001\"\u0003\u0004\n\u000bAyQC\u0001G\u00011\u001bAj\u0001'\u0007&\t!}QB\u0001G\u00011A)s\u0001B\u0006\t\"5!\u0011BA\u0005\u00021)AJ\"J\u0002\t#5\t\u0001DD\u0013\u0006\t-A\u0019#\u0004\u0002\r\u0002a\u0011R\u0005\u0002E\u0013\u001b\ta\t\u0001G\n&\t!\u001dRB\u0001G\u00011Q)C\u0001#\u000b\u000e\u00051\u0005\u0001$F\u0013\u0007\u0011WiA!\u0003\u0002\n\u0003a1\u0002\u0014D\u0013\u0007\u0011[iA!\u0003\u0002\n\u0003a9\u0002\u0014D\u0013\u0004\u0011_i\u0011\u0001\u0007\r&\u0007!ER\"\u0001\r\u0019K\u0011!\u0011\u0001C\r\u000e\u0003aARe\u0001E\u001a\u001b\u0005A\u0002$J\u0002\t55\t\u0001\u0004G\u0013\u0004\u0011ki\u0011\u0001\u0007\r&\u000f!YR\"\u0001M\f3\rA)\"D\u0001\u0019\u0015\u0001"}, strings={"Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "Lorg/jetbrains/kotlin/psi/KtTypeParameterListOwnerStub;", "Lorg/jetbrains/kotlin/psi/stubs/KotlinClassOrObjectStub;", "Lorg/jetbrains/kotlin/psi/KtDeclarationContainer;", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "node", "Lcom/intellij/lang/ASTNode;", "(Lcom/intellij/lang/ASTNode;)V", "stub", "nodeType", "Lcom/intellij/psi/stubs/IStubElementType;", "(Lorg/jetbrains/kotlin/psi/stubs/KotlinClassOrObjectStub;Lcom/intellij/psi/stubs/IStubElementType;)V", "addDeclaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "declaration", "addDeclarationAfter", "anchor", "Lcom/intellij/psi/PsiElement;", "addDeclarationBefore", "addDelegationSpecifier", "Lorg/jetbrains/kotlin/psi/KtDelegationSpecifier;", "delegationSpecifier", "delete", "", "getAnonymousInitializers", "", "Lorg/jetbrains/kotlin/psi/KtClassInitializer;", "getBody", "Lorg/jetbrains/kotlin/psi/KtClassBody;", "getDeclarations", "kotlin.jvm.PlatformType", "getDelegationSpecifierList", "Lorg/jetbrains/kotlin/psi/KtDelegationSpecifierList;", "getDelegationSpecifiers", "getOrCreateBody", "getPresentation", "Lcom/intellij/navigation/ItemPresentation;", "getPrimaryConstructor", "Lorg/jetbrains/kotlin/psi/KtPrimaryConstructor;", "getPrimaryConstructorModifierList", "Lorg/jetbrains/kotlin/psi/KtModifierList;", "getPrimaryConstructorParameterList", "Lorg/jetbrains/kotlin/psi/KtParameterList;", "getPrimaryConstructorParameters", "Lorg/jetbrains/kotlin/psi/KtParameter;", "getSecondaryConstructors", "Lorg/jetbrains/kotlin/psi/KtSecondaryConstructor;", "hasExplicitPrimaryConstructor", "", "hasPrimaryConstructor", "hasSecondaryConstructors", "isAnnotation", "isLocal", "isTopLevel", "removeDelegationSpecifier"}, moduleName="kotlin-compiler")
public abstract class KtClassOrObject
extends KtTypeParameterListOwnerStub<KotlinClassOrObjectStub<? extends KtClassOrObject>>
implements KtDeclarationContainer,
KtNamedDeclaration {
    @Nullable
    public final KtDelegationSpecifierList getDelegationSpecifierList() {
        return (KtDelegationSpecifierList)this.getStubOrPsiChild((IStubElementType)KtStubElementTypes.DELEGATION_SPECIFIER_LIST);
    }

    @NotNull
    public List<KtDelegationSpecifier> getDelegationSpecifiers() {
        KtDelegationSpecifierList ktDelegationSpecifierList = this.getDelegationSpecifierList();
        return CollectionsKt.orEmpty(ktDelegationSpecifierList != null ? ktDelegationSpecifierList.getDelegationSpecifiers() : null);
    }

    @NotNull
    public final KtDelegationSpecifier addDelegationSpecifier(@NotNull KtDelegationSpecifier delegationSpecifier) {
        Intrinsics.checkParameterIsNotNull(delegationSpecifier, "delegationSpecifier");
        KtDelegationSpecifierList ktDelegationSpecifierList = this.getDelegationSpecifierList();
        if (ktDelegationSpecifierList != null) {
            KtDelegationSpecifierList $receiver = ktDelegationSpecifierList;
            KtDelegationSpecifierList it = $receiver;
            return (KtDelegationSpecifier)EditCommaSeparatedListHelper.INSTANCE.addItem(it, this.getDelegationSpecifiers(), (KtElement)delegationSpecifier);
        }
        KtPsiFactory psiFactory = KtPsiFactoryKt.KtPsiFactory(this);
        PsiElement specifierListToAdd = psiFactory.createDelegatorToSuperCall("A()").replace(delegationSpecifier).getParent();
        PsiElement colon = this.addBefore(psiFactory.createColon(), this.getBody());
        PsiElement psiElement2 = this.addAfter(specifierListToAdd, colon);
        if (psiElement2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtDelegationSpecifierList");
        }
        KtDelegationSpecifier ktDelegationSpecifier = CollectionsKt.first(((KtDelegationSpecifierList)psiElement2).getDelegationSpecifiers());
        Intrinsics.checkExpressionValueIsNotNull(ktDelegationSpecifier, "(addAfter(specifierListT\u2026ationSpecifiers().first()");
        return ktDelegationSpecifier;
    }

    public final void removeDelegationSpecifier(@NotNull KtDelegationSpecifier delegationSpecifier) {
        Intrinsics.checkParameterIsNotNull(delegationSpecifier, "delegationSpecifier");
        KtDelegationSpecifierList ktDelegationSpecifierList = this.getDelegationSpecifierList();
        if (ktDelegationSpecifierList == null) {
            return;
        }
        KtDelegationSpecifierList specifierList = ktDelegationSpecifierList;
        PreconditionsKt.assert(delegationSpecifier.getParent() == specifierList);
        Collection $receiver = specifierList.getDelegationSpecifiers();
        if ($receiver.size() > 1) {
            EditCommaSeparatedListHelper.INSTANCE.removeItem((KtElement)delegationSpecifier);
        } else {
            Object object = this.findChildByType(KtTokens.COLON);
            if (object == null) {
                object = specifierList;
            }
            this.deleteChildRange((PsiElement)object, specifierList);
        }
    }

    @NotNull
    public final List<KtClassInitializer> getAnonymousInitializers() {
        KtClassBody ktClassBody = this.getBody();
        return CollectionsKt.orEmpty(ktClassBody != null ? ktClassBody.getAnonymousInitializers() : null);
    }

    @Nullable
    public final KtClassBody getBody() {
        return (KtClassBody)this.getStubOrPsiChild((IStubElementType)KtStubElementTypes.CLASS_BODY);
    }

    @NotNull
    public final KtClassBody getOrCreateBody() {
        KtClassBody ktClassBody = this.getBody();
        if (ktClassBody == null) {
            PsiElement psiElement2 = this.add(KtPsiFactoryKt.KtPsiFactory(this).createEmptyClassBody());
            if (psiElement2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtClassBody");
            }
            ktClassBody = (KtClassBody)psiElement2;
        }
        return ktClassBody;
    }

    @NotNull
    public final KtDeclaration addDeclaration(@NotNull KtDeclaration declaration) {
        Intrinsics.checkParameterIsNotNull(declaration, "declaration");
        KtClassBody body = this.getOrCreateBody();
        PsiElement psiElement2 = body.getRBrace();
        if (psiElement2 == null && (psiElement2 = body.getLastChild()) == null) {
            Intrinsics.throwNpe();
        }
        PsiElement anchor2 = PsiTreeUtil.skipSiblingsBackward(psiElement2, PsiWhiteSpace.class);
        PsiElement psiElement3 = body.addAfter(declaration, anchor2);
        if (psiElement3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtDeclaration");
        }
        return (KtDeclaration)psiElement3;
    }

    @NotNull
    public final KtDeclaration addDeclarationAfter(@NotNull KtDeclaration declaration, @Nullable PsiElement anchor2) {
        Intrinsics.checkParameterIsNotNull(declaration, "declaration");
        PsiElement psiElement2 = anchor2;
        if (psiElement2 == null) {
            psiElement2 = CollectionsKt.lastOrNull(this.getDeclarations());
        }
        if (psiElement2 == null) {
            return this.addDeclaration(declaration);
        }
        PsiElement anchorBefore = psiElement2;
        PsiElement psiElement3 = this.getOrCreateBody().addAfter(declaration, anchorBefore);
        if (psiElement3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtDeclaration");
        }
        return (KtDeclaration)psiElement3;
    }

    @NotNull
    public final KtDeclaration addDeclarationBefore(@NotNull KtDeclaration declaration, @Nullable PsiElement anchor2) {
        Intrinsics.checkParameterIsNotNull(declaration, "declaration");
        PsiElement psiElement2 = anchor2;
        if (psiElement2 == null) {
            psiElement2 = CollectionsKt.firstOrNull(this.getDeclarations());
        }
        if (psiElement2 == null) {
            return this.addDeclaration(declaration);
        }
        PsiElement anchorAfter = psiElement2;
        PsiElement psiElement3 = this.getOrCreateBody().addBefore(declaration, anchorAfter);
        if (psiElement3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtDeclaration");
        }
        return (KtDeclaration)psiElement3;
    }

    public final boolean isTopLevel() {
        KotlinClassOrObjectStub kotlinClassOrObjectStub = (KotlinClassOrObjectStub)this.getStub();
        return kotlinClassOrObjectStub != null ? kotlinClassOrObjectStub.isTopLevel() : this.getParent() instanceof KtFile;
    }

    public final boolean isLocal() {
        KotlinClassOrObjectStub kotlinClassOrObjectStub = (KotlinClassOrObjectStub)this.getStub();
        return kotlinClassOrObjectStub != null ? kotlinClassOrObjectStub.isLocal() : KtPsiUtil.isLocal(this);
    }

    @Override
    @NotNull
    public List<KtDeclaration> getDeclarations() {
        KtClassBody ktClassBody = this.getBody();
        return CollectionsKt.orEmpty(ktClassBody != null ? ktClassBody.getDeclarations() : null);
    }

    @Override
    @Nullable
    public ItemPresentation getPresentation() {
        return ItemPresentationProviders.getItemPresentation(this);
    }

    @Nullable
    public final KtPrimaryConstructor getPrimaryConstructor() {
        return (KtPrimaryConstructor)this.getStubOrPsiChild((IStubElementType)KtStubElementTypes.PRIMARY_CONSTRUCTOR);
    }

    @Nullable
    public final KtModifierList getPrimaryConstructorModifierList() {
        KtPrimaryConstructor ktPrimaryConstructor = this.getPrimaryConstructor();
        return ktPrimaryConstructor != null ? ktPrimaryConstructor.getModifierList() : null;
    }

    @Nullable
    public final KtParameterList getPrimaryConstructorParameterList() {
        KtPrimaryConstructor ktPrimaryConstructor = this.getPrimaryConstructor();
        return ktPrimaryConstructor != null ? ktPrimaryConstructor.getValueParameterList() : null;
    }

    @NotNull
    public final List<KtParameter> getPrimaryConstructorParameters() {
        KtParameterList ktParameterList = this.getPrimaryConstructorParameterList();
        return CollectionsKt.orEmpty(ktParameterList != null ? ktParameterList.getParameters() : null);
    }

    public final boolean hasExplicitPrimaryConstructor() {
        return this.getPrimaryConstructor() != null;
    }

    public final boolean hasPrimaryConstructor() {
        return this.hasExplicitPrimaryConstructor() || !this.hasSecondaryConstructors();
    }

    private final boolean hasSecondaryConstructors() {
        return !this.getSecondaryConstructors().isEmpty();
    }

    @NotNull
    public final List<KtSecondaryConstructor> getSecondaryConstructors() {
        KtClassBody ktClassBody = this.getBody();
        return CollectionsKt.orEmpty(ktClassBody != null ? ktClassBody.getSecondaryConstructors$kotlin_compiler() : null);
    }

    public final boolean isAnnotation() {
        return this.hasModifier(KtTokens.ANNOTATION_KEYWORD);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void delete() {
        CheckUtil.checkWritable(this);
        KtFile file = this.getContainingKtFile();
        if (this.isTopLevel()) {
            Collection $receiver = file.getDeclarations();
            if ($receiver.size() <= 1) {
                file.delete();
                return;
            }
        }
        CodeEditUtil.removeChild(this.getParent().getNode(), this.getNode());
    }

    public KtClassOrObject(@NotNull ASTNode node) {
        Intrinsics.checkParameterIsNotNull(node, "node");
        super(node);
    }

    public KtClassOrObject(@NotNull KotlinClassOrObjectStub<? extends KtClassOrObject> stub, @NotNull IStubElementType<?, ?> nodeType) {
        Intrinsics.checkParameterIsNotNull(stub, "stub");
        Intrinsics.checkParameterIsNotNull(nodeType, "nodeType");
        super((KotlinStubWithFqName)stub, nodeType);
    }
}

