/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.rmi.service;

import java.io.BufferedOutputStream;
import java.io.PrintStream;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Logger;
import kotlin.ArraysKt;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.MapsKt;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.PropertyMetadata;
import kotlin.StringsKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.config.Services;
import org.jetbrains.kotlin.load.kotlin.incremental.components.IncrementalCompilationComponents;
import org.jetbrains.kotlin.progress.CompilationCanceledStatus;
import org.jetbrains.kotlin.rmi.CompileService;
import org.jetbrains.kotlin.rmi.CompilerCallbackServicesFacade;
import org.jetbrains.kotlin.rmi.CompilerId;
import org.jetbrains.kotlin.rmi.DaemonOptions;
import org.jetbrains.kotlin.rmi.DaemonParamsKt;
import org.jetbrains.kotlin.rmi.DummyProfiler;
import org.jetbrains.kotlin.rmi.LoopbackNetworkInterface;
import org.jetbrains.kotlin.rmi.PerfCounters;
import org.jetbrains.kotlin.rmi.Profiler;
import org.jetbrains.kotlin.rmi.RemoteOperationsTracer;
import org.jetbrains.kotlin.rmi.RemoteOutputStream;
import org.jetbrains.kotlin.rmi.WallAndThreadAndMemoryTotalProfiler;
import org.jetbrains.kotlin.rmi.WallAndThreadTotalProfiler;
import org.jetbrains.kotlin.rmi.service.CompileServiceImpl;
import org.jetbrains.kotlin.rmi.service.CompileServiceImpl$WhenMappings;
import org.jetbrains.kotlin.rmi.service.CompileServiceImpl$log$1;
import org.jetbrains.kotlin.rmi.service.CompileServiceImplKt;
import org.jetbrains.kotlin.rmi.service.CompilerSelector;
import org.jetbrains.kotlin.rmi.service.LazyClasspathWatcher;
import org.jetbrains.kotlin.rmi.service.RemoteCompilationCanceledStatusClient;
import org.jetbrains.kotlin.rmi.service.RemoteIncrementalCompilationComponentsClient;
import org.jetbrains.kotlin.rmi.service.RemoteOutputStreamClient;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"'\u0004)\u0011\u0001D\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\t\u0001\u0002B\u0003\u0001\u000b\u0005a\u0011!B\u0001\t\u0003\u0015\tA!A\u0003\u0002\u0011\u0013)\u0001!B\u0001\t\f\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!A!B\u0001\r\u0003\u0015\tA!B\u0003\u0002\u0019\u0005)\u0011\u0001b\u0002\u0006\u0003!EQ!\u0001\u0005\b\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0002\t\u0007)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0002\t\u0005)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001\u0007\u0002\u000b\u0005a\u0011!B\u0001\r\u0003\u0015\tAqA\u0003\u0002\u0019\u0005)\u0011\u0001b\u0001\u0006\u00031\tQ!\u0001C\u0003\u0019\u0001I\u0012\u0001'\u0001\"<%\u0019\u0001\"A\u0007\u00021\u0007I1\u0001\u0003\u0002\u000e\u0003a\u0015\u0011b\u0001\u0005\u0004\u001b\u0005A:!C\u0002\t\t5\t\u0001\u0014B\u0005\u0004\u0011\u0015i\u0011\u0001g\u0003\n\r!1Q\u0002B\u0005\u0003\u0013\u0005Ar\u0001'\u0004R\u0007\u0005Ay!\n\u0005\u0005\u0017!1R\"\u0001M\n3\rAi#D\u0001\u0019\b\u0015~\u0002bF\u0007\u0002I_\t\"\u0001\u0002\u0001\t0e9\u0001\u0002G\u0007\u0006\u0013\r!\t!C\u0001\u00193aE\u0012d\u0001E\u001a\u001b\u0005A\"$G\u0002\t65\t\u0001dG\r\u0007\u0011oiA!\u0003\u0002\n\u0003\u0011>\u0002TB)\u0004\u0003!aR\u0005\u0004\u0003\u0002\u0011si\u0011\u0001G\u000f\u001a\u0007!mR\"\u0001\r\u001f3\rA)$D\u0001\u00197\u0015FC!\u0001E\u001f\u001b\u0005AZ!G\u0004\t15)\u0011b\u0001C\u0001\u0013\u0005A\u0012\u0004'\r\u001a\u0007!yR\"\u0001M 3\rA\u0001%D\u0001\u0019@e!\u0001\u0012I\u0007\u0003\u0019\u0003A\u0012%\u0007\u0007\t85Q\u0011BA\u0005\u00021iI!!C\u0001\u00197%\u0011\u0011\"\u0001\r#1\u0007\n6!\u0001E#K\u0011!1\u0002C\u0012\u000e\u0003aEQu\u0004E$\u001b\u0005!{#\u0005\u0002\u0005\u0001!=\u0012D\u0002E\u001c\u001b\u0011I!!C\u0001%0a5\u0011kA\u0001\tI\u0015~\u0001\u0012J\u0007\u0002I_\t\"\u0001\u0002\u0001\t0e1\u0001rG\u0007\u0005\u0013\tI\u0011\u0001j\f\u0019\u000eE\u001b\u0011\u0001\u0003\u0013&P\u0011Y\u0001\"J\u0007\u00021\u0017I2\u0001c\u0013\u000e\u0003a1\u0013d\u0002\u0005\u0019\u001b\u0015I1\u0001\"\u0001\n\u0003aI\u0002\u0014G\r\u0004\u0011\u001bj\u0011\u0001\u0007\u0010\u001a\u0007!9S\"\u0001M 3\rAy%D\u0001\u0019Qe\u0019\u0001\u0012K\u0007\u00021\u007fIB\u0001#\u0011\u000e\u00051\u0005\u0001$I)\u0004\u0003!ISu\n\u0003\f\u0011'j\u0011\u0001g\u0003\u001a\u0007!-S\"\u0001\r'3\u001dA\u0001$D\u0003\n\u0007\u0011\u0005\u0011\"\u0001\r\u001a1cI2\u0001#\u0014\u000e\u0003aq\u0012d\u0001\u0005(\u001b\u0005Az$G\u0002\tU5\t\u0001\u0004K\r\u0004\u0011#j\u0011\u0001g\u0010\u001a\t!\u0005SB\u0001G\u00011\u0005\n6!\u0001\u0005*K\u0011!1\u0002#\u0016\u000e\u0003a9\u0011&\u0003CB9!AQ\"\u0001M\t9\u0005\u0001\u0013!U\u0002\u0002\u000b\u0001Is\u0001B!\u001d\u0011%i\u0011\u0001g\u0005R\u0007\u0005)\u0001!K\u0004\u0005\u0003\"A!\"D\u0001\u0019\u0016E\u001b\u0011!\u0002\u0001*\u0015\u0011\u0019\u0005\u0002\u0003\u0002\u000e\u0003a\u0015\u0011k\u0001\u0003\u0006\u00015\u0011Aa\u0003E\fS)!1\t\u0003\u0005\u0005\u001b\u0005AJ!U\u0002\u0005\u000b\u0001i!\u0001\u0002\u0007\t\u001a%RAa\u0011\u0005\t\u001b5\t\u0001\u0014\u0003\u000f$#\u000e\u0019QB\u0001C\u000e\u00119I\u0013\u0003B\"\t\u0011;iQ\u0001e\b\u0016\u00051\u0005\u0001d\u0004\r\u00109\r\n6AB\u0003\u0003\tEA\u0019#\u0004\u0002\u0005!!\u0005\u0012&\u0004\u0003D\u0011!1Q\u0002B\u0005\u0003\u0013\u0005Ar\u0001'\u0004R\u0007\u0011)\u0001!\u0004\u0002\u0005%!\u0015\u0012F\u0003\u0003D\u0011!\tQ\"\u0001M\u0002#\u000e!Q\u0001A\u0007\u0003\tMA9#K\u0004\u0005\u0003\"AA#D\u0001\u0019*E\u001b\u0011!\u0002\u0001*\u0015\u0011\u0019\u0005\u0002C\u0002\u000e\u0003a\u001d\u0011k\u0001\u0003\u0006\u00015\u0011A!\u0006E\u0016"}, strings={"Lorg/jetbrains/kotlin/rmi/service/CompileServiceImpl;", "Lorg/jetbrains/kotlin/rmi/CompileService;", "registry", "Ljava/rmi/registry/Registry;", "compiler", "Lorg/jetbrains/kotlin/rmi/service/CompilerSelector;", "selfCompilerId", "Lorg/jetbrains/kotlin/rmi/CompilerId;", "daemonOptions", "Lorg/jetbrains/kotlin/rmi/DaemonOptions;", "port", "", "onShutdown", "Lkotlin/Function0;", "", "(Ljava/rmi/registry/Registry;Lorg/jetbrains/kotlin/rmi/service/CompilerSelector;Lorg/jetbrains/kotlin/rmi/CompilerId;Lorg/jetbrains/kotlin/rmi/DaemonOptions;ILkotlin/jvm/functions/Function0;)V", "_lastUsedSeconds", "", "alive", "", "classpathWatcher", "Lorg/jetbrains/kotlin/rmi/service/LazyClasspathWatcher;", "getCompiler", "()Lorg/jetbrains/kotlin/rmi/service/CompilerSelector;", "getDaemonOptions", "()Lorg/jetbrains/kotlin/rmi/DaemonOptions;", "lastUsedSeconds", "getLastUsedSeconds", "()J", "log", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "getLog", "()Ljava/util/logging/Logger;", "log$delegate", "Lkotlin/Lazy;", "getOnShutdown", "()Lkotlin/jvm/functions/Function0;", "getRegistry", "()Ljava/rmi/registry/Registry;", "rwlock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "getSelfCompilerId", "()Lorg/jetbrains/kotlin/rmi/CompilerId;", "checkCompilerId", "compilerId", "checkedCompile", "R", "args", "", "", "serviceOut", "Ljava/io/PrintStream;", "rpcProfiler", "Lorg/jetbrains/kotlin/rmi/Profiler;", "body", "([Ljava/lang/String;Ljava/io/PrintStream;Lorg/jetbrains/kotlin/rmi/Profiler;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "createCompileServices", "Lorg/jetbrains/kotlin/config/Services;", "facade", "Lorg/jetbrains/kotlin/rmi/CompilerCallbackServicesFacade;", "doCompile", "compilerMessagesStreamProxy", "Lorg/jetbrains/kotlin/rmi/RemoteOutputStream;", "serviceOutputStreamProxy", "operationsTracer", "Lorg/jetbrains/kotlin/rmi/RemoteOperationsTracer;", "Lkotlin/Function2;", "Lorg/jetbrains/kotlin/cli/common/ExitCode;", "([Ljava/lang/String;Lorg/jetbrains/kotlin/rmi/RemoteOutputStream;Lorg/jetbrains/kotlin/rmi/RemoteOutputStream;Lorg/jetbrains/kotlin/rmi/RemoteOperationsTracer;Lkotlin/jvm/functions/Function2;)I", "getUsedMemory", "ifAlive", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "ifAliveExclusive", "remoteCompile", "targetPlatform", "Lorg/jetbrains/kotlin/rmi/CompileService$TargetPlatform;", "servicesFacade", "compilerOutputStream", "outputFormat", "Lorg/jetbrains/kotlin/rmi/CompileService$OutputFormat;", "serviceOutputStream", "(Lorg/jetbrains/kotlin/rmi/CompileService$TargetPlatform;[Ljava/lang/String;Lorg/jetbrains/kotlin/rmi/CompilerCallbackServicesFacade;Lorg/jetbrains/kotlin/rmi/RemoteOutputStream;Lorg/jetbrains/kotlin/rmi/CompileService$OutputFormat;Lorg/jetbrains/kotlin/rmi/RemoteOutputStream;Lorg/jetbrains/kotlin/rmi/RemoteOperationsTracer;)I", "remoteIncrementalCompile", "compilerOutputFormat", "shutdown"}, moduleName="kotlin-compiler")
public final class CompileServiceImpl
implements CompileService {
    private final LazyClasspathWatcher classpathWatcher;
    private volatile long _lastUsedSeconds;
    private final Lazy<? extends Logger> log$delegate;
    private final ReentrantReadWriteLock rwlock;
    private boolean alive;
    @NotNull
    private final Registry registry;
    @NotNull
    private final CompilerSelector compiler;
    @NotNull
    private final CompilerId selfCompilerId;
    @NotNull
    private final DaemonOptions daemonOptions;
    @NotNull
    private final Function0<? extends Unit> onShutdown;
    private static final /* synthetic */ PropertyMetadata[] $$delegatedProperties;

    @Override
    public boolean checkCompilerId(@NotNull CompilerId compilerId) {
        Intrinsics.checkParameterIsNotNull(compilerId, "compilerId");
        return (Boolean)this.ifAlive((Function0)new Function0<Boolean>(this, compilerId){
            final /* synthetic */ CompileServiceImpl this$0;
            final /* synthetic */ CompilerId $compilerId;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean invoke() {
                if (!StringsKt.isEmpty((CharSequence)this.this$0.getSelfCompilerId().getCompilerVersion())) {
                    if (!Intrinsics.areEqual(this.this$0.getSelfCompilerId().getCompilerVersion(), this.$compilerId.getCompilerVersion())) return false;
                }
                Iterable $receiver = this.this$0.getSelfCompilerId().getCompilerClasspath();
                for (T element : $receiver) {
                    String it = (String)element;
                    if (this.$compilerId.getCompilerClasspath().contains(it)) continue;
                    return false;
                }
                boolean bl = true;
                if (!bl) return false;
                if (CompileServiceImpl.access$getClasspathWatcher$p(this.this$0).isChanged()) return false;
                return true;
            }
            {
                this.this$0 = compileServiceImpl;
                this.$compilerId = compilerId;
                super(0);
            }
        });
    }

    @Override
    public long getUsedMemory() {
        return ((Number)this.ifAlive(getUsedMemory.1.INSTANCE)).longValue();
    }

    @Override
    public void shutdown() {
        this.ifAliveExclusive((Function0)new Function0<Unit>(this){
            final /* synthetic */ CompileServiceImpl this$0;

            public final void invoke() {
                this.this$0.getLog().info("Shutdown started");
                CompileServiceImpl.access$setAlive$p(this.this$0, false);
                UnicastRemoteObject.unexportObject(this.this$0, true);
                this.this$0.getLog().info("Shutdown complete");
                this.this$0.getOnShutdown().invoke();
            }
            {
                this.this$0 = compileServiceImpl;
                super(0);
            }
        });
    }

    @Override
    public int remoteCompile(@NotNull CompileService.TargetPlatform targetPlatform, @NotNull String[] args, @NotNull CompilerCallbackServicesFacade servicesFacade, @NotNull RemoteOutputStream compilerOutputStream, @NotNull CompileService.OutputFormat outputFormat, @NotNull RemoteOutputStream serviceOutputStream, @Nullable RemoteOperationsTracer operationsTracer) {
        Intrinsics.checkParameterIsNotNull(targetPlatform, "targetPlatform");
        Intrinsics.checkParameterIsNotNull(args, "args");
        Intrinsics.checkParameterIsNotNull(servicesFacade, "servicesFacade");
        Intrinsics.checkParameterIsNotNull(compilerOutputStream, "compilerOutputStream");
        Intrinsics.checkParameterIsNotNull(outputFormat, "outputFormat");
        Intrinsics.checkParameterIsNotNull(serviceOutputStream, "serviceOutputStream");
        return this.doCompile(args, compilerOutputStream, serviceOutputStream, operationsTracer, (Function2<? super PrintStream, ? super Profiler, ? extends ExitCode>)new Function2<PrintStream, Profiler, ExitCode>(this, outputFormat, targetPlatform, args, servicesFacade){
            final /* synthetic */ CompileServiceImpl this$0;
            final /* synthetic */ CompileService.OutputFormat $outputFormat;
            final /* synthetic */ CompileService.TargetPlatform $targetPlatform;
            final /* synthetic */ String[] $args;
            final /* synthetic */ CompilerCallbackServicesFacade $servicesFacade;

            @NotNull
            public final ExitCode invoke(@NotNull PrintStream printStream, @NotNull Profiler profiler) {
                ExitCode exitCode;
                Intrinsics.checkParameterIsNotNull(printStream, "printStream");
                Intrinsics.checkParameterIsNotNull(profiler, "profiler");
                switch (CompileServiceImpl$WhenMappings.$EnumSwitchMapping$0[this.$outputFormat.ordinal()]) {
                    case 1: {
                        ExitCode exitCode2 = this.this$0.getCompiler().get(this.$targetPlatform).exec(printStream, Arrays.copyOf(this.$args, this.$args.length));
                        exitCode = exitCode2;
                        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)exitCode2), "compiler[targetPlatform].exec(printStream, *args)");
                        break;
                    }
                    case 2: {
                        ExitCode exitCode3 = this.this$0.getCompiler().get(this.$targetPlatform).execAndOutputXml(printStream, CompileServiceImpl.access$createCompileServices(this.this$0, this.$servicesFacade, profiler), Arrays.copyOf(this.$args, this.$args.length));
                        exitCode = exitCode3;
                        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)exitCode3), "compiler[targetPlatform]\u2026Facade, profiler), *args)");
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)((Object)exitCode), "when (outputFormat) {\n  \u2026 *args)\n                }");
                return exitCode;
            }
            {
                this.this$0 = compileServiceImpl;
                this.$outputFormat = outputFormat;
                this.$targetPlatform = targetPlatform;
                this.$args = stringArray;
                this.$servicesFacade = compilerCallbackServicesFacade;
                super(2);
            }
        });
    }

    @Override
    public int remoteIncrementalCompile(@NotNull CompileService.TargetPlatform targetPlatform, @NotNull String[] args, @NotNull CompilerCallbackServicesFacade servicesFacade, @NotNull RemoteOutputStream compilerOutputStream, @NotNull CompileService.OutputFormat compilerOutputFormat, @NotNull RemoteOutputStream serviceOutputStream, @Nullable RemoteOperationsTracer operationsTracer) {
        Intrinsics.checkParameterIsNotNull(targetPlatform, "targetPlatform");
        Intrinsics.checkParameterIsNotNull(args, "args");
        Intrinsics.checkParameterIsNotNull(servicesFacade, "servicesFacade");
        Intrinsics.checkParameterIsNotNull(compilerOutputStream, "compilerOutputStream");
        Intrinsics.checkParameterIsNotNull(compilerOutputFormat, "compilerOutputFormat");
        Intrinsics.checkParameterIsNotNull(serviceOutputStream, "serviceOutputStream");
        return this.doCompile(args, compilerOutputStream, serviceOutputStream, operationsTracer, (Function2<? super PrintStream, ? super Profiler, ? extends ExitCode>)new Function2<PrintStream, Profiler, ExitCode>(this, compilerOutputFormat, targetPlatform, servicesFacade, args){
            final /* synthetic */ CompileServiceImpl this$0;
            final /* synthetic */ CompileService.OutputFormat $compilerOutputFormat;
            final /* synthetic */ CompileService.TargetPlatform $targetPlatform;
            final /* synthetic */ CompilerCallbackServicesFacade $servicesFacade;
            final /* synthetic */ String[] $args;

            @NotNull
            public final ExitCode invoke(@NotNull PrintStream printStream, @NotNull Profiler profiler) {
                ExitCode exitCode;
                Intrinsics.checkParameterIsNotNull(printStream, "printStream");
                Intrinsics.checkParameterIsNotNull(profiler, "profiler");
                switch (CompileServiceImpl$WhenMappings.$EnumSwitchMapping$1[this.$compilerOutputFormat.ordinal()]) {
                    case 1: {
                        throw (Throwable)new NotImplementedError("Only XML output is supported in remote incremental compilation");
                    }
                    case 2: {
                        exitCode = this.this$0.getCompiler().get(this.$targetPlatform).execAndOutputXml(printStream, CompileServiceImpl.access$createCompileServices(this.this$0, this.$servicesFacade, profiler), Arrays.copyOf(this.$args, this.$args.length));
                        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)exitCode), "compiler[targetPlatform]\u2026Facade, profiler), *args)");
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)((Object)exitCode), "when (compilerOutputForm\u2026 *args)\n                }");
                return exitCode;
            }
            {
                this.this$0 = compileServiceImpl;
                this.$compilerOutputFormat = outputFormat;
                this.$targetPlatform = targetPlatform;
                this.$servicesFacade = compilerCallbackServicesFacade;
                this.$args = stringArray;
                super(2);
            }
        });
    }

    public final long getLastUsedSeconds() {
        return this.rwlock.isWriteLocked() || this.rwlock.getReadLockCount() - this.rwlock.getReadHoldCount() > 0 ? CompileServiceImplKt.nowSeconds() : this._lastUsedSeconds;
    }

    public final Logger getLog() {
        return LazyKt.getValue(this.log$delegate, this, (KProperty)$$delegatedProperties[0]);
    }

    private final int doCompile(String[] args, RemoteOutputStream compilerMessagesStreamProxy, RemoteOutputStream serviceOutputStreamProxy, RemoteOperationsTracer operationsTracer, Function2<? super PrintStream, ? super Profiler, ? extends ExitCode> body) {
        return ((Number)this.ifAlive((Function0)new Function0<Integer>(this, operationsTracer, compilerMessagesStreamProxy, serviceOutputStreamProxy, args, body){
            final /* synthetic */ CompileServiceImpl this$0;
            final /* synthetic */ RemoteOperationsTracer $operationsTracer;
            final /* synthetic */ RemoteOutputStream $compilerMessagesStreamProxy;
            final /* synthetic */ RemoteOutputStream $serviceOutputStreamProxy;
            final /* synthetic */ String[] $args;
            final /* synthetic */ Function2 $body;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final int invoke() {
                Unit unit;
                RemoteOperationsTracer remoteOperationsTracer;
                int n;
                Unit unit2;
                RemoteOperationsTracer remoteOperationsTracer2 = this.$operationsTracer;
                if (remoteOperationsTracer2 != null) {
                    remoteOperationsTracer2.before("compile");
                    unit2 = Unit.INSTANCE;
                } else {
                    unit2 = null;
                }
                Profiler rpcProfiler = this.this$0.getDaemonOptions().getReportPerf() ? (Profiler)new WallAndThreadTotalProfiler() : (Profiler)new DummyProfiler();
                PrintStream compilerMessagesStream = new PrintStream(new BufferedOutputStream(new RemoteOutputStreamClient(this.$compilerMessagesStreamProxy, rpcProfiler), 4096));
                PrintStream serviceOutputStream = new PrintStream(new BufferedOutputStream(new RemoteOutputStreamClient(this.$serviceOutputStreamProxy, rpcProfiler), 4096));
                try {
                    n = ((Number)this.this$0.checkedCompile(this.$args, serviceOutputStream, rpcProfiler, (Function0)new Function0<Integer>(this, compilerMessagesStream, rpcProfiler){
                        final /* synthetic */ doCompile.1 this$0;
                        final /* synthetic */ PrintStream $compilerMessagesStream;
                        final /* synthetic */ Profiler $rpcProfiler;

                        /*
                         * WARNING - void declaration
                         */
                        public final int invoke() {
                            void var1_1;
                            int res = ((ExitCode)((Object)this.this$0.$body.invoke(this.$compilerMessagesStream, this.$rpcProfiler))).getCode();
                            CompileServiceImpl.access$set_lastUsedSeconds$p(this.this$0.this$0, CompileServiceImplKt.nowSeconds());
                            return (int)var1_1;
                        }
                        {
                            this.this$0 = var1_1;
                            this.$compilerMessagesStream = printStream;
                            this.$rpcProfiler = profiler;
                            super(0);
                        }
                    })).intValue();
                    serviceOutputStream.flush();
                    compilerMessagesStream.flush();
                    remoteOperationsTracer = this.$operationsTracer;
                }
                catch (Throwable throwable) {
                    Unit unit3;
                    serviceOutputStream.flush();
                    compilerMessagesStream.flush();
                    RemoteOperationsTracer remoteOperationsTracer3 = this.$operationsTracer;
                    if (remoteOperationsTracer3 != null) {
                        remoteOperationsTracer3.after("compile");
                        unit3 = Unit.INSTANCE;
                    } else {
                        unit3 = null;
                    }
                    throw throwable;
                }
                if (remoteOperationsTracer != null) {
                    remoteOperationsTracer.after("compile");
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                return n;
            }
            {
                this.this$0 = compileServiceImpl;
                this.$operationsTracer = remoteOperationsTracer;
                this.$compilerMessagesStreamProxy = remoteOutputStream;
                this.$serviceOutputStreamProxy = remoteOutputStream2;
                this.$args = stringArray;
                this.$body = function2;
                super(0);
            }
        })).intValue();
    }

    private final Services createCompileServices(CompilerCallbackServicesFacade facade, Profiler rpcProfiler) {
        Services.Builder builder = new Services.Builder();
        if (facade.hasIncrementalCaches() || facade.hasLookupTracker()) {
            builder.register(IncrementalCompilationComponents.class, new RemoteIncrementalCompilationComponentsClient(facade, rpcProfiler));
        }
        if (facade.hasCompilationCanceledStatus()) {
            builder.register(CompilationCanceledStatus.class, new RemoteCompilationCanceledStatusClient(facade, rpcProfiler));
        }
        return builder.build();
    }

    /*
     * WARNING - void declaration
     */
    public final <R> R checkedCompile(@NotNull String[] args, @NotNull PrintStream serviceOut, @NotNull Profiler rpcProfiler, @NotNull Function0<? extends R> body) {
        Intrinsics.checkParameterIsNotNull(args, "args");
        Intrinsics.checkParameterIsNotNull(serviceOut, "serviceOut");
        Intrinsics.checkParameterIsNotNull(rpcProfiler, "rpcProfiler");
        Intrinsics.checkParameterIsNotNull(body, "body");
        try {
            long l;
            if (ArraysKt.none((Object[])args)) {
                throw (Throwable)new IllegalArgumentException("Error: empty arguments list.");
            }
            this.getLog().info("Starting compilation with args: " + ArraysKt.joinToString$default((Object[])args, (CharSequence)" ", null, null, 0, null, null, 62));
            Profiler profiler = this.daemonOptions.getReportPerf() ? (Profiler)new WallAndThreadAndMemoryTotalProfiler(false) : (Profiler)new DummyProfiler();
            R res = profiler.withMeasure(null, body);
            if (this.daemonOptions.getReportPerf()) {
                void withGC;
                boolean bl = false;
                if (withGC != false) {
                    System.gc();
                }
                Runtime rt = Runtime.getRuntime();
                l = rt.totalMemory() - rt.freeMemory();
            } else {
                l = 0L;
            }
            long endMem = l;
            this.getLog().info("Done with result " + String.valueOf(res));
            if (this.daemonOptions.getReportPerf()) {
                void $receiver;
                checkedCompile.1 ms$ = checkedCompile.1.INSTANCE;
                checkedCompile.2 kb$ = checkedCompile.2.INSTANCE;
                PerfCounters pc = profiler.getTotalCounters();
                PerfCounters rpc = rpcProfiler.getTotalCounters();
                Object object = "PERF: Compile on daemon: " + ms$.invoke(pc.getTime()) + " ms; thread: user " + ms$.invoke(pc.getThreadUserTime()) + " ms, sys " + ms$.invoke(pc.getThreadTime() - pc.getThreadUserTime()) + " ms; rpc: " + rpc.getCount() + " calls, " + ms$.invoke(rpc.getTime()) + " ms, thread " + ms$.invoke(rpc.getThreadTime()) + " ms; memory: " + kb$.invoke(endMem) + " kb (" + StringsKt.format("%+d", kb$.invoke(pc.getMemory())) + " kb)";
                String it = (String)$receiver;
                serviceOut.println(it);
                this.getLog().info(it);
                Iterator<Map.Entry<Object, PerfCounters>> iterator2 = MapsKt.iterator(rpcProfiler.getCounters());
                while (iterator2.hasNext()) {
                    String $receiver2;
                    void $receiver3;
                    Object $i$f$let = object = iterator2.next();
                    Object obj = $receiver3.getKey();
                    Object $i$f$component1 = object;
                    PerfCounters counters = (PerfCounters)$receiver2.getValue();
                    $receiver2 = "PERF: rpc by " + obj + ": " + counters.getCount() + " calls, " + ms$.invoke(counters.getTime()) + " ms, thread " + ms$.invoke(counters.getThreadTime()) + " ms";
                    String it2 = $receiver2;
                    serviceOut.println(it2);
                    this.getLog().info(it2);
                }
            }
            return res;
        }
        catch (Exception e) {
            this.getLog().info("Error: " + e);
            throw (Throwable)e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <R> R ifAlive(@NotNull Function0<? extends R> body) {
        R r;
        Intrinsics.checkParameterIsNotNull(body, "body");
        ReentrantReadWriteLock $receiver = this.rwlock;
        ReentrantReadWriteLock.ReadLock rl = $receiver.readLock();
        rl.lock();
        try {
            if (!this.alive) {
                throw (Throwable)new IllegalStateException("Kotlin Compiler Service is not in alive state");
            }
            r = body.invoke();
        }
        finally {
            rl.unlock();
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final <R> R ifAliveExclusive(@NotNull Function0<? extends R> body) {
        int index2;
        R r;
        int it;
        Intrinsics.checkParameterIsNotNull(body, "body");
        ReentrantReadWriteLock $receiver = this.rwlock;
        ReentrantReadWriteLock.ReadLock rl = $receiver.readLock();
        int readCount = $receiver.getWriteHoldCount() == 0 ? $receiver.getReadHoldCount() : 0;
        int n = 0;
        int n2 = readCount - 1;
        if (n <= n2) {
            void index3;
            do {
                it = ++index3;
                rl.unlock();
            } while (index3 != n2);
        }
        ReentrantReadWriteLock.WriteLock wl = $receiver.writeLock();
        wl.lock();
        try {
            if (!this.alive) {
                throw (Throwable)new IllegalStateException("Kotlin Compiler Service is not in alive state");
            }
            r = body.invoke();
        }
        catch (Throwable throwable) {
            index2 = 0;
            int n3 = readCount - 1;
            if (index2 <= n3) {
                do {
                    int it2 = ++index2;
                    rl.lock();
                } while (index2 != n3);
            }
            wl.unlock();
            throw throwable;
        }
        it = 0;
        int n4 = readCount - 1;
        if (it <= n4) {
            do {
                int it3 = ++index2;
                rl.lock();
            } while (index2 != n4);
        }
        wl.unlock();
        return r;
    }

    @NotNull
    public final Registry getRegistry() {
        return this.registry;
    }

    @NotNull
    public final CompilerSelector getCompiler() {
        return this.compiler;
    }

    @NotNull
    public final CompilerId getSelfCompilerId() {
        return this.selfCompilerId;
    }

    @NotNull
    public final DaemonOptions getDaemonOptions() {
        return this.daemonOptions;
    }

    @NotNull
    public final Function0<Unit> getOnShutdown() {
        return this.onShutdown;
    }

    static {
        $$delegatedProperties = new PropertyMetadata[]{CompileServiceImpl$log$1.INSTANCE};
    }

    public CompileServiceImpl(@NotNull Registry registry, @NotNull CompilerSelector compiler, @NotNull CompilerId selfCompilerId, @NotNull DaemonOptions daemonOptions, int port, @NotNull Function0<? extends Unit> onShutdown) {
        Intrinsics.checkParameterIsNotNull(registry, "registry");
        Intrinsics.checkParameterIsNotNull(compiler, "compiler");
        Intrinsics.checkParameterIsNotNull(selfCompilerId, "selfCompilerId");
        Intrinsics.checkParameterIsNotNull(daemonOptions, "daemonOptions");
        Intrinsics.checkParameterIsNotNull(onShutdown, "onShutdown");
        this.registry = registry;
        this.compiler = compiler;
        this.selfCompilerId = selfCompilerId;
        this.daemonOptions = daemonOptions;
        this.onShutdown = onShutdown;
        this.classpathWatcher = new LazyClasspathWatcher(this.selfCompilerId.getCompilerClasspath(), 0L, 0L, 6, null);
        this._lastUsedSeconds = CompileServiceImplKt.nowSeconds();
        this.log$delegate = LazyKt.lazy(log.2.INSTANCE);
        this.rwlock = new ReentrantReadWriteLock();
        try {
            UnicastRemoteObject.unexportObject(this, false);
        }
        catch (NoSuchObjectException e) {
            // empty catch block
        }
        Remote remote = UnicastRemoteObject.exportObject(this, port, LoopbackNetworkInterface.INSTANCE.getClientLoopbackSocketFactory(), LoopbackNetworkInterface.INSTANCE.getServerLoopbackSocketFactory());
        if (remote == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.rmi.CompileService");
        }
        CompileService stub = (CompileService)remote;
        this.registry.rebind(DaemonParamsKt.getCOMPILER_SERVICE_RMI_NAME(), stub);
        this.alive = true;
    }

    @NotNull
    public static final /* synthetic */ LazyClasspathWatcher access$getClasspathWatcher$p(CompileServiceImpl $this) {
        return $this.classpathWatcher;
    }

    public static final /* synthetic */ void access$setAlive$p(CompileServiceImpl $this, boolean bl) {
        $this.alive = bl;
    }

    @NotNull
    public static final /* synthetic */ Services access$createCompileServices(CompileServiceImpl $this, @NotNull CompilerCallbackServicesFacade facade, @NotNull Profiler rpcProfiler) {
        return $this.createCompileServices(facade, rpcProfiler);
    }

    public static final /* synthetic */ long access$get_lastUsedSeconds$p(CompileServiceImpl $this) {
        return $this._lastUsedSeconds;
    }

    public static final /* synthetic */ void access$set_lastUsedSeconds$p(CompileServiceImpl $this, long l) {
        $this._lastUsedSeconds = l;
    }
}

