/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateFromUsageBaseFix;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.impl.TextExpression;
import com.intellij.icons.AllIcons;
import com.intellij.lang.StdLanguages;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DelegateWithDefaultParamValueIntentionAction
extends PsiElementBaseIntentionAction
implements Iconable,
LowPriorityAction {
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/DelegateWithDefaultParamValueIntentionAction", "isAvailable"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/impl/quickfix/DelegateWithDefaultParamValueIntentionAction", "isAvailable"));
        }
        PsiParameter parameter = (PsiParameter)PsiTreeUtil.getParentOfType((PsiElement)element, PsiParameter.class);
        if (parameter != null) {
            PsiMethod method;
            PsiClass containingClass;
            if (!parameter.getLanguage().isKindOf(StdLanguages.JAVA)) {
                return false;
            }
            PsiElement declarationScope = parameter.getDeclarationScope();
            if (declarationScope instanceof PsiMethod && (containingClass = (method = (PsiMethod)declarationScope).getContainingClass()) != null && (!containingClass.isInterface() || PsiUtil.isLanguageLevel8OrHigher((PsiElement)method))) {
                if (containingClass.findMethodBySignature(DelegateWithDefaultParamValueIntentionAction.generateMethodPrototype(method, parameter), false) != null) {
                    return false;
                }
                this.setText("Generate overloaded " + (method.isConstructor() ? "constructor" : "method") + " with default parameter value");
                return true;
            }
        }
        return false;
    }

    public Icon getIcon(int flags) {
        return AllIcons.Actions.RefactoringBulb;
    }

    private static PsiMethod generateMethodPrototype(PsiMethod method, PsiParameter ... params) {
        PsiMethod prototype = (PsiMethod)method.copy();
        PsiCodeBlock body = prototype.getBody();
        PsiCodeBlock emptyBody = JavaPsiFacade.getElementFactory((Project)method.getProject()).createMethodFromText("void foo(){}", (PsiElement)prototype).getBody();
        assert (emptyBody != null);
        if (body != null) {
            body.replace((PsiElement)emptyBody);
        } else {
            prototype.getModifierList().setModifierProperty("abstract", false);
            prototype.addBefore((PsiElement)emptyBody, null);
        }
        PsiClass aClass = method.getContainingClass();
        if (aClass != null && aClass.isInterface()) {
            prototype.getModifierList().setModifierProperty("default", true);
        }
        final PsiParameterList parameterList = method.getParameterList();
        Arrays.sort(params, new Comparator<PsiParameter>(){

            @Override
            public int compare(PsiParameter p1, PsiParameter p2) {
                int parameterIndex2;
                int parameterIndex1 = parameterList.getParameterIndex(p1);
                return parameterIndex1 > (parameterIndex2 = parameterList.getParameterIndex(p2)) ? -1 : 1;
            }
        });
        for (PsiParameter param : params) {
            int parameterIndex = parameterList.getParameterIndex(param);
            prototype.getParameterList().getParameters()[parameterIndex].delete();
        }
        return prototype;
    }

    public void invoke(final @NotNull Project project, final Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/DelegateWithDefaultParamValueIntentionAction", "invoke"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/impl/quickfix/DelegateWithDefaultParamValueIntentionAction", "invoke"));
        }
        final PsiParameter[] parameters = this.getParams(element);
        if (parameters == null || parameters.length == 0) {
            return;
        }
        final PsiMethod method = (PsiMethod)parameters[0].getDeclarationScope();
        final PsiMethod methodPrototype = DelegateWithDefaultParamValueIntentionAction.generateMethodPrototype(method, parameters);
        PsiMethod existingMethod = method.getContainingClass().findMethodBySignature(methodPrototype, false);
        if (existingMethod != null) {
            editor.getCaretModel().moveToOffset(existingMethod.getTextOffset());
            HintManager.getInstance().showErrorHint(editor, (existingMethod.isConstructor() ? "Constructor" : "Method") + " with the chosen signature already exists");
            return;
        }
        if (!FileModificationService.getInstance().preparePsiElementForWrite(element)) {
            return;
        }
        Runnable runnable2 = new Runnable(){

            @Override
            public void run() {
                PsiMethod prototype = (PsiMethod)method.getContainingClass().addBefore((PsiElement)methodPrototype, (PsiElement)method);
                RefactoringUtil.fixJavadocsForParams(prototype, new HashSet<PsiParameter>(Arrays.asList(prototype.getParameterList().getParameters())));
                TemplateBuilderImpl builder = new TemplateBuilderImpl((PsiElement)prototype);
                PsiCodeBlock body = prototype.getBody();
                String callArgs = "(" + StringUtil.join((Object[])method.getParameterList().getParameters(), (Function)new Function<PsiParameter, String>(){

                    public String fun(PsiParameter psiParameter) {
                        if (ArrayUtil.find((Object[])parameters, (Object)psiParameter) > -1) {
                            return "IntelliJIDEARulezzz";
                        }
                        return psiParameter.getName();
                    }
                }, (String)",") + ");";
                String methodCall = method.getReturnType() == null ? "this" : (!PsiType.VOID.equals((Object)method.getReturnType()) ? "return " + method.getName() : method.getName());
                body.add((PsiElement)JavaPsiFacade.getElementFactory((Project)project).createStatementFromText(methodCall + callArgs, (PsiElement)method));
                body = (PsiCodeBlock)CodeStyleManager.getInstance((Project)project).reformat((PsiElement)body);
                PsiStatement stmt = body.getStatements()[0];
                PsiExpression expr = null;
                if (stmt instanceof PsiReturnStatement) {
                    expr = ((PsiReturnStatement)stmt).getReturnValue();
                } else if (stmt instanceof PsiExpressionStatement) {
                    expr = ((PsiExpressionStatement)stmt).getExpression();
                }
                if (expr instanceof PsiMethodCallExpression) {
                    PsiMethodCallExpression methodCallExp = (PsiMethodCallExpression)expr;
                    RangeMarker rangeMarker = editor.getDocument().createRangeMarker(prototype.getTextRange());
                    for (PsiParameter parameter : parameters) {
                        PsiExpression exprToBeDefault = methodCallExp.getArgumentList().getExpressions()[method.getParameterList().getParameterIndex(parameter)];
                        builder.replaceElement((PsiElement)exprToBeDefault, (Expression)new TextExpression(""));
                    }
                    Template template = builder.buildTemplate();
                    editor.getCaretModel().moveToOffset(rangeMarker.getStartOffset());
                    PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(editor.getDocument());
                    editor.getDocument().deleteString(rangeMarker.getStartOffset(), rangeMarker.getEndOffset());
                    rangeMarker.dispose();
                    CreateFromUsageBaseFix.startTemplate(editor, template, project);
                }
            }
        };
        if (this.startInWriteAction()) {
            runnable2.run();
        } else {
            ApplicationManager.getApplication().runWriteAction(runnable2);
        }
    }

    @Nullable
    protected PsiParameter[] getParams(PsiElement element) {
        return new PsiParameter[]{(PsiParameter)PsiTreeUtil.getParentOfType((PsiElement)element, PsiParameter.class)};
    }

    @NotNull
    public String getFamilyName() {
        if ("Generate overloaded method with default parameter value" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/DelegateWithDefaultParamValueIntentionAction", "getFamilyName"));
        }
        return "Generate overloaded method with default parameter value";
    }
}

