/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.smartEnter;

import com.intellij.codeInsight.editorActions.smartEnter.Fixer;
import com.intellij.codeInsight.editorActions.smartEnter.JavaSmartEnterProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;

public class MissingForeachBodyFixer
implements Fixer {
    @Override
    public void apply(Editor editor, JavaSmartEnterProcessor processor2, PsiElement psiElement) throws IncorrectOperationException {
        PsiForeachStatement forStatement = MissingForeachBodyFixer.getForeachStatementParent(psiElement);
        if (forStatement == null) {
            return;
        }
        Document doc = editor.getDocument();
        PsiStatement body = forStatement.getBody();
        if (body instanceof PsiBlockStatement) {
            return;
        }
        if (body != null && MissingForeachBodyFixer.startLine(doc, (PsiElement)body) == MissingForeachBodyFixer.startLine(doc, (PsiElement)forStatement)) {
            return;
        }
        PsiJavaToken eltToInsertAfter = forStatement.getRParenth();
        String text = "{}";
        if (eltToInsertAfter == null) {
            eltToInsertAfter = forStatement;
            text = "){}";
        }
        doc.insertString(eltToInsertAfter.getTextRange().getEndOffset(), (CharSequence)text);
    }

    private static PsiForeachStatement getForeachStatementParent(PsiElement psiElement) {
        PsiForeachStatement statement = (PsiForeachStatement)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiForeachStatement.class);
        if (statement == null) {
            return null;
        }
        PsiExpression iterated = statement.getIteratedValue();
        PsiParameter parameter = statement.getIterationParameter();
        return PsiTreeUtil.isAncestor((PsiElement)iterated, (PsiElement)psiElement, (boolean)false) || PsiTreeUtil.isAncestor((PsiElement)parameter, (PsiElement)psiElement, (boolean)false) ? statement : null;
    }

    private static int startLine(Document doc, PsiElement psiElement) {
        return doc.getLineNumber(psiElement.getTextRange().getStartOffset());
    }
}

