/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.contents;

import com.intellij.diff.contents.BinaryFileContent;
import com.intellij.diff.contents.FileContent;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileContentImpl
implements FileContent,
BinaryFileContent {
    @NotNull
    private final VirtualFile myFile;
    @Nullable
    private final Project myProject;
    @NotNull
    private final FileType myType;

    public FileContentImpl(@Nullable Project project, @NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/diff/contents/FileContentImpl", "<init>"));
        }
        assert (file.isValid() && !file.isDirectory());
        this.myProject = project;
        this.myFile = file;
        this.myType = file.getFileType();
    }

    @Nullable
    public OpenFileDescriptor getOpenFileDescriptor() {
        if (this.myProject == null || this.myProject.isDefault()) {
            return null;
        }
        return new OpenFileDescriptor(this.myProject, this.myFile);
    }

    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile = this.myFile;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/contents/FileContentImpl", "getFile"));
        }
        return virtualFile;
    }

    @NotNull
    public FileType getContentType() {
        FileType fileType = this.myType;
        if (fileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/contents/FileContentImpl", "getContentType"));
        }
        return fileType;
    }

    @NotNull
    public byte[] getBytes() throws IOException {
        byte[] byArray = this.myFile.contentsToByteArray();
        if (byArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/contents/FileContentImpl", "getBytes"));
        }
        return byArray;
    }

    @NotNull
    public String getFilePath() {
        String string = this.myFile.getPath();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/contents/FileContentImpl", "getFilePath"));
        }
        return string;
    }

    public void onAssigned(boolean isAssigned) {
    }
}

