/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.replaceInProject;

import com.intellij.find.FindBundle;
import com.intellij.find.FindManager;
import com.intellij.find.FindModel;
import com.intellij.find.FindResult;
import com.intellij.find.FindSettings;
import com.intellij.find.FindUtil;
import com.intellij.find.actions.FindInPathAction;
import com.intellij.find.findInProject.FindInProjectManager;
import com.intellij.find.impl.FindInProjectUtil;
import com.intellij.find.impl.FindManagerImpl;
import com.intellij.ide.DataManager;
import com.intellij.notification.NotificationGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.content.Content;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.FindUsagesProcessPresentation;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageSearcher;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.usages.impl.UsageViewImpl;
import com.intellij.usages.rules.UsageInFile;
import com.intellij.util.AdapterProcessor;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReplaceInProjectManager {
    static final NotificationGroup NOTIFICATION_GROUP = FindInPathAction.NOTIFICATION_GROUP;
    private final Project myProject;
    private boolean myIsFindInProgress = false;

    public static ReplaceInProjectManager getInstance(Project project) {
        return (ReplaceInProjectManager)ServiceManager.getService((Project)project, ReplaceInProjectManager.class);
    }

    public ReplaceInProjectManager(Project project) {
        this.myProject = project;
    }

    public static boolean hasReadOnlyUsages(Collection<Usage> usages) {
        for (Usage usage : usages) {
            if (!usage.isReadOnly()) continue;
            return true;
        }
        return false;
    }

    public void replaceInProject(@NotNull DataContext dataContext) {
        boolean isOpenInNewTabEnabled;
        boolean toOpenInNewTab;
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/find/replaceInProject/ReplaceInProjectManager", "replaceInProject"));
        }
        Content selectedContent = com.intellij.usageView.UsageViewManager.getInstance((Project)this.myProject).getSelectedContent(true);
        if (selectedContent != null && selectedContent.isPinned()) {
            toOpenInNewTab = true;
            isOpenInNewTabEnabled = false;
        } else {
            toOpenInNewTab = FindSettings.getInstance().isShowResultsInSeparateView();
            isOpenInNewTabEnabled = com.intellij.usageView.UsageViewManager.getInstance((Project)this.myProject).getReusableContentsCount() > 0;
        }
        final FindManager findManager = FindManager.getInstance((Project)this.myProject);
        final FindModel findModel = findManager.getFindInProjectModel().clone();
        findModel.setReplaceState(true);
        findModel.setOpenInNewTabVisible(true);
        findModel.setOpenInNewTabEnabled(isOpenInNewTabEnabled);
        findModel.setOpenInNewTab(toOpenInNewTab);
        FindInProjectUtil.setDirectoryName(findModel, dataContext);
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        FindUtil.initStringToFindWithSelection(findModel, editor);
        findManager.showFindDialog(findModel, new Runnable(){

            @Override
            public void run() {
                if (!findModel.isProjectScope() && FindInProjectUtil.getDirectory(findModel) == null && findModel.getModuleName() == null && findModel.getCustomScope() == null) {
                    return;
                }
                UsageViewManager manager = UsageViewManager.getInstance((Project)ReplaceInProjectManager.this.myProject);
                if (manager == null) {
                    return;
                }
                findManager.getFindInProjectModel().copyFrom(findModel);
                FindModel findModelCopy = findModel.clone();
                UsageViewPresentation presentation = FindInProjectUtil.setupViewPresentation(findModel.isOpenInNewTab(), findModelCopy);
                FindUsagesProcessPresentation processPresentation = FindInProjectUtil.setupProcessPresentation(ReplaceInProjectManager.this.myProject, true, presentation);
                UsageSearcherFactory factory = new UsageSearcherFactory(findModelCopy, processPresentation);
                ReplaceInProjectManager.this.searchAndShowUsages(manager, factory, findModelCopy, presentation, processPresentation, findManager);
            }
        });
    }

    public void searchAndShowUsages(@NotNull UsageViewManager manager, @NotNull Factory<UsageSearcher> usageSearcherFactory, @NotNull FindModel findModelCopy, @NotNull FindManager findManager) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/find/replaceInProject/ReplaceInProjectManager", "searchAndShowUsages"));
        }
        if (usageSearcherFactory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usageSearcherFactory", "com/intellij/find/replaceInProject/ReplaceInProjectManager", "searchAndShowUsages"));
        }
        if (findModelCopy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "findModelCopy", "com/intellij/find/replaceInProject/ReplaceInProjectManager", "searchAndShowUsages"));
        }
        if (findManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "findManager", "com/intellij/find/replaceInProject/ReplaceInProjectManager", "searchAndShowUsages"));
        }
        UsageViewPresentation presentation = FindInProjectUtil.setupViewPresentation(true, findModelCopy);
        FindUsagesProcessPresentation processPresentation = FindInProjectUtil.setupProcessPresentation(this.myProject, true, presentation);
        this.searchAndShowUsages(manager, usageSearcherFactory, findModelCopy, presentation, processPresentation, findManager);
    }

    public void searchAndShowUsages(@NotNull UsageViewManager manager, @NotNull Factory<UsageSearcher> usageSearcherFactory, final @NotNull FindModel findModelCopy, @NotNull UsageViewPresentation presentation, @NotNull FindUsagesProcessPresentation processPresentation, final FindManager findManager) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/find/replaceInProject/ReplaceInProjectManager", "searchAndShowUsages"));
        }
        if (usageSearcherFactory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usageSearcherFactory", "com/intellij/find/replaceInProject/ReplaceInProjectManager", "searchAndShowUsages"));
        }
        if (findModelCopy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "findModelCopy", "com/intellij/find/replaceInProject/ReplaceInProjectManager", "searchAndShowUsages"));
        }
        if (presentation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "com/intellij/find/replaceInProject/ReplaceInProjectManager", "searchAndShowUsages"));
        }
        if (processPresentation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processPresentation", "com/intellij/find/replaceInProject/ReplaceInProjectManager", "searchAndShowUsages"));
        }
        presentation.setMergeDupLinesAvailable(false);
        final ReplaceContext[] context = new ReplaceContext[1];
        ReplaceInProjectTarget target = new ReplaceInProjectTarget(this.myProject, findModelCopy);
        ((FindManagerImpl)FindManager.getInstance((Project)this.myProject)).getFindUsagesManager().addToHistory(target);
        manager.searchAndShowUsages(new UsageTarget[]{target}, usageSearcherFactory, processPresentation, presentation, new UsageViewManager.UsageViewStateListener(){

            public void usageViewCreated(@NotNull UsageView usageView) {
                if (usageView == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usageView", "com/intellij/find/replaceInProject/ReplaceInProjectManager$2", "usageViewCreated"));
                }
                context[0] = new ReplaceContext(usageView, findModelCopy);
                ReplaceInProjectManager.this.addReplaceActions(context[0]);
            }

            public void findingUsagesFinished(UsageView usageView) {
                if (context[0] != null && findManager.getFindInProjectModel().isPromptOnReplace()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ReplaceInProjectManager.this.replaceWithPrompt(context[0]);
                            context[0].invalidateExcludedSetCache();
                        }
                    });
                }
            }
        });
    }

    private void replaceWithPrompt(final ReplaceContext replaceContext) {
        final List _usages = replaceContext.getUsageView().getSortedUsages();
        if (ReplaceInProjectManager.hasReadOnlyUsages(_usages)) {
            WindowManager.getInstance().getStatusBar(this.myProject).setInfo(FindBundle.message("find.replace.occurrences.found.in.read.only.files.status", new Object[0]));
            return;
        }
        final Usage[] usages = _usages.toArray(new Usage[_usages.size()]);
        for (int i = 0; i < usages.length; ++i) {
            Runnable runnable2;
            int result2;
            PsiFile psiFile;
            final Usage usage = usages[i];
            UsageInfo usageInfo = ((UsageInfo2UsageAdapter)usage).getUsageInfo();
            PsiElement elt = usageInfo.getElement();
            if (elt == null || !(psiFile = elt.getContainingFile()).isWritable()) continue;
            final VirtualFile virtualFile = psiFile.getVirtualFile();
            Runnable selectOnEditorRunnable = new Runnable(){

                @Override
                public void run() {
                    if (virtualFile != null && ((Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

                        public Boolean compute() {
                            return virtualFile.isValid();
                        }
                    })).booleanValue() && usage.isValid()) {
                        usage.highlightInEditor();
                        replaceContext.getUsageView().selectUsages(new Usage[]{usage});
                    }
                }
            };
            String path = (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

                public String compute() {
                    return virtualFile != null ? virtualFile.getPath() : null;
                }
            });
            CommandProcessor.getInstance().executeCommand(this.myProject, selectOnEditorRunnable, FindBundle.message("find.replace.select.on.editor.command", new Object[0]), null);
            String title = FindBundle.message("find.replace.found.usage.title", i + 1, usages.length, path);
            try {
                this.replaceUsage(usage, replaceContext.getFindModel(), replaceContext.getExcludedSetCached(), true);
                result2 = FindManager.getInstance((Project)this.myProject).showPromptDialog(replaceContext.getFindModel(), title);
            }
            catch (FindManager.MalformedReplacementStringException e) {
                ReplaceInProjectManager.markAsMalformedReplacement(replaceContext, usage);
                result2 = FindManager.getInstance((Project)this.myProject).showMalformedReplacementPrompt(replaceContext.getFindModel(), title, e);
            }
            if (result2 == 1) {
                return;
            }
            if (result2 == 2) continue;
            final int currentNumber = i;
            if (result2 == 0) {
                final Ref success = Ref.create();
                runnable2 = new Runnable(){

                    @Override
                    public void run() {
                        success.set((Object)ReplaceInProjectManager.this.replaceUsageAndRemoveFromView(usage, replaceContext));
                    }
                };
                CommandProcessor.getInstance().executeCommand(this.myProject, runnable2, FindBundle.message("find.replace.command", new Object[0]), null);
                if (this.closeUsageViewIfEmpty(replaceContext.getUsageView(), (Boolean)success.get())) {
                    return;
                }
            }
            if (result2 == 6) {
                PsiElement nextElt;
                int j;
                for (j = i + 1; j < usages.length && ((nextElt = ((UsageInfo2UsageAdapter)usages[j]).getUsageInfo().getElement()) == null || nextElt.getContainingFile() == psiFile); ++j) {
                }
                i = j - 1;
            }
            if (result2 == 4) {
                final int[] nextNumber = new int[1];
                runnable2 = new Runnable(){

                    @Override
                    public void run() {
                        int j;
                        boolean success = true;
                        for (j = currentNumber; j < usages.length; ++j) {
                            Usage usage = usages[j];
                            UsageInfo usageInfo = ((UsageInfo2UsageAdapter)usage).getUsageInfo();
                            PsiElement elt = usageInfo.getElement();
                            if (elt == null) continue;
                            PsiFile otherPsiFile = elt.getContainingFile();
                            if (!otherPsiFile.equals(psiFile)) break;
                            if (ReplaceInProjectManager.this.replaceUsageAndRemoveFromView(usage, replaceContext)) continue;
                            success = false;
                        }
                        ReplaceInProjectManager.this.closeUsageViewIfEmpty(replaceContext.getUsageView(), success);
                        nextNumber[0] = j;
                    }
                };
                CommandProcessor.getInstance().executeCommand(this.myProject, runnable2, FindBundle.message("find.replace.command", new Object[0]), null);
                i = nextNumber[0] - 1;
            }
            if (result2 != 5) continue;
            CommandProcessor.getInstance().executeCommand(this.myProject, new Runnable(){

                @Override
                public void run() {
                    boolean success = ReplaceInProjectManager.this.replaceUsages(replaceContext, _usages);
                    ReplaceInProjectManager.this.closeUsageViewIfEmpty(replaceContext.getUsageView(), success);
                }
            }, FindBundle.message("find.replace.command", new Object[0]), null);
            break;
        }
    }

    private boolean replaceUsageAndRemoveFromView(Usage usage, ReplaceContext replaceContext) {
        try {
            if (this.replaceUsage(usage, replaceContext.getFindModel(), replaceContext.getExcludedSetCached(), false)) {
                replaceContext.getUsageView().removeUsage(usage);
            }
        }
        catch (FindManager.MalformedReplacementStringException e) {
            ReplaceInProjectManager.markAsMalformedReplacement(replaceContext, usage);
            return false;
        }
        return true;
    }

    private void addReplaceActions(final ReplaceContext replaceContext) {
        Runnable replaceRunnable = new Runnable(){

            @Override
            public void run() {
                ReplaceInProjectManager.this.replaceUsagesUnderCommand(replaceContext, replaceContext.getUsageView().getUsages());
            }
        };
        replaceContext.getUsageView().addButtonToLowerPane(replaceRunnable, FindBundle.message("find.replace.all.action", new Object[0]));
        Runnable replaceSelectedRunnable = new Runnable(){

            @Override
            public void run() {
                ReplaceInProjectManager.this.replaceUsagesUnderCommand(replaceContext, replaceContext.getUsageView().getSelectedUsages());
            }
        };
        replaceContext.getUsageView().addButtonToLowerPane(replaceSelectedRunnable, FindBundle.message("find.replace.selected.action", new Object[0]));
    }

    private boolean replaceUsages(@NotNull ReplaceContext replaceContext, @NotNull Collection<Usage> usages) {
        if (replaceContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "replaceContext", "com/intellij/find/replaceInProject/ReplaceInProjectManager", "replaceUsages"));
        }
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/find/replaceInProject/ReplaceInProjectManager", "replaceUsages"));
        }
        if (!this.ensureUsagesWritable(replaceContext, usages)) {
            return true;
        }
        int replacedCount = 0;
        boolean success = true;
        for (Usage usage : usages) {
            try {
                if (!this.replaceUsage(usage, replaceContext.getFindModel(), replaceContext.getExcludedSetCached(), false)) continue;
                ++replacedCount;
            }
            catch (FindManager.MalformedReplacementStringException e) {
                ReplaceInProjectManager.markAsMalformedReplacement(replaceContext, usage);
                success = false;
            }
        }
        replaceContext.getUsageView().removeUsagesBulk(usages);
        ReplaceInProjectManager.reportNumberReplacedOccurrences(this.myProject, replacedCount);
        return success;
    }

    private static void markAsMalformedReplacement(ReplaceContext replaceContext, Usage usage) {
        replaceContext.getUsageView().excludeUsages(new Usage[]{usage});
    }

    public static void reportNumberReplacedOccurrences(Project project, int occurrences) {
        StatusBar statusBar;
        if (occurrences != 0 && (statusBar = WindowManager.getInstance().getStatusBar(project)) != null) {
            statusBar.setInfo(FindBundle.message("0.occurrences.replaced", occurrences));
        }
    }

    public boolean replaceUsage(final @NotNull Usage usage, final @NotNull FindModel findModel, final @NotNull Set<Usage> excludedSet, final boolean justCheck) throws FindManager.MalformedReplacementStringException {
        if (usage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usage", "com/intellij/find/replaceInProject/ReplaceInProjectManager", "replaceUsage"));
        }
        if (findModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "findModel", "com/intellij/find/replaceInProject/ReplaceInProjectManager", "replaceUsage"));
        }
        if (excludedSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "excludedSet", "com/intellij/find/replaceInProject/ReplaceInProjectManager", "replaceUsage"));
        }
        final Ref exceptionResult = Ref.create();
        boolean result2 = (Boolean)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<Boolean>(){

            public Boolean compute() {
                if (excludedSet.contains(usage)) {
                    return false;
                }
                final Document document = ((UsageInfo2UsageAdapter)usage).getDocument();
                if (!document.isWritable()) {
                    return false;
                }
                boolean result2 = ((UsageInfo2UsageAdapter)usage).processRangeMarkers((Processor)new Processor<Segment>(){

                    public boolean process(Segment segment) {
                        int textOffset = segment.getStartOffset();
                        int textEndOffset = segment.getEndOffset();
                        Ref stringToReplace = Ref.create();
                        try {
                            if (!ReplaceInProjectManager.this.getStringToReplace(textOffset, textEndOffset, document, findModel, (Ref<String>)stringToReplace)) {
                                return true;
                            }
                            if (!stringToReplace.isNull() && !justCheck) {
                                document.replaceString(textOffset, textEndOffset, (CharSequence)stringToReplace.get());
                            }
                        }
                        catch (FindManager.MalformedReplacementStringException e) {
                            exceptionResult.set((Object)e);
                            return false;
                        }
                        return true;
                    }
                });
                return result2;
            }
        });
        if (!exceptionResult.isNull()) {
            throw (FindManager.MalformedReplacementStringException)((Object)exceptionResult.get());
        }
        return result2;
    }

    private boolean getStringToReplace(int textOffset, int textEndOffset, Document document, FindModel findModel, Ref<String> stringToReplace) throws FindManager.MalformedReplacementStringException {
        if (textOffset < 0 || textOffset >= document.getTextLength()) {
            return false;
        }
        if (textEndOffset < 0 || textOffset > document.getTextLength()) {
            return false;
        }
        FindManager findManager = FindManager.getInstance((Project)this.myProject);
        CharSequence foundString = document.getCharsSequence().subSequence(textOffset, textEndOffset);
        PsiFile file = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(document);
        FindResult findResult = findManager.findString(document.getCharsSequence(), textOffset, findModel, file != null ? file.getVirtualFile() : null);
        if (!findResult.isStringFound() || findResult.getStartOffset() < textOffset || findResult.getEndOffset() > textEndOffset) {
            return false;
        }
        stringToReplace.set((Object)FindManager.getInstance((Project)this.myProject).getStringToReplace(foundString.toString(), findModel, textOffset, (CharSequence)document.getText()));
        return true;
    }

    private void replaceUsagesUnderCommand(final @NotNull ReplaceContext replaceContext, @Nullable Set<Usage> usagesSet) {
        if (replaceContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "replaceContext", "com/intellij/find/replaceInProject/ReplaceInProjectManager", "replaceUsagesUnderCommand"));
        }
        if (usagesSet == null) {
            return;
        }
        final ArrayList<Usage> usages = new ArrayList<Usage>(usagesSet);
        Collections.sort(usages, UsageViewImpl.USAGE_COMPARATOR);
        if (!this.ensureUsagesWritable(replaceContext, usages)) {
            return;
        }
        CommandProcessor.getInstance().executeCommand(this.myProject, new Runnable(){

            @Override
            public void run() {
                boolean success = ReplaceInProjectManager.this.replaceUsages(replaceContext, usages);
                UsageView usageView = replaceContext.getUsageView();
                if (ReplaceInProjectManager.this.closeUsageViewIfEmpty(usageView, success)) {
                    return;
                }
                usageView.getComponent().requestFocus();
            }
        }, FindBundle.message("find.replace.command", new Object[0]), null);
        replaceContext.invalidateExcludedSetCache();
    }

    private boolean ensureUsagesWritable(ReplaceContext replaceContext, Collection<Usage> selectedUsages) {
        int result2;
        HashSet<VirtualFile> readOnlyFiles = null;
        for (Usage usage : selectedUsages) {
            VirtualFile file = ((UsageInFile)usage).getFile();
            if (file == null || file.isWritable()) continue;
            if (readOnlyFiles == null) {
                readOnlyFiles = new HashSet<VirtualFile>();
            }
            readOnlyFiles.add(file);
        }
        if (readOnlyFiles != null) {
            ReadonlyStatusHandler.getInstance((Project)this.myProject).ensureFilesWritable(VfsUtilCore.toVirtualFileArray(readOnlyFiles));
        }
        return !ReplaceInProjectManager.hasReadOnlyUsages(selectedUsages) || (result2 = Messages.showOkCancelDialog((Component)replaceContext.getUsageView().getComponent(), (String)FindBundle.message("find.replace.occurrences.in.read.only.files.prompt", new Object[0]), (String)FindBundle.message("find.replace.occurrences.in.read.only.files.title", new Object[0]), (Icon)Messages.getWarningIcon())) == 0;
    }

    private boolean closeUsageViewIfEmpty(UsageView usageView, boolean success) {
        if (usageView.getUsages().isEmpty()) {
            usageView.close();
            return true;
        }
        if (!success) {
            NOTIFICATION_GROUP.createNotification("One or more malformed replacement strings", MessageType.ERROR).notify(this.myProject);
        }
        return false;
    }

    public boolean isWorkInProgress() {
        return this.myIsFindInProgress;
    }

    public boolean isEnabled() {
        return !this.myIsFindInProgress && !FindInProjectManager.getInstance(this.myProject).isWorkInProgress();
    }

    private class UsageSearcherFactory
    implements Factory<UsageSearcher> {
        private final FindModel myFindModelCopy;
        private final FindUsagesProcessPresentation myProcessPresentation;

        private UsageSearcherFactory(@NotNull FindModel findModelCopy, FindUsagesProcessPresentation processPresentation) {
            if (findModelCopy == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "findModelCopy", "com/intellij/find/replaceInProject/ReplaceInProjectManager$UsageSearcherFactory", "<init>"));
            }
            if (processPresentation == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processPresentation", "com/intellij/find/replaceInProject/ReplaceInProjectManager$UsageSearcherFactory", "<init>"));
            }
            this.myFindModelCopy = findModelCopy;
            this.myProcessPresentation = processPresentation;
        }

        public UsageSearcher create() {
            return new UsageSearcher(){

                public void generate(@NotNull Processor<Usage> processor2) {
                    if (processor2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/find/replaceInProject/ReplaceInProjectManager$UsageSearcherFactory$1", "generate"));
                    }
                    try {
                        ReplaceInProjectManager.this.myIsFindInProgress = true;
                        FindInProjectUtil.findUsages(UsageSearcherFactory.this.myFindModelCopy, ReplaceInProjectManager.this.myProject, (Processor<UsageInfo>)new AdapterProcessor(processor2, (Function)UsageInfo2UsageAdapter.CONVERTER), UsageSearcherFactory.this.myProcessPresentation);
                    }
                    finally {
                        ReplaceInProjectManager.this.myIsFindInProgress = false;
                    }
                }
            };
        }
    }

    private static class ReplaceInProjectTarget
    extends FindInProjectUtil.StringUsageTarget {
        public ReplaceInProjectTarget(@NotNull Project project, @NotNull FindModel findModel) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/find/replaceInProject/ReplaceInProjectManager$ReplaceInProjectTarget", "<init>"));
            }
            if (findModel == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "findModel", "com/intellij/find/replaceInProject/ReplaceInProjectManager$ReplaceInProjectTarget", "<init>"));
            }
            super(project, findModel);
        }

        @Override
        @NotNull
        public String getLongDescriptiveName() {
            UsageViewPresentation presentation = FindInProjectUtil.setupViewPresentation(false, this.myFindModel);
            String string = "Replace " + StringUtil.decapitalize((String)presentation.getToolwindowTitle()) + " with '" + this.myFindModel.getStringToReplace() + "'";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/replaceInProject/ReplaceInProjectManager$ReplaceInProjectTarget", "getLongDescriptiveName"));
            }
            return string;
        }

        @Override
        public KeyboardShortcut getShortcut() {
            return ActionManager.getInstance().getKeyboardShortcut("ReplaceInPath");
        }

        @Override
        public void showSettings() {
            Content selectedContent = com.intellij.usageView.UsageViewManager.getInstance((Project)this.myProject).getSelectedContent(true);
            JComponent component = selectedContent == null ? null : selectedContent.getComponent();
            ReplaceInProjectManager findInProjectManager = ReplaceInProjectManager.getInstance(this.myProject);
            findInProjectManager.replaceInProject(DataManager.getInstance().getDataContext((Component)component));
        }
    }

    static class ReplaceContext {
        private final UsageView usageView;
        private final FindModel findModel;
        private Set<Usage> excludedSet;

        ReplaceContext(@NotNull UsageView usageView, @NotNull FindModel findModel) {
            if (usageView == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usageView", "com/intellij/find/replaceInProject/ReplaceInProjectManager$ReplaceContext", "<init>"));
            }
            if (findModel == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "findModel", "com/intellij/find/replaceInProject/ReplaceInProjectManager$ReplaceContext", "<init>"));
            }
            this.usageView = usageView;
            this.findModel = findModel;
        }

        @NotNull
        public FindModel getFindModel() {
            FindModel findModel = this.findModel;
            if (findModel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/replaceInProject/ReplaceInProjectManager$ReplaceContext", "getFindModel"));
            }
            return findModel;
        }

        @NotNull
        public UsageView getUsageView() {
            UsageView usageView = this.usageView;
            if (usageView == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/replaceInProject/ReplaceInProjectManager$ReplaceContext", "getUsageView"));
            }
            return usageView;
        }

        @NotNull
        public Set<Usage> getExcludedSetCached() {
            if (this.excludedSet == null) {
                this.excludedSet = this.usageView.getExcludedUsages();
            }
            Set<Usage> set = this.excludedSet;
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/replaceInProject/ReplaceInProjectManager$ReplaceContext", "getExcludedSetCached"));
            }
            return set;
        }

        public void invalidateExcludedSetCache() {
            this.excludedSet = null;
        }
    }
}

