/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.manage;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProviderImpl;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractProjectDataService;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsDataStorage;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManager;
import com.intellij.openapi.externalSystem.service.project.manage.ProjectDataService;
import com.intellij.openapi.externalSystem.util.DisposeAwareProjectChange;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.impl.ProjectImpl;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectDataManager {
    private static final Logger LOG = Logger.getInstance((String)("#" + ProjectDataManager.class.getName()));
    private static final com.intellij.openapi.util.Key<Boolean> DATA_READY = com.intellij.openapi.util.Key.create((String)"externalSystem.data.ready");
    @NotNull
    private final NotNullLazyValue<Map<Key<?>, List<ProjectDataService<?, ?>>>> myServices = new NotNullLazyValue<Map<Key<?>, List<ProjectDataService<?, ?>>>>(){

        @NotNull
        protected Map<Key<?>, List<ProjectDataService<?, ?>>> compute() {
            HashMap result2 = ContainerUtilRt.newHashMap();
            for (ProjectDataService service : (ProjectDataService[])ProjectDataService.EP_NAME.getExtensions()) {
                List services = (List)result2.get(service.getTargetDataKey());
                if (services == null) {
                    services = ContainerUtilRt.newArrayList();
                    result2.put(service.getTargetDataKey(), services);
                }
                services.add(service);
            }
            for (List services : result2.values()) {
                ExternalSystemApiUtil.orderAwareSort((List)services);
            }
            HashMap hashMap = result2;
            if (hashMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManager$1", "compute"));
            }
            return hashMap;
        }
    };

    public static ProjectDataManager getInstance() {
        return (ProjectDataManager)ServiceManager.getService(ProjectDataManager.class);
    }

    @Deprecated
    @Nullable
    public ProjectDataService<?, ?> getDataService(Key<?> key) {
        List dataServices = (List)((Map)this.myServices.getValue()).get(key);
        assert (dataServices == null || dataServices.isEmpty() || dataServices.size() == 1);
        return (ProjectDataService)ContainerUtil.getFirstItem((List)dataServices);
    }

    public void importData(@NotNull Collection<DataNode<?>> nodes, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider, boolean synchronous) {
        ProjectSystemId projectSystemId;
        ProjectData projectData;
        if (nodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodes", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManager", "importData"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManager", "importData"));
        }
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManager", "importData"));
        }
        if (project.isDisposed()) {
            return;
        }
        MultiMap grouped = ExternalSystemApiUtil.recursiveGroup(nodes);
        for (Key key : ((Map)this.myServices.getValue()).keySet()) {
            if (grouped.containsKey((Object)key)) continue;
            grouped.put((Object)key, Collections.emptyList());
        }
        Collection projects = grouped.get((Object)ProjectKeys.PROJECT);
        assert (projects.size() == 1 || projects.isEmpty());
        DataNode projectNode = (DataNode)ContainerUtil.getFirstItem((Collection)projects);
        if (projectNode != null) {
            projectData = (ProjectData)projectNode.getData();
            projectSystemId = ((ProjectData)projectNode.getData()).getOwner();
            ExternalProjectsDataStorage.getInstance(project).saveInclusionSettings((DataNode<ProjectData>)projectNode);
        } else {
            projectData = null;
            DataNode aModuleNode = (DataNode)ContainerUtil.getFirstItem((Collection)grouped.get((Object)ProjectKeys.MODULE));
            ProjectSystemId projectSystemId2 = projectSystemId = aModuleNode != null ? ((ModuleData)aModuleNode.getData()).getOwner() : null;
        }
        if (projectSystemId != null) {
            ExternalSystemUtil.scheduleExternalViewStructureUpdate(project, projectSystemId);
        }
        List onSuccessImportTasks = ContainerUtil.newSmartList();
        try {
            Set entries = grouped.entrySet();
            ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
            if (indicator != null) {
                indicator.setIndeterminate(false);
            }
            int size = entries.size();
            int count = 0;
            List postImportTasks = ContainerUtil.newSmartList();
            for (Map.Entry entry : entries) {
                if (indicator != null) {
                    String message = ExternalSystemBundle.message((String)"progress.update.text", (Object[])new Object[]{projectSystemId != null ? projectSystemId.getReadableName() : "", "Refresh " + ProjectDataManager.getReadableText((Key)entry.getKey())});
                    indicator.setText(message);
                    indicator.setFraction((double)count++ / (double)size);
                }
                this.doImportData((Key)entry.getKey(), (Collection)entry.getValue(), projectData, project, modelsProvider, postImportTasks, onSuccessImportTasks);
            }
            for (Runnable postImportTask : postImportTasks) {
                postImportTask.run();
            }
            ProjectDataManager.commit(modelsProvider, project, synchronous, "Imported data");
            if (indicator != null) {
                indicator.setIndeterminate(true);
            }
        }
        catch (Throwable t) {
            ProjectDataManager.dispose(modelsProvider, project, synchronous);
            ExceptionUtil.rethrowAllAsUnchecked((Throwable)t);
        }
        for (Runnable onSuccessImportTask : ContainerUtil.reverse((List)onSuccessImportTasks)) {
            onSuccessImportTask.run();
        }
    }

    @NotNull
    private static String getReadableText(@NotNull Key key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManager", "getReadableText"));
        }
        StringBuilder buffer = new StringBuilder();
        String s = key.toString();
        for (int i = 0; i < s.length(); ++i) {
            char currChar = s.charAt(i);
            if (Character.isUpperCase(currChar)) {
                if (i != 0) {
                    buffer.append(' ');
                }
                buffer.append(StringUtil.toLowerCase((char)currChar));
                continue;
            }
            buffer.append(currChar);
        }
        String string = buffer.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManager", "getReadableText"));
        }
        return string;
    }

    public <T> void importData(@NotNull Collection<DataNode<T>> nodes, @NotNull Project project, boolean synchronous) {
        if (nodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodes", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManager", "importData"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManager", "importData"));
        }
        List dummy = ContainerUtil.newSmartList();
        for (DataNode<T> node : nodes) {
            dummy.add(node);
        }
        this.importData(dummy, project, (IdeModifiableModelsProvider)new IdeModifiableModelsProviderImpl(project), synchronous);
    }

    public <T> void importData(@NotNull DataNode<T> node, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider, boolean synchronous) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManager", "importData"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManager", "importData"));
        }
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManager", "importData"));
        }
        List dummy = ContainerUtil.newSmartList();
        dummy.add(node);
        this.importData(dummy, project, modelsProvider, synchronous);
    }

    public <T> void importData(@NotNull DataNode<T> node, @NotNull Project project, boolean synchronous) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManager", "importData"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManager", "importData"));
        }
        this.importData(node, project, (IdeModifiableModelsProvider)new IdeModifiableModelsProviderImpl(project), synchronous);
    }

    private <T> void doImportData(@NotNull Key<T> key, @NotNull Collection<DataNode<?>> nodes, final @Nullable ProjectData projectData, final @NotNull Project project, final @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull List<Runnable> postImportTasks, @NotNull List<Runnable> onSuccessImportTasks) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManager", "doImportData"));
        }
        if (nodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodes", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManager", "doImportData"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManager", "doImportData"));
        }
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManager", "doImportData"));
        }
        if (postImportTasks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "postImportTasks", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManager", "doImportData"));
        }
        if (onSuccessImportTasks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "onSuccessImportTasks", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManager", "doImportData"));
        }
        if (project.isDisposed()) {
            return;
        }
        if (project instanceof ProjectImpl) assert (((ProjectImpl)project).isComponentsCreated());
        final List toImport = ContainerUtil.newSmartList();
        List toIgnore = ContainerUtil.newSmartList();
        for (DataNode<?> node : nodes) {
            if (!key.equals((Object)node.getKey())) continue;
            if (node.isIgnored()) {
                toIgnore.add(node);
                continue;
            }
            toImport.add(node);
        }
        this.ensureTheDataIsReadyToUse(toImport);
        final List services = (List)((Map)this.myServices.getValue()).get(key);
        if (services == null) {
            LOG.warn(String.format("Can't import data nodes '%s'. Reason: no service is registered for key %s. Available services for %s", toImport, key, ((Map)this.myServices.getValue()).keySet()));
        } else {
            for (ProjectDataService service : services) {
                long importStartTime = System.currentTimeMillis();
                service.importData((Collection)toImport, projectData, project, modelsProvider);
                long importTimeInMs = System.currentTimeMillis() - importStartTime;
                LOG.debug(String.format("Service %s imported data in %d ms", service.getClass().getSimpleName(), importTimeInMs));
                if (projectData == null) continue;
                this.ensureTheDataIsReadyToUse(toIgnore);
                long removeStartTime = System.currentTimeMillis();
                Computable orphanIdeDataComputable = service.computeOrphanData((Collection)toImport, projectData, project, modelsProvider);
                service.removeData(orphanIdeDataComputable, (Collection)toIgnore, projectData, project, modelsProvider);
                long removeTimeInMs = System.currentTimeMillis() - removeStartTime;
                LOG.debug(String.format("Service %s computed and removed data in %d ms", service.getClass().getSimpleName(), removeTimeInMs));
            }
        }
        if (services != null && projectData != null) {
            postImportTasks.add(new Runnable(){

                @Override
                public void run() {
                    for (ProjectDataService service : services) {
                        if (!(service instanceof AbstractProjectDataService)) continue;
                        long taskStartTime = System.currentTimeMillis();
                        ((AbstractProjectDataService)service).postProcess((Collection)toImport, projectData, project, modelsProvider);
                        long taskTimeInMs = System.currentTimeMillis() - taskStartTime;
                        LOG.debug(String.format("Service %s run post import task in %d ms", service.getClass().getSimpleName(), taskTimeInMs));
                    }
                }
            });
            onSuccessImportTasks.add(new Runnable(){

                @Override
                public void run() {
                    for (ProjectDataService service : services) {
                        if (!(service instanceof AbstractProjectDataService)) continue;
                        long taskStartTime = System.currentTimeMillis();
                        ((AbstractProjectDataService)service).onSuccessImport(project);
                        long taskTimeInMs = System.currentTimeMillis() - taskStartTime;
                        LOG.debug(String.format("Service %s run post import task in %d ms", service.getClass().getSimpleName(), taskTimeInMs));
                    }
                }
            });
        }
    }

    public void ensureTheDataIsReadyToUse(@Nullable DataNode dataNode) {
        if (dataNode == null) {
            return;
        }
        if (Boolean.TRUE.equals(dataNode.getUserData(DATA_READY))) {
            return;
        }
        ExternalSystemApiUtil.visit((DataNode)dataNode, (Consumer)new Consumer<DataNode<?>>(){

            public void consume(DataNode dataNode) {
                ProjectDataManager.this.prepareDataToUse(dataNode);
                dataNode.putUserData(DATA_READY, (Object)Boolean.TRUE);
            }
        });
    }

    public <E, I> void removeData(@NotNull Key<E> key, @NotNull Collection<I> toRemove, @NotNull Collection<DataNode<E>> toIgnore, @NotNull ProjectData projectData, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider, boolean synchronous) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManager", "removeData"));
        }
        if (toRemove == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toRemove", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManager", "removeData"));
        }
        if (toIgnore == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toIgnore", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManager", "removeData"));
        }
        if (projectData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectData", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManager", "removeData"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManager", "removeData"));
        }
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManager", "removeData"));
        }
        try {
            List services = (List)((Map)this.myServices.getValue()).get(key);
            for (ProjectDataService service : services) {
                long removeStartTime = System.currentTimeMillis();
                service.removeData((Computable)new Computable.PredefinedValueComputable(toRemove), toIgnore, projectData, project, modelsProvider);
                long removeTimeInMs = System.currentTimeMillis() - removeStartTime;
                LOG.debug(String.format("Service %s removed data in %d ms", service.getClass().getSimpleName(), removeTimeInMs));
            }
            ProjectDataManager.commit(modelsProvider, project, synchronous, "Removed data");
        }
        catch (Throwable t) {
            ProjectDataManager.dispose(modelsProvider, project, synchronous);
            ExceptionUtil.rethrowAllAsUnchecked((Throwable)t);
        }
    }

    public <E, I> void removeData(@NotNull Key<E> key, @NotNull Collection<I> toRemove, @NotNull Collection<DataNode<E>> toIgnore, @NotNull ProjectData projectData, @NotNull Project project, boolean synchronous) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManager", "removeData"));
        }
        if (toRemove == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toRemove", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManager", "removeData"));
        }
        if (toIgnore == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toIgnore", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManager", "removeData"));
        }
        if (projectData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectData", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManager", "removeData"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManager", "removeData"));
        }
        this.removeData(key, toRemove, toIgnore, projectData, project, new IdeModifiableModelsProviderImpl(project), synchronous);
    }

    public void updateExternalProjectData(@NotNull Project project, @NotNull ExternalProjectInfo externalProjectInfo) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManager", "updateExternalProjectData"));
        }
        if (externalProjectInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalProjectInfo", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManager", "updateExternalProjectData"));
        }
        if (!project.isDisposed()) {
            ExternalProjectsManager.getInstance(project).updateExternalProjectData(externalProjectInfo);
        }
    }

    @Nullable
    public ExternalProjectInfo getExternalProjectData(@NotNull Project project, @NotNull ProjectSystemId projectSystemId, @NotNull String externalProjectPath) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManager", "getExternalProjectData"));
        }
        if (projectSystemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectSystemId", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManager", "getExternalProjectData"));
        }
        if (externalProjectPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalProjectPath", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManager", "getExternalProjectData"));
        }
        return !project.isDisposed() ? ExternalProjectsDataStorage.getInstance(project).get(projectSystemId, externalProjectPath) : null;
    }

    @NotNull
    public Collection<ExternalProjectInfo> getExternalProjectsData(@NotNull Project project, @NotNull ProjectSystemId projectSystemId) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManager", "getExternalProjectsData"));
        }
        if (projectSystemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectSystemId", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManager", "getExternalProjectsData"));
        }
        if (!project.isDisposed()) {
            Collection<ExternalProjectInfo> collection = ExternalProjectsDataStorage.getInstance(project).list(projectSystemId);
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManager", "getExternalProjectsData"));
            }
            return collection;
        }
        List list = ContainerUtil.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManager", "getExternalProjectsData"));
        }
        return list;
    }

    private void ensureTheDataIsReadyToUse(@NotNull Collection<DataNode<?>> nodes) {
        if (nodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodes", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManager", "ensureTheDataIsReadyToUse"));
        }
        for (DataNode<?> node : nodes) {
            this.ensureTheDataIsReadyToUse(node);
        }
    }

    private void prepareDataToUse(@NotNull DataNode dataNode) {
        if (dataNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataNode", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManager", "prepareDataToUse"));
        }
        Map servicesByKey = (Map)this.myServices.getValue();
        List services = (List)servicesByKey.get(dataNode.getKey());
        if (services != null) {
            try {
                dataNode.prepareData((ClassLoader[])ContainerUtil.map2Array((Collection)services, ClassLoader.class, (Function)new Function<ProjectDataService<?, ?>, ClassLoader>(){

                    public ClassLoader fun(ProjectDataService<?, ?> service) {
                        return service.getClass().getClassLoader();
                    }
                }));
            }
            catch (Exception e) {
                LOG.debug((Throwable)e);
                dataNode.clear(true);
            }
        }
    }

    private static void commit(final @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull Project project, boolean synchronous, final @NotNull String commitDesc) {
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManager", "commit"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManager", "commit"));
        }
        if (commitDesc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitDesc", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManager", "commit"));
        }
        ExternalSystemApiUtil.executeProjectChangeAction((boolean)synchronous, (DisposeAwareProjectChange)new DisposeAwareProjectChange((ComponentManager)project){

            public void execute() {
                long startTime = System.currentTimeMillis();
                modelsProvider.commit();
                long timeInMs = System.currentTimeMillis() - startTime;
                LOG.debug(String.format("%s committed in %d ms", commitDesc, timeInMs));
            }
        });
    }

    private static void dispose(final @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull Project project, boolean synchronous) {
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManager", "dispose"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManager", "dispose"));
        }
        ExternalSystemApiUtil.executeProjectChangeAction((boolean)synchronous, (DisposeAwareProjectChange)new DisposeAwareProjectChange((ComponentManager)project){

            public void execute() {
                modelsProvider.dispose();
            }
        });
    }
}

