/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.committed;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.CachingCommittedChangesProvider;
import com.intellij.openapi.vcs.CommittedChangesProvider;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.RepositoryLocation;
import com.intellij.openapi.vcs.changes.committed.ChangesCacheFile;
import com.intellij.openapi.vcs.changes.committed.RepositoryLocationCache;
import com.intellij.openapi.vcs.changes.committed.RootsCalculator;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.NotNullFunction;
import com.intellij.util.PairProcessor;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CachesHolder {
    @NonNls
    private static final String VCS_CACHE_PATH = "vcsCache";
    private final Project myProject;
    private final Map<String, ChangesCacheFile> myCacheFiles;
    private final RepositoryLocationCache myLocationCache;
    private final ProjectLevelVcsManager myPlManager;

    public CachesHolder(Project project, RepositoryLocationCache locationCache) {
        this.myProject = project;
        this.myLocationCache = locationCache;
        this.myPlManager = ProjectLevelVcsManager.getInstance((Project)this.myProject);
        this.myCacheFiles = ContainerUtil.newConcurrentMap();
    }

    public CachesHolder(Project project, RepositoryLocationCache locationCache, ProjectLevelVcsManager manager) {
        this.myProject = project;
        this.myPlManager = manager;
        this.myLocationCache = locationCache;
        this.myCacheFiles = ContainerUtil.newConcurrentMap();
    }

    public Map<VirtualFile, RepositoryLocation> getAllRootsUnderVcs(AbstractVcs vcs) {
        RootsCalculator calculator = new RootsCalculator(this.myProject, vcs, this.myLocationCache);
        return calculator.getRoots();
    }

    public void iterateAllRepositoryLocations(PairProcessor<RepositoryLocation, AbstractVcs> locationProcessor) {
        AbstractVcs[] vcses;
        for (AbstractVcs vcs : vcses = this.myPlManager.getAllActiveVcss()) {
            CommittedChangesProvider provider = vcs.getCommittedChangesProvider();
            if (!(provider instanceof CachingCommittedChangesProvider)) continue;
            Map<VirtualFile, RepositoryLocation> map = this.getAllRootsUnderVcs(vcs);
            for (VirtualFile root : map.keySet()) {
                RepositoryLocation location = map.get(root);
                if (Boolean.TRUE.equals(locationProcessor.process((Object)location, (Object)vcs))) continue;
                return;
            }
        }
    }

    public void iterateAllCaches(NotNullFunction<ChangesCacheFile, Boolean> consumer) {
        AbstractVcs[] vcses;
        for (AbstractVcs vcs : vcses = this.myPlManager.getAllActiveVcss()) {
            CommittedChangesProvider provider = vcs.getCommittedChangesProvider();
            if (!(provider instanceof CachingCommittedChangesProvider)) continue;
            Map<VirtualFile, RepositoryLocation> map = this.getAllRootsUnderVcs(vcs);
            for (VirtualFile root : map.keySet()) {
                RepositoryLocation location;
                ChangesCacheFile cacheFile = this.getCacheFile(vcs, root, location = map.get(root));
                if (!Boolean.TRUE.equals(consumer.fun((Object)cacheFile))) continue;
                return;
            }
        }
    }

    public void clearAllCaches() {
        for (Map.Entry<String, ChangesCacheFile> entry : this.myCacheFiles.entrySet()) {
            entry.getValue().delete();
        }
        this.myCacheFiles.clear();
    }

    public List<ChangesCacheFile> getAllCaches() {
        final ArrayList<ChangesCacheFile> result2 = new ArrayList<ChangesCacheFile>();
        this.iterateAllCaches(new NotNullFunction<ChangesCacheFile, Boolean>(){

            @NotNull
            public Boolean fun(ChangesCacheFile changesCacheFile) {
                result2.add(changesCacheFile);
                Boolean bl = false;
                if (bl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/committed/CachesHolder$1", "fun"));
                }
                return bl;
            }
        });
        return result2;
    }

    public ChangesCacheFile getCacheFile(AbstractVcs vcs, VirtualFile root, RepositoryLocation location) {
        String key = location.getKey();
        ChangesCacheFile cacheFile = this.myCacheFiles.get(key);
        if (cacheFile == null) {
            cacheFile = new ChangesCacheFile(this.myProject, this.getCachePath(location), vcs, root, location);
            this.myCacheFiles.put(key, cacheFile);
        }
        return cacheFile;
    }

    public File getCacheBasePath() {
        File file = new File(PathManager.getSystemPath(), VCS_CACHE_PATH);
        file = new File(file, this.myProject.getLocationHash());
        return file;
    }

    private File getCachePath(RepositoryLocation location) {
        File file = this.getCacheBasePath();
        file.mkdirs();
        String s = location.getKey();
        try {
            byte[] bytes = MessageDigest.getInstance("MD5").digest(CharsetToolkit.getUtf8Bytes((String)s));
            StringBuilder result2 = new StringBuilder();
            for (byte aByte : bytes) {
                result2.append(String.format("%02x", aByte));
            }
            return new File(file, result2.toString());
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public ChangesCacheFile haveCache(RepositoryLocation location) {
        String key = location.getKey();
        if (this.myCacheFiles.containsKey(key)) {
            return this.myCacheFiles.get(key);
        }
        key = key.endsWith("/") ? key : key + "/";
        for (String s : this.myCacheFiles.keySet()) {
            if (!key.startsWith(s) && !s.startsWith(key)) continue;
            return this.myCacheFiles.get(s);
        }
        return null;
    }
}

