/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.project.model.impl.module;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.impl.RootModelBase;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.project.model.impl.module.JpsOrderEntryFactory;
import com.intellij.project.model.impl.module.content.JpsContentEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.module.JpsDependencyElement;
import org.jetbrains.jps.model.module.JpsModule;

public class JpsRootModel
extends RootModelBase
implements ModuleRootModel {
    private final Module myModule;
    private final JpsModule myJpsModule;
    public VirtualFilePointer myExplodedDirectoryPointer;
    private final List<ContentEntry> myContentEntries;
    private final List<OrderEntry> myOrderEntries;

    public JpsRootModel(Module module, JpsModule jpsModule) {
        this.myModule = module;
        this.myJpsModule = jpsModule;
        this.myContentEntries = new ArrayList<ContentEntry>();
        for (String contentRoot : this.myJpsModule.getContentRootsList().getUrls()) {
            this.myContentEntries.add(new JpsContentEntry(jpsModule, this, contentRoot));
        }
        this.myOrderEntries = new ArrayList<OrderEntry>();
        for (JpsDependencyElement element : this.myJpsModule.getDependenciesList().getDependencies()) {
            this.myOrderEntries.add(JpsOrderEntryFactory.createOrderEntry(this, element));
        }
    }

    public JpsModule getJpsModule() {
        return this.myJpsModule;
    }

    @NotNull
    public Module getModule() {
        Module module = this.myModule;
        if (module == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/project/model/impl/module/JpsRootModel", "getModule"));
        }
        return module;
    }

    @Override
    protected Collection<ContentEntry> getContent() {
        return this.myContentEntries;
    }

    @NotNull
    public OrderEntry[] getOrderEntries() {
        OrderEntry[] orderEntryArray = this.myOrderEntries.toArray(new OrderEntry[this.myOrderEntries.size()]);
        if (orderEntryArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/project/model/impl/module/JpsRootModel", "getOrderEntries"));
        }
        return orderEntryArray;
    }

    public <T> T getModuleExtension(Class<T> klass) {
        throw new UnsupportedOperationException("'getModuleExtension' not implemented in " + this.getClass().getName());
    }

    public Project getProject() {
        return this.myModule.getProject();
    }

    public boolean isExcludeExplodedDirectory() {
        return false;
    }
}

