/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.injected;

import com.intellij.codeInsight.daemon.impl.DaemonProgressIndicator;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.injected.editor.DocumentWindowImpl;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.injected.editor.VirtualFileWindowImpl;
import com.intellij.lang.ASTNode;
import com.intellij.lang.FileASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.fileEditor.impl.FileDocumentManagerImpl;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.UnfairTextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.LanguageSubstitutors;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiLock;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.DocumentCommitProcessor;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.psi.impl.smartPointers.SmartPointerManagerImpl;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.resolve.FileContextUtil;
import com.intellij.psi.impl.source.text.BlockSupportImpl;
import com.intellij.psi.impl.source.text.DiffLog;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.impl.source.tree.injected.InjectedFileViewProvider;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.impl.source.tree.injected.LeafPatcher;
import com.intellij.psi.impl.source.tree.injected.Place;
import com.intellij.psi.impl.source.tree.injected.ShredImpl;
import com.intellij.psi.injection.ReferenceInjector;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.Function;
import com.intellij.util.PathUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ConcurrentList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MultiHostRegistrarImpl
implements MultiHostRegistrar,
ModificationTracker {
    private List<Pair<Place, PsiFile>> result;
    private Language myLanguage;
    private List<LiteralTextEscaper<? extends PsiLanguageInjectionHost>> escapers;
    private List<PsiLanguageInjectionHost.Shred> shreds;
    private StringBuilder outChars;
    private boolean isOneLineEditor;
    private boolean cleared;
    private String fileExtension;
    private final Project myProject;
    private final PsiManager myPsiManager;
    private final DocumentEx myHostDocument;
    private final VirtualFile myHostVirtualFile;
    private final PsiElement myContextElement;
    private final PsiFile myHostPsiFile;
    private ReferenceInjector myReferenceInjector;
    private static final Key<ASTNode> TREE_HARD_REF = Key.create((String)"TREE_HARD_REF");

    MultiHostRegistrarImpl(@NotNull Project project, @NotNull PsiFile hostPsiFile, @NotNull PsiElement contextElement) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/source/tree/injected/MultiHostRegistrarImpl", "<init>"));
        }
        if (hostPsiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hostPsiFile", "com/intellij/psi/impl/source/tree/injected/MultiHostRegistrarImpl", "<init>"));
        }
        if (contextElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextElement", "com/intellij/psi/impl/source/tree/injected/MultiHostRegistrarImpl", "<init>"));
        }
        this.myProject = project;
        this.myContextElement = contextElement;
        this.myHostPsiFile = PsiUtilCore.getTemplateLanguageFile((PsiElement)hostPsiFile);
        this.myPsiManager = this.myHostPsiFile.getManager();
        this.cleared = true;
        FileViewProvider viewProvider = this.myHostPsiFile.getViewProvider();
        this.myHostVirtualFile = viewProvider.getVirtualFile();
        this.myHostDocument = (DocumentEx)viewProvider.getDocument();
    }

    public List<Pair<Place, PsiFile>> getResult() {
        return this.result;
    }

    @NotNull
    public PsiElement getContextElement() {
        PsiElement psiElement = this.myContextElement;
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/injected/MultiHostRegistrarImpl", "getContextElement"));
        }
        return psiElement;
    }

    @NotNull
    public MultiHostRegistrar startInjecting(@NotNull Language language) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/psi/impl/source/tree/injected/MultiHostRegistrarImpl", "startInjecting"));
        }
        this.escapers = new SmartList();
        this.shreds = new SmartList();
        this.outChars = new StringBuilder();
        if (!this.cleared) {
            this.clear();
            throw new IllegalStateException("Seems you haven't called doneInjecting()");
        }
        if (LanguageParserDefinitions.INSTANCE.forLanguage(language) == null) {
            ReferenceInjector injector = ReferenceInjector.findById((String)language.getID());
            if (injector == null) {
                throw new UnsupportedOperationException("Cannot inject language '" + language + "' since its getParserDefinition() returns null");
            }
            this.myLanguage = null;
            this.myReferenceInjector = injector;
        }
        this.myLanguage = language;
        MultiHostRegistrarImpl multiHostRegistrarImpl = this;
        if (multiHostRegistrarImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/injected/MultiHostRegistrarImpl", "startInjecting"));
        }
        return multiHostRegistrarImpl;
    }

    private void clear() {
        this.escapers.clear();
        this.shreds.clear();
        this.outChars.setLength(0);
        this.isOneLineEditor = false;
        this.fileExtension = null;
        this.myLanguage = null;
        this.cleared = true;
    }

    public void setFileExtension(@Nullable String fileExtension) {
        this.fileExtension = fileExtension;
    }

    @NotNull
    public MultiHostRegistrar addPlace(@NonNls @Nullable String prefix, @NonNls @Nullable String suffix, @NotNull PsiLanguageInjectionHost host, @NotNull TextRange rangeInsideHost) {
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/psi/impl/source/tree/injected/MultiHostRegistrarImpl", "addPlace"));
        }
        if (rangeInsideHost == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangeInsideHost", "com/intellij/psi/impl/source/tree/injected/MultiHostRegistrarImpl", "addPlace"));
        }
        PsiFile containingFile = PsiUtilCore.getTemplateLanguageFile((PsiElement)host);
        assert (containingFile == this.myHostPsiFile) : this.exceptionContext("Trying to inject into foreign file: " + containingFile);
        TextRange hostTextRange = host.getTextRange();
        if (!hostTextRange.contains(rangeInsideHost.shiftRight(hostTextRange.getStartOffset()))) {
            this.clear();
            throw new IllegalArgumentException("rangeInsideHost must lie within host text range. rangeInsideHost:" + rangeInsideHost + "; host textRange:" + hostTextRange);
        }
        if (this.myLanguage == null && this.myReferenceInjector == null) {
            this.clear();
            throw new IllegalStateException("Seems you haven't called startInjecting()");
        }
        if (prefix == null) {
            prefix = "";
        }
        if (suffix == null) {
            suffix = "";
        }
        this.cleared = false;
        int startOffset = this.outChars.length();
        this.outChars.append(prefix);
        LiteralTextEscaper textEscaper = host.createLiteralTextEscaper();
        this.escapers.add((LiteralTextEscaper<? extends PsiLanguageInjectionHost>)textEscaper);
        this.isOneLineEditor |= textEscaper.isOneLine();
        TextRange relevantRange = textEscaper.getRelevantTextRange().intersection(rangeInsideHost);
        if (relevantRange == null) {
            relevantRange = TextRange.from((int)textEscaper.getRelevantTextRange().getStartOffset(), (int)0);
        } else {
            int before = this.outChars.length();
            boolean result2 = textEscaper.decode(relevantRange, this.outChars);
            int after = this.outChars.length();
            assert (after >= before) : "Escaper " + textEscaper + "(" + textEscaper.getClass() + ") must not mangle char buffer";
            if (!result2) {
                int offsetInHost = textEscaper.getOffsetInHost(this.outChars.length() - before, rangeInsideHost);
                relevantRange = relevantRange.intersection((TextRange)new ProperTextRange(0, offsetInHost));
            }
        }
        this.outChars.append(suffix);
        int endOffset = this.outChars.length();
        TextRange relevantRangeInHost = relevantRange.shiftRight(hostTextRange.getStartOffset());
        SmartPointerManagerImpl manager = (SmartPointerManagerImpl)SmartPointerManager.getInstance((Project)this.myProject);
        this.shreds.add(new ShredImpl(manager.createSmartPsiFileRangePointer(this.myHostPsiFile, relevantRangeInHost, true), manager.createSmartPsiElementPointer(host, this.myHostPsiFile), prefix, suffix, (TextRange)new ProperTextRange(startOffset, endOffset), false));
        MultiHostRegistrarImpl multiHostRegistrarImpl = this;
        if (multiHostRegistrarImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/injected/MultiHostRegistrarImpl", "addPlace"));
        }
        return multiHostRegistrarImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doneInjecting() {
        try {
            if (this.shreds.isEmpty()) {
                throw new IllegalStateException("Seems you haven't called addPlace()");
            }
            if (this.myReferenceInjector != null) {
                this.addToResults(new Place(this.shreds), null);
                return;
            }
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)this.myProject);
            Place place = new Place(this.shreds);
            DocumentWindowImpl documentWindow = new DocumentWindowImpl(this.myHostDocument, this.isOneLineEditor, place);
            String fileName = PathUtil.makeFileName((String)this.myHostVirtualFile.getName(), (String)this.fileExtension);
            VirtualFileWindowImpl virtualFile = new VirtualFileWindowImpl(fileName, this.myHostVirtualFile, documentWindow, this.myLanguage, this.outChars);
            Language forcedLanguage = (Language)this.myContextElement.getUserData(InjectedFileViewProvider.LANGUAGE_FOR_INJECTED_COPY_KEY);
            this.myLanguage = forcedLanguage == null ? LanguageSubstitutors.INSTANCE.substituteLanguage(this.myLanguage, (VirtualFile)virtualFile, this.myProject) : forcedLanguage;
            MultiHostRegistrarImpl.createDocument(virtualFile);
            InjectedFileViewProvider viewProvider = new InjectedFileViewProvider(this.myPsiManager, virtualFile, documentWindow, this.myLanguage);
            ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(this.myLanguage);
            assert (parserDefinition != null) : "Parser definition for language " + this.myLanguage + " is null";
            PsiFile psiFile = parserDefinition.createFile((FileViewProvider)viewProvider);
            SmartPsiElementPointer<PsiLanguageInjectionHost> pointer = ((ShredImpl)this.shreds.get(0)).getSmartPointer();
            Object object = PsiLock.LOCK;
            synchronized (object) {
                boolean mergeHappened;
                ASTNode parsedNode = MultiHostRegistrarImpl.keepTreeFromChameleoningBack(psiFile);
                assert (parsedNode instanceof FileElement) : "Parsed to " + parsedNode + " instead of FileElement";
                String documentText = documentWindow.getText();
                assert (((FileElement)parsedNode).textMatches(this.outChars)) : this.exceptionContext("Before patch: doc:\n'" + documentText + "'\n---PSI:\n'" + parsedNode.getText() + "'\n---chars:\n'" + this.outChars + "'");
                viewProvider.setPatchingLeaves(true);
                try {
                    MultiHostRegistrarImpl.patchLeaves(parsedNode, this.escapers, place);
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (RuntimeException e) {
                    throw new RuntimeException(this.exceptionContext("Patch error"), e);
                }
                finally {
                    viewProvider.setPatchingLeaves(false);
                }
                if (!((FileElement)parsedNode).textMatches(documentText)) {
                    throw new AssertionError((Object)this.exceptionContext("After patch: doc:\n'" + documentText + "'\n---PSI:\n'" + parsedNode.getText() + "'\n---chars:\n'" + this.outChars + "'"));
                }
                virtualFile.setContent(null, documentWindow.getText(), false);
                MultiHostRegistrarImpl.cacheEverything(place, documentWindow, viewProvider, psiFile, pointer);
                PsiFile cachedPsiFile = documentManager.getCachedPsiFile((Document)documentWindow);
                assert (cachedPsiFile == psiFile) : "Cached psi :" + cachedPsiFile + " instead of " + psiFile;
                assert (place.isValid());
                assert (viewProvider.isValid());
                PsiFile newFile = MultiHostRegistrarImpl.registerDocument(documentWindow, psiFile, place, this.myHostPsiFile, documentManager);
                boolean bl = mergeHappened = newFile != psiFile;
                if (mergeHappened) {
                    InjectedLanguageUtil.clearCaches(psiFile, documentWindow);
                    psiFile = newFile;
                    viewProvider = (InjectedFileViewProvider)psiFile.getViewProvider();
                    documentWindow = (DocumentWindowImpl)viewProvider.getDocument();
                    virtualFile = (VirtualFileWindowImpl)viewProvider.getVirtualFile();
                    boolean shredsRewritten = MultiHostRegistrarImpl.cacheEverything(place, documentWindow, viewProvider, psiFile, pointer);
                    if (!shredsRewritten) {
                        place.dispose();
                        place = documentWindow.getShreds();
                    }
                }
                assert (psiFile.isValid());
                assert (place.isValid());
                assert (viewProvider.isValid());
                try {
                    List<Trinity<IElementType, SmartPsiElementPointer<PsiLanguageInjectionHost>, TextRange>> tokens = MultiHostRegistrarImpl.obtainHighlightTokensFromLexer(this.myLanguage, this.outChars, this.escapers, place, virtualFile, this.myProject);
                    psiFile.putUserData(InjectedLanguageUtil.HIGHLIGHT_TOKENS, tokens);
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (RuntimeException e) {
                    throw new RuntimeException(this.exceptionContext("Obtaining tokens error"), e);
                }
                this.addToResults(place, psiFile);
                this.assertEverythingIsAllright(documentManager, documentWindow, psiFile);
            }
        }
        finally {
            this.clear();
        }
    }

    @NotNull
    private static DocumentEx createDocument(@NotNull LightVirtualFile virtualFile) {
        CharSequence content;
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/psi/impl/source/tree/injected/MultiHostRegistrarImpl", "createDocument"));
        }
        DocumentImpl document = new DocumentImpl(content, StringUtil.indexOf((CharSequence)(content = virtualFile.getContent()), (char)'\r') >= 0, false);
        FileDocumentManagerImpl.registerDocument(document, (VirtualFile)virtualFile);
        DocumentImpl documentImpl = document;
        if (documentImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/injected/MultiHostRegistrarImpl", "createDocument"));
        }
        return documentImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean cacheEverything(@NotNull Place place, @NotNull DocumentWindowImpl documentWindow, @NotNull InjectedFileViewProvider viewProvider, @NotNull PsiFile psiFile, @NotNull SmartPsiElementPointer<PsiLanguageInjectionHost> pointer) {
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/psi/impl/source/tree/injected/MultiHostRegistrarImpl", "cacheEverything"));
        }
        if (documentWindow == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "documentWindow", "com/intellij/psi/impl/source/tree/injected/MultiHostRegistrarImpl", "cacheEverything"));
        }
        if (viewProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewProvider", "com/intellij/psi/impl/source/tree/injected/MultiHostRegistrarImpl", "cacheEverything"));
        }
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/psi/impl/source/tree/injected/MultiHostRegistrarImpl", "cacheEverything"));
        }
        if (pointer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pointer", "com/intellij/psi/impl/source/tree/injected/MultiHostRegistrarImpl", "cacheEverything"));
        }
        FileDocumentManagerImpl.registerDocument(documentWindow, viewProvider.getVirtualFile());
        DebugUtil.startPsiModification("MultiHostRegistrar cacheEverything");
        try {
            viewProvider.forceCachedPsi(psiFile);
        }
        finally {
            DebugUtil.finishPsiModification();
        }
        psiFile.putUserData(FileContextUtil.INJECTED_IN_ELEMENT, pointer);
        PsiDocumentManagerBase.cachePsi(documentWindow, psiFile);
        MultiHostRegistrarImpl.keepTreeFromChameleoningBack(psiFile);
        return viewProvider.setShreds(place, psiFile.getProject());
    }

    @NonNls
    private String exceptionContext(@NonNls String msg) {
        return msg + ".\n" + this.myLanguage + ";\n " + "Host file: " + this.myHostPsiFile + " in '" + this.myHostVirtualFile.getPresentableUrl() + "'" + (PsiDocumentManager.getInstance((Project)this.myProject).isUncommited((Document)this.myHostDocument) ? " (uncommitted)" : "") + "\n" + "Context element " + this.myContextElement.getTextRange() + ": '" + this.myContextElement + "'; " + "Ranges: " + this.shreds;
    }

    private static ASTNode keepTreeFromChameleoningBack(PsiFile psiFile) {
        psiFile.getFirstChild();
        FileASTNode node = psiFile.getNode();
        assert (!TreeUtil.isCollapsedChameleon((ASTNode)node)) : "Chameleon " + node + " is collapsed";
        psiFile.putUserData(TREE_HARD_REF, (Object)node);
        return node;
    }

    private void assertEverythingIsAllright(PsiDocumentManager documentManager, DocumentWindowImpl documentWindow, PsiFile psiFile) {
        boolean isAncestor = false;
        for (PsiLanguageInjectionHost.Shred shred : this.shreds) {
            PsiLanguageInjectionHost host = shred.getHost();
            isAncestor |= PsiTreeUtil.isAncestor((PsiElement)this.myContextElement, (PsiElement)host, (boolean)false);
        }
        assert (isAncestor) : this.exceptionContext(this.myContextElement + " must be the parent of at least one of injection hosts");
        InjectedFileViewProvider injectedFileViewProvider = (InjectedFileViewProvider)psiFile.getViewProvider();
        assert (injectedFileViewProvider.isValid()) : "Invalid view provider: " + injectedFileViewProvider;
        assert (psiFile.textMatches((CharSequence)documentWindow.getText())) : "Document window text mismatch";
        assert (injectedFileViewProvider.getDocument() == documentWindow) : "Provider document mismatch";
        assert (documentManager.getCachedDocument(psiFile) == documentWindow) : "Cached document mismatch";
        assert (Comparing.equal((Object)psiFile.getVirtualFile(), (Object)injectedFileViewProvider.getVirtualFile())) : "Virtual file mismatch: " + psiFile.getVirtualFile() + "; " + injectedFileViewProvider.getVirtualFile();
        PsiDocumentManagerBase.checkConsistency(psiFile, documentWindow);
    }

    void addToResults(Place place, PsiFile psiFile, MultiHostRegistrarImpl from) {
        this.addToResults(place, psiFile);
        this.myReferenceInjector = from.myReferenceInjector;
    }

    private void addToResults(Place place, PsiFile psiFile) {
        if (this.result == null) {
            this.result = new SmartList();
        }
        this.result.add((Pair<Place, PsiFile>)Pair.create((Object)((Object)place), (Object)psiFile));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void patchLeaves(@NotNull ASTNode parsedNode, @NotNull List<LiteralTextEscaper<? extends PsiLanguageInjectionHost>> escapers, @NotNull Place shreds) {
        if (parsedNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parsedNode", "com/intellij/psi/impl/source/tree/injected/MultiHostRegistrarImpl", "patchLeaves"));
        }
        if (escapers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "escapers", "com/intellij/psi/impl/source/tree/injected/MultiHostRegistrarImpl", "patchLeaves"));
        }
        if (shreds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shreds", "com/intellij/psi/impl/source/tree/injected/MultiHostRegistrarImpl", "patchLeaves"));
        }
        LeafPatcher patcher = new LeafPatcher(shreds, escapers);
        ((TreeElement)parsedNode).acceptTree(patcher);
        assert (((TreeElement)parsedNode).textMatches(patcher.catLeafs)) : "Malformed PSI structure: leaf texts do not add up to the whole file text.\nFile text (from tree)  :'" + parsedNode.getText() + "'" + "\nFile text (from PSI)   :'" + parsedNode.getPsi().getText() + "'" + "\nLeaf texts concatenated:'" + patcher.catLeafs + "';" + "\nFile root: " + parsedNode + "\nLanguage: " + parsedNode.getPsi().getLanguage() + "\nHost file: " + shreds.getHostPointer().getVirtualFile();
        DebugUtil.startPsiModification("injection leaf patching");
        try {
            for (Map.Entry<LeafElement, String> entry : patcher.newTexts.entrySet()) {
                LeafElement leaf = entry.getKey();
                String newText = entry.getValue();
                leaf.rawReplaceWithText(newText);
            }
        }
        finally {
            DebugUtil.finishPsiModification();
        }
        TreeUtil.clearCaches((TreeElement)parsedNode);
    }

    private static PsiFile registerDocument(DocumentWindowImpl documentWindow, PsiFile injectedPsi, Place shreds, PsiFile hostPsiFile, PsiDocumentManager documentManager) {
        ConcurrentList<DocumentWindow> injected = InjectedLanguageUtil.getCachedInjectedDocuments(hostPsiFile);
        for (int i = injected.size() - 1; i >= 0; --i) {
            FileViewProvider viewProvider;
            DocumentWindowImpl oldDocument = (DocumentWindowImpl)injected.get(i);
            final PsiFileImpl oldFile = (PsiFileImpl)documentManager.getCachedPsiFile((Document)oldDocument);
            if (oldFile == null || !oldFile.isValid() || !((viewProvider = oldFile.getViewProvider()) instanceof InjectedFileViewProvider) || ((InjectedFileViewProvider)viewProvider).isDisposed()) {
                injected.remove(i);
                Disposer.dispose((Disposable)oldDocument);
                continue;
            }
            InjectedFileViewProvider oldViewProvider = (InjectedFileViewProvider)viewProvider;
            FileASTNode injectedNode = injectedPsi.getNode();
            FileASTNode oldFileNode = oldFile.getNode();
            assert (injectedNode != null) : "New node is null";
            if (!oldDocument.areRangesEqual(documentWindow)) continue;
            if (oldFile.getFileType() != injectedPsi.getFileType() || oldFile.getLanguage() != injectedPsi.getLanguage()) {
                injected.remove(i);
                Disposer.dispose((Disposable)oldDocument);
                continue;
            }
            oldFile.putUserData(FileContextUtil.INJECTED_IN_ELEMENT, injectedPsi.getUserData(FileContextUtil.INJECTED_IN_ELEMENT));
            assert (shreds.isValid());
            if (!oldFile.textMatches((PsiElement)injectedPsi)) {
                oldViewProvider.performNonPhysically(new Runnable((ASTNode)oldFileNode, (ASTNode)injectedNode){
                    final /* synthetic */ ASTNode val$oldFileNode;
                    final /* synthetic */ ASTNode val$injectedNode;
                    {
                        this.val$oldFileNode = aSTNode;
                        this.val$injectedNode = aSTNode2;
                    }

                    @Override
                    public void run() {
                        DebugUtil.startPsiModification("injected tree diff");
                        try {
                            DiffLog diffLog = BlockSupportImpl.mergeTrees(oldFile, this.val$oldFileNode, this.val$injectedNode, new DaemonProgressIndicator(), this.val$oldFileNode.getText());
                            DocumentCommitProcessor.doActualPsiChange(oldFile, diffLog);
                        }
                        finally {
                            DebugUtil.finishPsiModification();
                        }
                    }
                });
            }
            assert (shreds.isValid());
            return oldFile;
        }
        injected.add(documentWindow);
        return injectedPsi;
    }

    private static List<Trinity<IElementType, SmartPsiElementPointer<PsiLanguageInjectionHost>, TextRange>> obtainHighlightTokensFromLexer(Language language, StringBuilder outChars, List<LiteralTextEscaper<? extends PsiLanguageInjectionHost>> escapers, Place shreds, VirtualFileWindow virtualFile, Project project) {
        ArrayList<Trinity<IElementType, SmartPsiElementPointer<PsiLanguageInjectionHost>, TextRange>> tokens = new ArrayList<Trinity<IElementType, SmartPsiElementPointer<PsiLanguageInjectionHost>, TextRange>>(10);
        SyntaxHighlighter syntaxHighlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((Language)language, (Project)project, (VirtualFile)((VirtualFile)virtualFile));
        Lexer lexer = syntaxHighlighter.getHighlightingLexer();
        lexer.start((CharSequence)outChars);
        int hostNum = -1;
        int prevHostEndOffset = 0;
        SmartPsiElementPointer<PsiLanguageInjectionHost> host = null;
        LiteralTextEscaper<? extends PsiLanguageInjectionHost> escaper = null;
        int prefixLength = 0;
        int suffixLength = 0;
        TextRange rangeInsideHost = null;
        int shredEndOffset = -1;
        IElementType tokenType = lexer.getTokenType();
        while (tokenType != null) {
            ProperTextRange range = new ProperTextRange(lexer.getTokenStart(), lexer.getTokenEnd());
            while (range != null && !range.isEmpty()) {
                if (range.getStartOffset() >= shredEndOffset) {
                    PsiLanguageInjectionHost.Shred shred = (PsiLanguageInjectionHost.Shred)shreds.get(++hostNum);
                    shredEndOffset = shred.getRange().getEndOffset();
                    prevHostEndOffset = range.getStartOffset();
                    host = ((ShredImpl)shred).getSmartPointer();
                    escaper = escapers.get(hostNum);
                    rangeInsideHost = shred.getRangeInsideHost();
                    prefixLength = shred.getPrefix().length();
                    suffixLength = shred.getSuffix().length();
                }
                if (range.getStartOffset() < prevHostEndOffset + prefixLength) {
                    range = new UnfairTextRange(prevHostEndOffset + prefixLength, range.getEndOffset());
                }
                UnfairTextRange spilled = null;
                if (range.getEndOffset() > shredEndOffset - suffixLength) {
                    spilled = new UnfairTextRange(shredEndOffset, range.getEndOffset());
                    range = new UnfairTextRange(range.getStartOffset(), shredEndOffset - suffixLength);
                }
                if (!range.isEmpty()) {
                    int end;
                    int start = escaper.getOffsetInHost(range.getStartOffset() - prevHostEndOffset - prefixLength, rangeInsideHost);
                    if (start == -1) {
                        start = rangeInsideHost.getStartOffset();
                    }
                    if ((end = escaper.getOffsetInHost(range.getEndOffset() - prevHostEndOffset - prefixLength, rangeInsideHost)) == -1) {
                        end = rangeInsideHost.getEndOffset();
                        prevHostEndOffset = shredEndOffset;
                    }
                    ProperTextRange rangeInHost = new ProperTextRange(start, end);
                    tokens.add((Trinity<IElementType, SmartPsiElementPointer<PsiLanguageInjectionHost>, TextRange>)Trinity.create((Object)tokenType, host, (Object)rangeInHost));
                }
                range = spilled;
            }
            lexer.advance();
            tokenType = lexer.getTokenType();
        }
        return tokens;
    }

    public long getModificationCount() {
        DocumentEx hostDocument;
        List<PsiLanguageInjectionHost.Shred> shredList = this.shreds;
        if (shredList != null) {
            for (PsiLanguageInjectionHost.Shred shred : shredList) {
                if (shred.isValid()) continue;
                return -1L;
            }
        }
        return (hostDocument = this.myHostDocument) == null ? -1L : hostDocument.getModificationStamp();
    }

    public String toString() {
        return String.valueOf(this.result);
    }

    @NotNull
    PsiFile getHostPsiFile() {
        PsiFile psiFile = this.myHostPsiFile;
        if (psiFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/injected/MultiHostRegistrarImpl", "getHostPsiFile"));
        }
        return psiFile;
    }

    ReferenceInjector getReferenceInjector() {
        return this.myReferenceInjector;
    }

    @NotNull
    public static DocumentWindow freezeWindow(@NotNull DocumentWindowImpl window) {
        if (window == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "window", "com/intellij/psi/impl/source/tree/injected/MultiHostRegistrarImpl", "freezeWindow"));
        }
        Place shreds = window.getShreds();
        Project project = shreds.getHostPointer().getProject();
        DocumentEx delegate = ((PsiDocumentManagerBase)PsiDocumentManager.getInstance((Project)project)).getLastCommittedDocument(window.getDelegate());
        Place place = new Place(ContainerUtil.map((Collection)((Object)shreds), (Function)new Function<PsiLanguageInjectionHost.Shred, PsiLanguageInjectionHost.Shred>(){

            public PsiLanguageInjectionHost.Shred fun(PsiLanguageInjectionHost.Shred shred) {
                return ((ShredImpl)shred).withPsiRange();
            }
        }));
        DocumentWindowImpl documentWindowImpl = new DocumentWindowImpl(delegate, window.isOneLine(), place);
        if (documentWindowImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/injected/MultiHostRegistrarImpl", "freezeWindow"));
        }
        return documentWindowImpl;
    }
}

