/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.changeSignature;

import com.intellij.ide.actions.CopyReferenceAction;
import com.intellij.lang.findUsages.DescriptiveNameUtil;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.changeSignature.ChangeInfo;
import com.intellij.refactoring.changeSignature.ChangeSignatureUsageProcessor;
import com.intellij.refactoring.changeSignature.PossiblyIncorrectUsage;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.listeners.RefactoringEventData;
import com.intellij.refactoring.listeners.UndoRefactoringElementListener;
import com.intellij.refactoring.listeners.impl.RefactoringTransaction;
import com.intellij.refactoring.rename.ResolveSnapshotProvider;
import com.intellij.refactoring.rename.inplace.VariableInplaceRenamer;
import com.intellij.refactoring.util.MoveRenameUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.HashMap;
import com.intellij.util.containers.hash.HashSet;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ChangeSignatureProcessorBase
extends BaseRefactoringProcessor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.changeSignature.ChangeSignatureProcessorBase");
    protected final ChangeInfo myChangeInfo;
    protected final PsiManager myManager;

    protected ChangeSignatureProcessorBase(Project project, ChangeInfo changeInfo) {
        super(project);
        this.myChangeInfo = changeInfo;
        this.myManager = PsiManager.getInstance((Project)project);
    }

    protected ChangeSignatureProcessorBase(Project project, @Nullable Runnable prepareSuccessfulCallback, ChangeInfo changeInfo) {
        super(project, prepareSuccessfulCallback);
        this.myChangeInfo = changeInfo;
        this.myManager = PsiManager.getInstance((Project)project);
    }

    @Override
    @NotNull
    protected UsageInfo[] findUsages() {
        ChangeSignatureUsageProcessor[] processors;
        List<UsageInfo> infos = new ArrayList<UsageInfo>();
        for (ChangeSignatureUsageProcessor processor2 : processors = (ChangeSignatureUsageProcessor[])ChangeSignatureUsageProcessor.EP_NAME.getExtensions()) {
            ContainerUtil.addAll(infos, (Object[])processor2.findUsages(this.myChangeInfo));
        }
        infos = this.filterUsages(infos);
        UsageInfo[] usageInfoArray = infos.toArray(new UsageInfo[infos.size()]);
        if (usageInfoArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/changeSignature/ChangeSignatureProcessorBase", "findUsages"));
        }
        return usageInfoArray;
    }

    protected List<UsageInfo> filterUsages(List<UsageInfo> infos) {
        HashMap moveRenameInfos = new HashMap();
        HashSet usedElements = new HashSet();
        ArrayList<UsageInfo> result2 = new ArrayList<UsageInfo>(infos.size() / 2);
        for (UsageInfo info : infos) {
            LOG.assertTrue(info != null, this.getClass());
            PsiElement element = info.getElement();
            if (info instanceof MoveRenameUsageInfo) {
                if (usedElements.contains(element)) continue;
                moveRenameInfos.put(element, (MoveRenameUsageInfo)info);
                continue;
            }
            moveRenameInfos.remove(element);
            usedElements.add(element);
            if (info instanceof PossiblyIncorrectUsage && !((PossiblyIncorrectUsage)info).isCorrect()) continue;
            result2.add(info);
        }
        result2.addAll(moveRenameInfos.values());
        return result2;
    }

    @Override
    protected boolean isPreviewUsages(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/refactoring/changeSignature/ChangeSignatureProcessorBase", "isPreviewUsages"));
        }
        for (ChangeSignatureUsageProcessor processor2 : (ChangeSignatureUsageProcessor[])ChangeSignatureUsageProcessor.EP_NAME.getExtensions()) {
            if (!processor2.shouldPreviewUsages(this.myChangeInfo, usages)) continue;
            return true;
        }
        return super.isPreviewUsages(usages);
    }

    @Override
    @Nullable
    protected String getRefactoringId() {
        return "refactoring.changeSignature";
    }

    @Override
    @Nullable
    protected RefactoringEventData getBeforeData() {
        RefactoringEventData data = new RefactoringEventData();
        data.addElement(this.getChangeInfo().getMethod());
        return data;
    }

    @Override
    @Nullable
    protected RefactoringEventData getAfterData(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/refactoring/changeSignature/ChangeSignatureProcessorBase", "getAfterData"));
        }
        RefactoringEventData data = new RefactoringEventData();
        data.addElement(this.getChangeInfo().getMethod());
        return data;
    }

    @Override
    protected void performRefactoring(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/refactoring/changeSignature/ChangeSignatureProcessorBase", "performRefactoring"));
        }
        RefactoringTransaction transaction = this.getTransaction();
        final RefactoringElementListener elementListener = transaction == null ? null : transaction.getElementListener(this.myChangeInfo.getMethod());
        final String fqn = CopyReferenceAction.elementToFqn(this.myChangeInfo.getMethod());
        if (fqn != null) {
            BasicUndoableAction action = new BasicUndoableAction(){

                public void undo() {
                    if (elementListener instanceof UndoRefactoringElementListener) {
                        ((UndoRefactoringElementListener)elementListener).undoElementMovedOrRenamed(ChangeSignatureProcessorBase.this.myChangeInfo.getMethod(), fqn);
                    }
                }

                public void redo() {
                }
            };
            UndoManager.getInstance((Project)this.myProject).undoableActionPerformed((UndoableAction)action);
        }
        try {
            ChangeSignatureUsageProcessor[] processors = (ChangeSignatureUsageProcessor[])ChangeSignatureUsageProcessor.EP_NAME.getExtensions();
            ResolveSnapshotProvider resolveSnapshotProvider = this.myChangeInfo.isParameterNamesChanged() ? (ResolveSnapshotProvider)VariableInplaceRenamer.INSTANCE.forLanguage(this.myChangeInfo.getMethod().getLanguage()) : null;
            ArrayList snapshots = new ArrayList();
            for (ChangeSignatureUsageProcessor changeSignatureUsageProcessor : processors) {
                if (resolveSnapshotProvider == null) continue;
                changeSignatureUsageProcessor.registerConflictResolvers(snapshots, resolveSnapshotProvider, usages, this.myChangeInfo);
            }
            for (ChangeSignatureUsageProcessor changeSignatureUsageProcessor : usages) {
                for (ChangeSignatureUsageProcessor processor3 : processors) {
                    if (processor3.processUsage(this.myChangeInfo, (UsageInfo)changeSignatureUsageProcessor, true, usages)) break;
                }
            }
            LOG.assertTrue(this.myChangeInfo.getMethod().isValid());
            for (ChangeSignatureUsageProcessor changeSignatureUsageProcessor : processors) {
                if (changeSignatureUsageProcessor.processPrimaryMethod(this.myChangeInfo)) break;
            }
            for (ChangeSignatureUsageProcessor changeSignatureUsageProcessor : usages) {
                for (ChangeSignatureUsageProcessor processor2 : processors) {
                    if (processor2.processUsage(this.myChangeInfo, (UsageInfo)changeSignatureUsageProcessor, false, usages)) break;
                }
            }
            if (!snapshots.isEmpty()) {
                for (ChangeSignatureUsageProcessor changeSignatureUsageProcessor : this.myChangeInfo.getNewParameters()) {
                    for (ResolveSnapshotProvider.ResolveSnapshot snapshot : snapshots) {
                        snapshot.apply(changeSignatureUsageProcessor.getName());
                    }
                }
            }
            PsiElement method = this.myChangeInfo.getMethod();
            LOG.assertTrue(method.isValid());
            if (elementListener != null && this.myChangeInfo.isNameChanged()) {
                elementListener.elementRenamed(method);
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    @Override
    protected String getCommandName() {
        return RefactoringBundle.message((String)"changing.signature.of.0", (Object[])new Object[]{DescriptiveNameUtil.getDescriptiveName((PsiElement)this.myChangeInfo.getMethod())});
    }

    public ChangeInfo getChangeInfo() {
        return this.myChangeInfo;
    }
}

