/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations;

import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.openapi.extensions.Extensions;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class ConfigurationTypeUtil {
    private ConfigurationTypeUtil() {
    }

    @NotNull
    public static <T extends ConfigurationType> T findConfigurationType(@NotNull Class<T> configurationTypeClass) {
        Object[] types;
        if (configurationTypeClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurationTypeClass", "com/intellij/execution/configurations/ConfigurationTypeUtil", "findConfigurationType"));
        }
        for (ConfigurationType configurationType : types = (ConfigurationType[])Extensions.getExtensions(ConfigurationType.CONFIGURATION_TYPE_EP)) {
            if (!configurationTypeClass.isInstance(configurationType)) continue;
            ConfigurationType configurationType2 = configurationType;
            if (configurationType2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/configurations/ConfigurationTypeUtil", "findConfigurationType"));
            }
            return (T)configurationType2;
        }
        throw new AssertionError((Object)(Arrays.toString(types) + " loader: " + configurationTypeClass.getClassLoader() + ", " + configurationTypeClass));
    }

    public static boolean equals(@NotNull ConfigurationType type1, @NotNull ConfigurationType type2) {
        if (type1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type1", "com/intellij/execution/configurations/ConfigurationTypeUtil", "equals"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type2", "com/intellij/execution/configurations/ConfigurationTypeUtil", "equals"));
        }
        return type1.getId().equals(type2.getId());
    }

    public static ConfigurationType findConfigurationType(String configurationId) {
        ConfigurationType[] types;
        for (ConfigurationType type : types = (ConfigurationType[])Extensions.getExtensions(ConfigurationType.CONFIGURATION_TYPE_EP)) {
            if (!type.getId().equals(configurationId)) continue;
            return type;
        }
        return null;
    }
}

