/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.graphInference.constraints;

import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLambdaParameterType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceVariable;
import com.intellij.psi.impl.source.resolve.graphInference.PsiPolyExpressionUtil;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.ConstraintFormula;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.InputOutputConstraintFormula;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.LambdaExpressionCompatibilityConstraint;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.PsiMethodReferenceCompatibilityConstraint;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.TypeCompatibilityConstraint;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.util.TypeConversionUtil;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ExpressionCompatibilityConstraint
extends InputOutputConstraintFormula {
    private final PsiExpression myExpression;
    private PsiType myT;

    public ExpressionCompatibilityConstraint(@NotNull PsiExpression expression, @NotNull PsiType type2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/psi/impl/source/resolve/graphInference/constraints/ExpressionCompatibilityConstraint", "<init>"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/impl/source/resolve/graphInference/constraints/ExpressionCompatibilityConstraint", "<init>"));
        }
        this.myExpression = expression;
        this.myT = type2;
    }

    @Override
    public boolean reduce(InferenceSession session, List<ConstraintFormula> constraints) {
        PsiExpression expression;
        if (!PsiPolyExpressionUtil.isPolyExpression(this.myExpression)) {
            if (session.isProperType(this.myT)) {
                return TypeConversionUtil.areTypesAssignmentCompatible(this.myT, this.myExpression);
            }
            PsiType exprType = this.myExpression.getType();
            if (exprType instanceof PsiLambdaParameterType) {
                return false;
            }
            if (exprType instanceof PsiClassType && ((PsiClassType)exprType).resolve() == null) {
                return true;
            }
            if (exprType != null && exprType != PsiType.NULL) {
                constraints.add(new TypeCompatibilityConstraint(this.myT, exprType));
            }
            return true;
        }
        if (this.myExpression instanceof PsiParenthesizedExpression && (expression = ((PsiParenthesizedExpression)this.myExpression).getExpression()) != null) {
            constraints.add(new ExpressionCompatibilityConstraint(expression, this.myT));
            return true;
        }
        if (this.myExpression instanceof PsiConditionalExpression) {
            PsiExpression elseExpression;
            PsiExpression thenExpression = ((PsiConditionalExpression)this.myExpression).getThenExpression();
            if (thenExpression != null) {
                constraints.add(new ExpressionCompatibilityConstraint(thenExpression, this.myT));
            }
            if ((elseExpression = ((PsiConditionalExpression)this.myExpression).getElseExpression()) != null) {
                constraints.add(new ExpressionCompatibilityConstraint(elseExpression, this.myT));
            }
            return true;
        }
        if (this.myExpression instanceof PsiCall) {
            PsiExpressionList argumentList2 = ((PsiCall)((Object)this.myExpression)).getArgumentList();
            if (argumentList2 != null) {
                MethodCandidateInfo.CurrentCandidateProperties candidateProperties = MethodCandidateInfo.getCurrentMethod(((PsiCall)((Object)this.myExpression)).getArgumentList());
                PsiType returnType2 = null;
                PsiTypeParameter[] typeParams = null;
                JavaResolveResult resolveResult = candidateProperties != null ? null : InferenceSession.getResolveResult((PsiCall)((Object)this.myExpression), argumentList2);
                PsiMethod method = null;
                if (candidateProperties != null) {
                    method = candidateProperties.getMethod();
                } else {
                    PsiElement element = resolveResult.getElement();
                    if (element instanceof PsiMethod) {
                        method = (PsiMethod)element;
                    }
                }
                if (method != null && !method.isConstructor()) {
                    returnType2 = method.getReturnType();
                    if (returnType2 != null) {
                        typeParams = method.getTypeParameters();
                    }
                } else if (resolveResult != null) {
                    PsiClass psiClass;
                    PsiClass psiClass2 = psiClass = method != null ? method.getContainingClass() : (PsiClass)resolveResult.getElement();
                    if (psiClass != null) {
                        returnType2 = JavaPsiFacade.getElementFactory(argumentList2.getProject()).createType(psiClass, PsiSubstitutor.EMPTY);
                        typeParams = psiClass.getTypeParameters();
                    }
                }
                if (typeParams != null) {
                    boolean accepted;
                    PsiSubstitutor siteSubstitutor = InferenceSession.chooseSiteSubstitutor(candidateProperties, resolveResult, method);
                    InferenceSession callSession = new InferenceSession(typeParams, siteSubstitutor, this.myExpression.getManager(), this.myExpression);
                    callSession.propagateVariables(session.getInferenceVariables());
                    if (method != null) {
                        PsiExpression[] args = argumentList2.getExpressions();
                        PsiParameter[] parameters2 = method.getParameterList().getParameters();
                        callSession.initExpressionConstraints(parameters2, args, this.myExpression, method, InferenceSession.chooseVarargsMode(candidateProperties, resolveResult));
                    }
                    if (!(accepted = callSession.repeatInferencePhases(true))) {
                        return false;
                    }
                    callSession.registerReturnTypeConstraints(siteSubstitutor.substitute(returnType2), this.myT);
                    if (callSession.repeatInferencePhases(true)) {
                        session.registerNestedSession(callSession);
                    } else {
                        return false;
                    }
                }
            }
            return true;
        }
        if (this.myExpression instanceof PsiMethodReferenceExpression) {
            constraints.add(new PsiMethodReferenceCompatibilityConstraint((PsiMethodReferenceExpression)this.myExpression, this.myT));
            return true;
        }
        if (this.myExpression instanceof PsiLambdaExpression) {
            constraints.add(new LambdaExpressionCompatibilityConstraint((PsiLambdaExpression)this.myExpression, this.myT));
            return true;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExpressionCompatibilityConstraint that = (ExpressionCompatibilityConstraint)o;
        return this.myExpression.equals(that.myExpression);
    }

    public int hashCode() {
        return this.myExpression.hashCode();
    }

    @Override
    public PsiExpression getExpression() {
        return this.myExpression;
    }

    @Override
    public PsiType getT() {
        return this.myT;
    }

    @Override
    protected void setT(PsiType t) {
        this.myT = t;
    }

    @Override
    protected InputOutputConstraintFormula createSelfConstraint(PsiType type2, PsiExpression expression) {
        return new ExpressionCompatibilityConstraint(expression, type2);
    }

    @Override
    protected void collectReturnTypeVariables(InferenceSession session, PsiExpression psiExpression, PsiType returnType2, Set<InferenceVariable> result2) {
        if (psiExpression instanceof PsiLambdaExpression && returnType2 != PsiType.VOID) {
            List<PsiExpression> returnExpressions = LambdaUtil.getReturnExpressions((PsiLambdaExpression)psiExpression);
            for (PsiExpression expression : returnExpressions) {
                Set<InferenceVariable> resultInputVars = this.createSelfConstraint(returnType2, expression).getInputVariables(session);
                if (resultInputVars == null) continue;
                result2.addAll(resultInputVars);
            }
        }
    }
}

