/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls;

import com.intellij.lang.ASTNode;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"+\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0001!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0019\u0005)\u0011\u0001\"\u0002\u0006\u00031\tQ!\u0001C\u0002\u000b\u0005AY!B\u0001\u0005\u0007\u0011\u0001E\u0001\u0004\u0001\u001a\u0003a\u0005\u0011UB\u0005\u0004\u0011\u0005i\u0011\u0001g\u0001R\u0007\u0005A!!*\u0003\u0005\u0007\u001eA)\"D\u0001\u0019\u0004\u0015NAaQ\u0002\t\u00175\t\u0001\u0004A\r\u0005\t\u0005A\u0011!D\u0001\u0019\u0004%RAa\u0011\u0005\t\u00065\t\u0001d\u0001\u000f$#\u000e\u0019QB\u0001C\u0004\u0011\u0011I#\u0002B\"\t\u0011\u0005i\u0011\u0001g\u0001R\u0007\u0011)\u0001!\u0004\u0002\u0005\n!)\u0011F\u0003\u0003D\u0011!-Q\"\u0001\r\u00079\r\n6aA\u0007\u0003\t\u001bAq!\u000b\u0006\u0005\u0007\"Ay!D\u0001\u0019\u0011q\u0019\u0013kA\u0002\u000e\u0005\u0011E\u0001\"C\u0015\f\t\rC\u00012C\u0007\u0003\u0019\u0003Ab\u0001H\u0012R\u0007\ri!\u0001\u0002\u0006\t\u000f\u0001"}, strings={"Lorg/jetbrains/kotlin/resolve/calls/CallExpressionElement;", "", "qualified", "Lorg/jetbrains/kotlin/psi/KtQualifiedExpression;", "(Lorg/jetbrains/kotlin/psi/KtQualifiedExpression;)V", "node", "Lcom/intellij/lang/ASTNode;", "getNode", "()Lcom/intellij/lang/ASTNode;", "getQualified", "()Lorg/jetbrains/kotlin/psi/KtQualifiedExpression;", "receiver", "Lorg/jetbrains/kotlin/psi/KtExpression;", "getReceiver", "()Lorg/jetbrains/kotlin/psi/KtExpression;", "safe", "", "getSafe", "()Z", "selector", "getSelector", "component1", "copy"}, moduleName="kotlin-compiler")
public final class CallExpressionElement {
    @NotNull
    private final KtQualifiedExpression qualified;

    @NotNull
    public final KtExpression getReceiver() {
        KtExpression ktExpression = this.qualified.getReceiverExpression();
        Intrinsics.checkExpressionValueIsNotNull(ktExpression, "qualified.receiverExpression");
        return ktExpression;
    }

    @Nullable
    public final KtExpression getSelector() {
        return this.qualified.getSelectorExpression();
    }

    public final boolean getSafe() {
        return Intrinsics.areEqual(this.qualified.getOperationSign(), KtTokens.SAFE_ACCESS);
    }

    @NotNull
    public final ASTNode getNode() {
        ASTNode aSTNode = this.qualified.getOperationTokenNode();
        Intrinsics.checkExpressionValueIsNotNull(aSTNode, "qualified.operationTokenNode");
        return aSTNode;
    }

    @NotNull
    public final KtQualifiedExpression getQualified() {
        return this.qualified;
    }

    public CallExpressionElement(@NotNull KtQualifiedExpression qualified) {
        Intrinsics.checkParameterIsNotNull(qualified, "qualified");
        this.qualified = qualified;
    }

    @NotNull
    public final KtQualifiedExpression component1() {
        return this.qualified;
    }

    @NotNull
    public final CallExpressionElement copy(@NotNull KtQualifiedExpression qualified) {
        Intrinsics.checkParameterIsNotNull(qualified, "qualified");
        return new CallExpressionElement(qualified);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ CallExpressionElement copy$default(CallExpressionElement callExpressionElement, KtQualifiedExpression ktQualifiedExpression, int n) {
        if ((n & 1) != 0) {
            ktQualifiedExpression = callExpressionElement.qualified;
        }
        return callExpressionElement.copy(ktQualifiedExpression);
    }

    public String toString() {
        return "CallExpressionElement(qualified=" + this.qualified + ")";
    }

    public int hashCode() {
        KtQualifiedExpression ktQualifiedExpression = this.qualified;
        return ktQualifiedExpression != null ? ktQualifiedExpression.hashCode() : 0;
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof CallExpressionElement)) break block3;
                CallExpressionElement callExpressionElement = (CallExpressionElement)object;
                if (!Intrinsics.areEqual(this.qualified, callExpressionElement.qualified)) break block3;
            }
            return true;
        }
        return false;
    }
}

