/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import com.intellij.psi.PsiElement;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCallImpl;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"#\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u0003!\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u0019\u0001I\u0012\u0001'\u0001\"\u0006E\u001b\u0011\u0001C\u0001&)\u0011Y\u00012A\u0007\u00021\t\tB\u0001\u0002\u0001\t\u0006U\t\u0001dA\r\u0007\u0011\u000fiA!\u0003\u0002\n\u0003\u0011\u0016\u0001\u0004B\r\u0004\u0011\u0013i\u0011\u0001G\u0003"}, strings={"Lorg/jetbrains/kotlin/resolve/calls/checkers/InvokeConventionChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "F", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "context", "Lorg/jetbrains/kotlin/resolve/calls/context/BasicCallResolutionContext;"}, moduleName="kotlin-compiler")
public final class InvokeConventionChecker
implements CallChecker {
    @Override
    public <F extends CallableDescriptor> void check(@NotNull ResolvedCall<F> resolvedCall, @NotNull BasicCallResolutionContext context) {
        Intrinsics.checkParameterIsNotNull(resolvedCall, "resolvedCall");
        Intrinsics.checkParameterIsNotNull(context, "context");
        if (resolvedCall instanceof VariableAsFunctionResolvedCallImpl) {
            ResolvedCall functionCall = ((VariableAsFunctionResolvedCallImpl)resolvedCall).getFunctionCall();
            ResolvedCall variableCall = ((VariableAsFunctionResolvedCallImpl)resolvedCall).getVariableCall();
            if (functionCall.getDispatchReceiver().exists() && functionCall.getExtensionReceiver().exists() && KotlinBuiltIns.isExactExtensionFunctionType(((VariableDescriptor)variableCall.getResultingDescriptor()).getType()) && (variableCall.getDispatchReceiver() instanceof ExpressionReceiver || variableCall.getExtensionReceiver() instanceof ExpressionReceiver)) {
                KtElement callElement = variableCall.getCall().getCallElement();
                context.trace.report(Errors.INVOKE_ON_EXTENSION_FUNCTION_WITH_EXPLICIT_DISPATCH_RECEIVER.on((KtElement)((PsiElement)callElement)));
            }
        }
    }
}

