/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.lazy.data;

import com.intellij.extapi.psi.ASTDelegatePsiElement;
import com.intellij.extapi.psi.StubBasedPsiElementBase;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtModifierListOwnerStub;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwnerStub;
import org.jetbrains.kotlin.resolve.lazy.data.JetClassLikeInfo;

public abstract class JetClassOrObjectInfo<E extends KtClassOrObject>
implements JetClassLikeInfo {
    protected final E element;

    protected JetClassOrObjectInfo(@NotNull E element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/resolve/lazy/data/JetClassOrObjectInfo", "<init>"));
        }
        this.element = element;
    }

    @Nullable
    public Name getName() {
        return ((KtTypeParameterListOwnerStub)this.element).getNameAsName();
    }

    @Override
    public KtClassOrObject getCorrespondingClassOrObject() {
        return this.element;
    }

    @Override
    @Nullable
    public KtModifierList getModifierList() {
        return ((KtModifierListOwnerStub)this.element).getModifierList();
    }

    @Override
    @NotNull
    public List<KtDeclaration> getDeclarations() {
        List<KtDeclaration> list = ((KtClassOrObject)this.element).getDeclarations();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/data/JetClassOrObjectInfo", "getDeclarations"));
        }
        return list;
    }

    @Override
    @NotNull
    public List<KtObjectDeclaration> getCompanionObjects() {
        KtClassBody body = ((KtClassOrObject)this.element).getBody();
        if (body == null) {
            List<KtObjectDeclaration> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/data/JetClassOrObjectInfo", "getCompanionObjects"));
            }
            return list;
        }
        List<KtObjectDeclaration> list = body.getAllCompanionObjects();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/data/JetClassOrObjectInfo", "getCompanionObjects"));
        }
        return list;
    }

    @Override
    @NotNull
    public PsiElement getScopeAnchor() {
        E e = this.element;
        if (e == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/data/JetClassOrObjectInfo", "getScopeAnchor"));
        }
        return e;
    }

    @Override
    @NotNull
    public FqName getContainingPackageFqName() {
        PsiFile file = ((StubBasedPsiElementBase)this.element).getContainingFile();
        if (file instanceof KtFile) {
            KtFile jetFile = (KtFile)file;
            FqName fqName2 = jetFile.getPackageFqName();
            if (fqName2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/data/JetClassOrObjectInfo", "getContainingPackageFqName"));
            }
            return fqName2;
        }
        throw new IllegalArgumentException("Not in a JetFile: " + this.element);
    }

    @Override
    @NotNull
    public List<KtAnnotationEntry> getDanglingAnnotations() {
        KtClassBody body = ((KtClassOrObject)this.element).getBody();
        List<Object> list = body == null ? Collections.emptyList() : body.getDanglingAnnotations();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/data/JetClassOrObjectInfo", "getDanglingAnnotations"));
        }
        return list;
    }

    @Override
    @NotNull
    public List<? extends KtParameter> getPrimaryConstructorParameters() {
        List<KtParameter> list = ((KtClassOrObject)this.element).getPrimaryConstructorParameters();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/data/JetClassOrObjectInfo", "getPrimaryConstructorParameters"));
        }
        return list;
    }

    public String toString() {
        return "info for " + ((ASTDelegatePsiElement)this.element).getText();
    }
}

