/*
 * Decompiled with CFR 0.152.
 */
package com.android.assetstudiolib.vectordrawable;

import com.android.assetstudiolib.vectordrawable.VdElement;
import com.android.assetstudiolib.vectordrawable.VdNodeRender;
import java.awt.geom.Path2D;
import java.util.Arrays;

class VdPath
extends VdElement {
    Node[] mNode = null;
    int mStrokeColor = 0;
    int mFillColor = 0;
    float mStrokeWidth = 0.0f;
    float mRotate = 0.0f;
    float mShiftX = 0.0f;
    float mShiftY = 0.0f;
    float mRotateX = 0.0f;
    float mRotateY = 0.0f;
    float trimPathStart = 0.0f;
    float trimPathEnd = 1.0f;
    float trimPathOffset = 0.0f;
    int mStrokeLineCap = -1;
    int mStrokeLineJoin = -1;
    float mStrokeMiterlimit = -1.0f;
    boolean mClip = false;
    float mStrokeOpacity = Float.NaN;
    float mFillOpacity = Float.NaN;
    float mTrimPathStart = 0.0f;
    float mTrimPathEnd = 1.0f;
    float mTrimPathOffset = 0.0f;

    public void toPath(Path2D path) {
        path.reset();
        if (this.mNode != null) {
            VdNodeRender.creatPath(this.mNode, path);
        }
    }

    public VdPath() {
        this.mName = this.toString();
    }

    public void transform(float a, float b, float c, float d, float e, float f) {
        this.mStrokeWidth = (float)((double)this.mStrokeWidth * Math.hypot(a + b, c + d));
        Node.transform(a, b, c, d, e, f, this.mNode);
    }

    public static class Node {
        char type;
        float[] params;

        public Node(char type, float[] params) {
            this.type = type;
            this.params = params;
        }

        public Node(Node n) {
            this.type = n.type;
            this.params = Arrays.copyOf(n.params, n.params.length);
        }

        public static String NodeListToString(Node[] nodes) {
            String s = "";
            for (int i = 0; i < nodes.length; ++i) {
                Node n = nodes[i];
                s = s + n.type;
                int len = n.params.length;
                for (int j = 0; j < len; ++j) {
                    float value;
                    if (j > 0) {
                        s = s + ((j & 1) == 1 ? "," : " ");
                    }
                    s = (value = n.params[j]) == (float)((long)value) ? s + String.valueOf((long)value) : s + String.valueOf(value);
                }
            }
            return s;
        }

        public static void transform(float a, float b, float c, float d, float e, float f, Node[] nodes) {
            float[] pre = new float[2];
            for (int i = 0; i < nodes.length; ++i) {
                nodes[i].transform(a, b, c, d, e, f, pre);
            }
        }

        public void transform(float a, float b, float c, float d, float e, float f, float[] pre) {
            int incr = 0;
            switch (this.type) {
                case 'Z': 
                case 'z': {
                    return;
                }
                case 'L': 
                case 'M': 
                case 'T': {
                    incr = 2;
                    pre[0] = this.params[this.params.length - 2];
                    pre[1] = this.params[this.params.length - 1];
                    for (int i = 0; i < this.params.length; i += incr) {
                        this.matrix(a, b, c, d, e, f, i, i + 1);
                    }
                    break;
                }
                case 'l': 
                case 'm': 
                case 't': {
                    incr = 2;
                    pre[0] = pre[0] + this.params[this.params.length - 2];
                    pre[1] = pre[1] + this.params[this.params.length - 1];
                    for (int i = 0; i < this.params.length; i += incr) {
                        this.matrix(a, b, c, d, 0.0f, 0.0f, i, i + 1);
                    }
                    break;
                }
                case 'h': {
                    this.type = (char)108;
                    pre[0] = pre[0] + this.params[this.params.length - 1];
                    float[] tempParams = new float[this.params.length * 2];
                    float[] origParams = this.params;
                    this.params = tempParams;
                    for (int i = 0; i < this.params.length; i += 2) {
                        this.params[i] = origParams[i / 2];
                        this.params[i + 1] = 0.0f;
                        this.matrix(a, b, c, d, 0.0f, 0.0f, i, i + 1);
                    }
                    break;
                }
                case 'H': {
                    this.type = (char)76;
                    pre[0] = this.params[this.params.length - 1];
                    float[] tempParams = new float[this.params.length * 2];
                    float[] origParams = this.params;
                    this.params = tempParams;
                    for (int i = 0; i < this.params.length; i += 2) {
                        this.params[i] = origParams[i / 2];
                        this.params[i + 1] = pre[1];
                        this.matrix(a, b, c, d, e, f, i, i + 1);
                    }
                    break;
                }
                case 'v': {
                    pre[1] = pre[1] + this.params[this.params.length - 1];
                    this.type = (char)108;
                    float[] tempParams = new float[this.params.length * 2];
                    float[] origParams = this.params;
                    this.params = tempParams;
                    for (int i = 0; i < this.params.length; i += 2) {
                        this.params[i] = 0.0f;
                        this.params[i + 1] = origParams[i / 2];
                        this.matrix(a, b, c, d, 0.0f, 0.0f, i, i + 1);
                    }
                    break;
                }
                case 'V': {
                    this.type = (char)76;
                    pre[1] = this.params[this.params.length - 1];
                    float[] tempParams = new float[this.params.length * 2];
                    float[] origParams = this.params;
                    this.params = tempParams;
                    for (int i = 0; i < this.params.length; i += 2) {
                        this.params[i] = pre[0];
                        this.params[i + 1] = origParams[i / 2];
                        this.matrix(a, b, c, d, e, f, i, i + 1);
                    }
                    break;
                }
                case 'C': 
                case 'Q': 
                case 'S': {
                    pre[0] = this.params[this.params.length - 2];
                    pre[1] = this.params[this.params.length - 1];
                    for (int i = 0; i < this.params.length; i += 2) {
                        this.matrix(a, b, c, d, e, f, i, i + 1);
                    }
                    break;
                }
                case 'c': 
                case 'q': 
                case 's': {
                    pre[0] = pre[0] + this.params[this.params.length - 2];
                    pre[1] = pre[1] + this.params[this.params.length - 1];
                    for (int i = 0; i < this.params.length; i += 2) {
                        this.matrix(a, b, c, d, 0.0f, 0.0f, i, i + 1);
                    }
                    break;
                }
                case 'a': {
                    incr = 7;
                    pre[0] = pre[0] + this.params[this.params.length - 2];
                    pre[1] = pre[1] + this.params[this.params.length - 1];
                    for (int i = 0; i < this.params.length; i += incr) {
                        this.matrix(a, b, c, d, 0.0f, 0.0f, i, i + 1);
                        double ang = Math.toRadians(this.params[i + 2]);
                        this.params[i + 2] = (float)Math.toDegrees(ang + Math.atan2(b, d));
                        this.matrix(a, b, c, d, 0.0f, 0.0f, i + 5, i + 6);
                    }
                    break;
                }
                case 'A': {
                    incr = 7;
                    pre[0] = this.params[this.params.length - 2];
                    pre[1] = this.params[this.params.length - 1];
                    for (int i = 0; i < this.params.length; i += incr) {
                        this.matrix(a, b, c, d, e, f, i, i + 1);
                        double ang = Math.toRadians(this.params[i + 2]);
                        this.params[i + 2] = (float)Math.toDegrees(ang + Math.atan2(b, d));
                        this.matrix(a, b, c, d, e, f, i + 5, i + 6);
                    }
                    break;
                }
            }
        }

        void matrix(float a, float b, float c, float d, float e, float f, int offx, int offy) {
            float inx = offx < 0 ? 1.0f : this.params[offx];
            float iny = offy < 0 ? 1.0f : this.params[offy];
            float x = inx * a + iny * c + e;
            float y = inx * b + iny * d + f;
            if (offx >= 0) {
                this.params[offx] = x;
            }
            if (offy >= 0) {
                this.params[offy] = y;
            }
        }
    }
}

