/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.lighthouse;

import com.intellij.openapi.project.Project;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.TaskRepositoryType;
import com.intellij.tasks.TaskState;
import com.intellij.tasks.config.TaskRepositoryEditor;
import com.intellij.tasks.impl.BaseRepositoryType;
import com.intellij.tasks.lighthouse.LighthouseRepository;
import com.intellij.tasks.lighthouse.LighthouseRepositoryEditor;
import com.intellij.util.Consumer;
import icons.TasksIcons;
import java.util.EnumSet;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class LighthouseRepositoryType
extends BaseRepositoryType<LighthouseRepository> {
    @NotNull
    public String getName() {
        if ("Lighthouse" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/lighthouse/LighthouseRepositoryType", "getName"));
        }
        return "Lighthouse";
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = TasksIcons.Lighthouse;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/lighthouse/LighthouseRepositoryType", "getIcon"));
        }
        return icon;
    }

    @NotNull
    public TaskRepository createRepository() {
        LighthouseRepository lighthouseRepository = new LighthouseRepository((TaskRepositoryType)this);
        if (lighthouseRepository == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/lighthouse/LighthouseRepositoryType", "createRepository"));
        }
        return lighthouseRepository;
    }

    public Class<LighthouseRepository> getRepositoryClass() {
        return LighthouseRepository.class;
    }

    public EnumSet<TaskState> getPossibleTaskStates() {
        return EnumSet.of(TaskState.SUBMITTED, TaskState.OPEN, TaskState.RESOLVED, TaskState.OTHER);
    }

    @NotNull
    public TaskRepositoryEditor createEditor(LighthouseRepository repository, Project project, Consumer<LighthouseRepository> changeListener) {
        LighthouseRepositoryEditor lighthouseRepositoryEditor = new LighthouseRepositoryEditor(project, repository, changeListener);
        if (lighthouseRepositoryEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/lighthouse/LighthouseRepositoryType", "createEditor"));
        }
        return lighthouseRepositoryEditor;
    }
}

