/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.flavours.gfm.table;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.CharIterator;
import kotlin.CollectionsKt;
import kotlin.StringsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.text.Regex;
import org.intellij.markdown.flavours.gfm.table.GitHubTableMarkerBlock;
import org.intellij.markdown.parser.LookaheadText;
import org.intellij.markdown.parser.MarkerProcessor;
import org.intellij.markdown.parser.ProductionHolder;
import org.intellij.markdown.parser.constraints.MarkdownConstraints;
import org.intellij.markdown.parser.markerblocks.MarkerBlock;
import org.intellij.markdown.parser.markerblocks.MarkerBlockProvider;
import org.jetbrains.annotations.NotNull;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"?\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001\u0005\u0011\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001E\u0007\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\t\u00012B\u0003\u0001\u0019\u0001\u0001\u001a\"\u0007\u0003\n\u0005%\t\u0001$\u0001M\u0001;\u0003M\u0011UA)\u0004\u0003!\rQ%\u0006\u0003\f\u0011\tiA!\u0003\u0002\n\u0003a\u0019\u0001TA\r\u0006\u0011\u000fi1\u0001\u0007\u0003*\u0003a%\u0011d\u0001\u0005\u0006\u001b\u0005AZ!G\u0002\t\r5\t\u0001$A\u0013\u0010\t\u0005Ai!\u0004\u0002\r\u0002a9\u0011$\u0002E\u0004\u001b\rAB!K\u0001\u0019\ne\u0019\u0001rB\u0007\u00021!)c\u0002B\u0006\t\u00125\t\u0001$C\r\u0006\u0011\u000fi1\u0001\u0007\u0003*\u0003a%\u0011d\u0001E\b\u001b\u0005A\u0002\u0002"}, strings={"Lorg/intellij/markdown/flavours/gfm/table/GitHubTableMarkerProvider;", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlockProvider;", "Lorg/intellij/markdown/parser/MarkerProcessor$StateInfo;", "()V", "createMarkerBlocks", "", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlock;", "pos", "Lorg/intellij/markdown/parser/LookaheadText$Position;", "Lorg/intellij/markdown/parser/LookaheadText;", "productionHolder", "Lorg/intellij/markdown/parser/ProductionHolder;", "stateInfo", "getNextLineFromConstraints", "", "constraints", "Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;", "interruptsParagraph", "", "Companion"}, moduleName="intellij-markdown")
public final class GitHubTableMarkerProvider
implements MarkerBlockProvider<MarkerProcessor.StateInfo> {
    @NotNull
    public static final Regex SPLIT_REGEX;
    public static final Companion Companion;

    static {
        Companion = org.intellij.markdown.flavours.gfm.table.GitHubTableMarkerProvider$Companion.INSTANCE;
        SPLIT_REGEX = new Regex("\\|");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<MarkerBlock> createMarkerBlocks(@NotNull LookaheadText.Position pos, @NotNull ProductionHolder productionHolder, @NotNull MarkerProcessor.StateInfo stateInfo) {
        Boolean bl;
        Iterator destination;
        void $receiver;
        Object $receiver2;
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)productionHolder, (String)"productionHolder");
        Intrinsics.checkParameterIsNotNull((Object)stateInfo, (String)"stateInfo");
        MarkdownConstraints currentConstraints = stateInfo.getCurrentConstraints();
        if (Intrinsics.areEqual((Object)stateInfo.getNextConstraints(), (Object)currentConstraints) ^ true) {
            return CollectionsKt.emptyList();
        }
        CharSequence currentLineFromPosition = pos.getCurrentLineFromPosition();
        if (!Companion.contains(currentLineFromPosition, '|')) {
            return CollectionsKt.emptyList();
        }
        List split = Regex.split$default((Regex)Companion.getSPLIT_REGEX(), (CharSequence)currentLineFromPosition, (int)0, (int)2);
        Iterable iterable = split;
        void var9_8 = $receiver2;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver2, (int)10));
        int index = 0;
        for (Object item : $receiver) {
            void s;
            void i;
            int n = index++;
            String string = (String)item;
            int n2 = n;
            void var19_19 = destination;
            Boolean bl2 = i > false && i < CollectionsKt.getLastIndex((List)split) || StringsKt.isNotBlank((CharSequence)((CharSequence)s));
            var19_19.add(bl2);
        }
        $receiver2 = (List)((Object)destination);
        int count = 0;
        destination = $receiver2.iterator();
        while (destination.hasNext()) {
            Object element = destination.next();
            boolean it = (Boolean)element;
            if (!it) continue;
            ++count;
        }
        int numberOfHeaderCells = count;
        CharSequence charSequence = this.getNextLineFromConstraints(pos, currentConstraints);
        if (charSequence != null) {
            $receiver2 = charSequence;
            CharSequence it = (CharSequence)$receiver2;
            bl = Companion.countSecondLineCells(it) == numberOfHeaderCells;
        } else {
            bl = null;
        }
        if (Intrinsics.areEqual(bl, (Object)true)) {
            return CollectionsKt.listOf((Object)new GitHubTableMarkerBlock(pos, currentConstraints, productionHolder, numberOfHeaderCells));
        }
        return CollectionsKt.emptyList();
    }

    @Override
    public boolean interruptsParagraph(@NotNull LookaheadText.Position pos, @NotNull MarkdownConstraints constraints) {
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)constraints, (String)"constraints");
        return false;
    }

    private final CharSequence getNextLineFromConstraints(LookaheadText.Position pos, MarkdownConstraints constraints) {
        String string = pos.getNextLine();
        if (string == null) {
            return null;
        }
        String line = string;
        MarkdownConstraints nextLineConstraints = MarkdownConstraints.Companion.fillFromPrevious(line, 0, constraints);
        if (nextLineConstraints.extendsPrev(constraints)) {
            return nextLineConstraints.eatItselfFromString(line);
        }
        return null;
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"-\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u00031\tQ!\u0001C\u0002\u000b\u0005AA!\u0002\u0001\u0006\u0003!5Q!\u0001C\u0002\u000b\u0005AY!\u0002\u0001\u0006\u0003!1Aaq\u0001\r\u0001e\t\u0001\u0014AQ\u0004\t\u0005\t6!\u0001\u0005\u0002K\u001dA9!D\u0001\u0019\te\u0019\u0001\u0012B\u0007\u00021\u0015)3\u0002c\u0003\u000e\u0003a!\u0011d\u0001E\u0005\u001b\u0005AR!G\u0002\t\r5\t\u0001\u0004BS\u000b\u0011\u001bi\u0011\u0001G\u0004\u0016\u0003a)\u0011\u0014\u0002E\b\u001b\u0005A\u0002\u0002UB\u0001S-!1\t\u0003E\u0002\u001b\u0005A\"!U\u0002\u0006\u000b\u0005a\t!\u0004\u0002\u0005\u0006!\u0019\u0001"}, strings={"Lorg/intellij/markdown/flavours/gfm/table/GitHubTableMarkerProvider$Companion;", "", "()V", "SPLIT_REGEX", "Lkotlin/text/Regex;", "getSPLIT_REGEX", "()Lkotlin/text/Regex;", "countSecondLineCells", "", "line", "", "passWhiteSpaces", "offset", "contains", "", "char", ""}, moduleName="intellij-markdown")
    public static final class Companion {
        public static final Companion INSTANCE;

        @NotNull
        public final Regex getSPLIT_REGEX() {
            return SPLIT_REGEX;
        }

        public final boolean contains(CharSequence $receiver, char c) {
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            CharIterator charIterator = StringsKt.iterator((CharSequence)$receiver);
            while (charIterator.hasNext()) {
                char c2 = charIterator.nextChar();
                if (c2 != c) continue;
                return true;
            }
            return false;
        }

        public final int countSecondLineCells(@NotNull CharSequence line) {
            Intrinsics.checkParameterIsNotNull((Object)line, (String)"line");
            int offset = this.passWhiteSpaces(line, 0);
            if (offset < line.length() && line.charAt(offset) == '|') {
                ++offset;
            }
            int result = 0;
            while (offset < line.length()) {
                if ((offset = this.passWhiteSpaces(line, offset)) < line.length() && line.charAt(offset) == ':') {
                    ++offset;
                }
                offset = this.passWhiteSpaces(line, offset);
                int dashes = 0;
                while (offset < line.length() && line.charAt(offset) == '-') {
                    ++offset;
                    ++dashes;
                }
                if (dashes < 3) {
                    return 0;
                }
                ++result;
                if ((offset = this.passWhiteSpaces(line, offset)) < line.length() && line.charAt(offset) == ':') {
                    ++offset;
                }
                if ((offset = this.passWhiteSpaces(line, offset)) >= line.length() || line.charAt(offset) != '|') break;
                ++offset;
            }
            if ((offset = this.passWhiteSpaces(line, offset)) == line.length()) {
                return result;
            }
            return 0;
        }

        public final int passWhiteSpaces(@NotNull CharSequence line, int offset) {
            int curOffset;
            Intrinsics.checkParameterIsNotNull((Object)line, (String)"line");
            for (curOffset = offset; curOffset < line.length() && (line.charAt(curOffset) == ' ' || line.charAt(curOffset) == '\t'); ++curOffset) {
            }
            return curOffset;
        }

        static {
            new Companion();
        }

        private Companion() {
            INSTANCE = this;
        }
    }
}

