/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.util;

import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.gradle.util.PropertiesUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SystemProperties;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LocalProperties {
    @NotNull
    private final File myFilePath;
    @NotNull
    private final File myProjectDirPath;
    @NotNull
    private final Properties myProperties;

    public LocalProperties(@NotNull Project project) throws IOException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/LocalProperties", "<init>"));
        }
        this(Projects.getBaseDirPath(project));
    }

    public LocalProperties(@NotNull File projectDirPath) throws IOException {
        if (projectDirPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectDirPath", "com/android/tools/idea/gradle/util/LocalProperties", "<init>"));
        }
        this.myProjectDirPath = projectDirPath;
        this.myFilePath = new File(projectDirPath, "local.properties");
        this.myProperties = PropertiesUtil.getProperties(this.myFilePath);
    }

    @Nullable
    public File getAndroidSdkPath() {
        return this.getPath("sdk.dir");
    }

    @Nullable
    public File getAndroidNdkPath() {
        return this.getPath("ndk.dir");
    }

    @Nullable
    private File getPath(String property) {
        String path = this.getProperty(property);
        if (StringUtil.isNotEmpty((String)path)) {
            String canonicalPath;
            File file;
            if (!FileUtil.isAbsolute((String)path) && !(file = new File(canonicalPath = FileUtil.toCanonicalPath((String)new File(this.myProjectDirPath, FileUtil.toSystemDependentName((String)path)).getPath()))).isDirectory()) {
                return new File(path);
            }
            return new File(FileUtil.toSystemDependentName((String)path));
        }
        return null;
    }

    public void setAndroidSdkPath(@NotNull Sdk androidSdk) {
        if (androidSdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidSdk", "com/android/tools/idea/gradle/util/LocalProperties", "setAndroidSdkPath"));
        }
        String androidSdkPath = androidSdk.getHomePath();
        assert (androidSdkPath != null);
        this.setAndroidSdkPath(androidSdkPath);
    }

    public void setAndroidSdkPath(@NotNull String androidSdkPath) {
        if (androidSdkPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidSdkPath", "com/android/tools/idea/gradle/util/LocalProperties", "setAndroidSdkPath"));
        }
        this.doSetAndroidSdkPath(FileUtil.toSystemDependentName((String)androidSdkPath));
    }

    public void setAndroidSdkPath(@NotNull File androidSdkPath) {
        if (androidSdkPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidSdkPath", "com/android/tools/idea/gradle/util/LocalProperties", "setAndroidSdkPath"));
        }
        this.doSetAndroidSdkPath(androidSdkPath.getPath());
    }

    @VisibleForTesting
    void doSetAndroidSdkPath(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/android/tools/idea/gradle/util/LocalProperties", "doSetAndroidSdkPath"));
        }
        this.myProperties.setProperty("sdk.dir", path);
    }

    public void setAndroidNdkPath(@NotNull String androidNdkPath) {
        if (androidNdkPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidNdkPath", "com/android/tools/idea/gradle/util/LocalProperties", "setAndroidNdkPath"));
        }
        this.doSetAndroidNdkPath(FileUtil.toSystemDependentName((String)androidNdkPath));
    }

    public void setAndroidNdkPath(@Nullable File androidNdkPath) {
        String path = androidNdkPath != null ? androidNdkPath.getPath() : null;
        this.doSetAndroidNdkPath(path);
    }

    @VisibleForTesting
    void doSetAndroidNdkPath(@Nullable String path) {
        if (StringUtil.isNotEmpty((String)path)) {
            this.myProperties.setProperty("ndk.dir", path);
        } else {
            this.myProperties.remove("ndk.dir");
        }
    }

    public boolean hasAndroidDirProperty() {
        String property = this.getProperty("android.dir");
        return !Strings.isNullOrEmpty((String)property);
    }

    @Nullable
    public String getProperty(@NotNull String key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/android/tools/idea/gradle/util/LocalProperties", "getProperty"));
        }
        return this.myProperties.getProperty(key);
    }

    public void save() throws IOException {
        PropertiesUtil.savePropertiesToFile(this.myProperties, this.myFilePath, LocalProperties.getHeaderComment());
    }

    @NotNull
    private static String getHeaderComment() {
        Object[] lines = new String[]{"# This file is automatically generated by Android Studio.", "# Do not modify this file -- YOUR CHANGES WILL BE ERASED!", "#", "# This file must *NOT* be checked into Version Control Systems,", "# as it contains information specific to your local configuration.", "", "# Location of the SDK. This is only used by Gradle.", "# For customization when using a Version Control System, please read the", "# header note."};
        String string = Joiner.on((String)SystemProperties.getLineSeparator()).join(lines);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/util/LocalProperties", "getHeaderComment"));
        }
        return string;
    }

    @NotNull
    public File getFilePath() {
        File file = this.myFilePath;
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/util/LocalProperties", "getFilePath"));
        }
        return file;
    }
}

