/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.xpathView.ui;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.javaee.ExternalResourceManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.ui.EditorComboBox;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.LocalTimeCounter;
import com.intellij.util.containers.BidirectionalMap;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.xml.namespace.QName;
import org.intellij.lang.xpath.XPathFileType;
import org.intellij.lang.xpath.context.ContextProvider;
import org.intellij.lang.xpath.context.ContextType;
import org.intellij.lang.xpath.context.NamespaceContext;
import org.intellij.lang.xpath.context.SimpleVariableContext;
import org.intellij.lang.xpath.context.VariableContext;
import org.intellij.lang.xpath.psi.PrefixReference;
import org.intellij.lang.xpath.psi.QNameElement;
import org.intellij.lang.xpath.psi.XPathElement;
import org.intellij.plugins.xpathView.Config;
import org.intellij.plugins.xpathView.HistoryElement;
import org.intellij.plugins.xpathView.support.XPathSupport;
import org.intellij.plugins.xpathView.ui.AddNamespaceDialog;
import org.intellij.plugins.xpathView.ui.EditContextDialog;
import org.intellij.plugins.xpathView.ui.HistoryModel;
import org.intellij.plugins.xpathView.ui.InputForm;
import org.intellij.plugins.xpathView.ui.Mode;
import org.intellij.plugins.xpathView.ui.ModeSwitchableDialog;
import org.intellij.plugins.xpathView.ui.MultilineEditor;
import org.intellij.plugins.xpathView.util.Namespace;
import org.intellij.plugins.xpathView.util.NamespaceCollector;
import org.intellij.plugins.xpathView.util.Variable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class InputExpressionDialog<FormType extends InputForm>
extends ModeSwitchableDialog {
    protected final Project myProject;
    protected final FormType myForm;
    protected final Config mySettings;
    private final HistoryModel myModel;
    private final Document myDocument;
    private final MultilineEditor myEditor;
    private final EditorComboBox myComboBox;
    private JComponent myEditorComponent;
    @Nullable
    private Set<Namespace> myNamespaceCache;
    private InteractiveContextProvider myContextProvider;
    private final PsiFile myXPathFile;

    public InputExpressionDialog(final Project project, Config settings, HistoryElement[] _history, FormType form) {
        super(project, false);
        this.myProject = project;
        this.myForm = form;
        this.setResizable(true);
        this.setModal(true);
        this.setHorizontalStretch(1.3f);
        this.mySettings = settings;
        this.myDocument = InputExpressionDialog.createXPathDocument(project, _history.length > 0 ? _history[_history.length - 1] : null);
        this.myXPathFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(this.myDocument);
        this.myModel = new HistoryModel(_history, this.myDocument);
        this.myEditor = new MultilineEditor(this.myDocument, project, (FileType)XPathFileType.XPATH, this.myModel);
        this.myModel.addListDataListener(new ListDataListener(){
            final DaemonCodeAnalyzer analyzer;
            {
                this.analyzer = DaemonCodeAnalyzer.getInstance((Project)project);
            }

            @Override
            public void intervalAdded(ListDataEvent e) {
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                HistoryElement item = InputExpressionDialog.this.myModel.getSelectedItem();
                if (item != null) {
                    InputExpressionDialog.this.myContextProvider.getNamespaceContext().setMap(InputExpressionDialog.this.asMap(item.namespaces));
                    if (InputExpressionDialog.this.myXPathFile != null) {
                        this.analyzer.restart(InputExpressionDialog.this.myXPathFile);
                    }
                }
            }
        });
        this.myComboBox = new EditorComboBox(this.myDocument, project, (FileType)XPathFileType.XPATH);
        this.myComboBox.setRenderer((ListCellRenderer)new ListCellRendererWrapper<HistoryElement>(){

            public void customize(JList list, HistoryElement value, int index, boolean selected, boolean hasFocus) {
                this.setText(value != null ? value.expression : "");
            }
        });
        this.myComboBox.setModel((ComboBoxModel)this.myModel);
        this.myComboBox.setEditable(true);
        this.myDocument.addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void documentChanged(DocumentEvent e) {
                InputExpressionDialog.this.updateOkAction();
            }
        });
        this.init();
    }

    @Override
    protected void init() {
        this.myForm.getIcon().setText(null);
        this.myForm.getIcon().setIcon(Messages.getQuestionIcon());
        this.myForm.getEditContextButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Set<Variable> v;
                Set<Namespace> n;
                HistoryElement selectedItem = InputExpressionDialog.this.myModel.getSelectedItem();
                if (selectedItem != null) {
                    n = selectedItem.namespaces;
                    v = selectedItem.variables;
                } else {
                    n = Collections.emptySet();
                    v = Collections.emptySet();
                }
                Set<Namespace> namespaces = InputExpressionDialog.this.myNamespaceCache != null ? InputExpressionDialog.merge(InputExpressionDialog.this.myNamespaceCache, n, false) : n;
                Set unresolvedPrefixes = InputExpressionDialog.this.findUnresolvedPrefixes();
                EditContextDialog dialog = new EditContextDialog(InputExpressionDialog.this.myProject, unresolvedPrefixes, namespaces, v, InputExpressionDialog.this.myContextProvider);
                if (dialog.showAndGet()) {
                    Pair<Collection<Namespace>, Collection<Variable>> context = dialog.getContext();
                    Collection newNamespaces = (Collection)context.getFirst();
                    Collection newVariables = (Collection)context.getSecond();
                    InputExpressionDialog.this.updateContext(newNamespaces, newVariables);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Editor editor = InputExpressionDialog.this.getEditor();
                            if (editor != null) {
                                editor.getContentComponent().grabFocus();
                            }
                        }
                    });
                }
            }
        });
        this.updateOkAction();
        super.init();
    }

    void updateContext(Collection<Namespace> namespaces, Collection<Variable> variables) {
        HistoryElement selectedItem = this.myModel.getSelectedItem();
        HistoryElement newElement = selectedItem != null ? selectedItem.changeContext(namespaces, variables) : new HistoryElement(this.myDocument.getText(), variables, namespaces);
        this.myModel.setSelectedItem(newElement);
        if (this.myNamespaceCache == null) {
            this.myContextProvider.getNamespaceContext().setMap(this.asMap(namespaces));
        }
        DaemonCodeAnalyzer analyzer = DaemonCodeAnalyzer.getInstance((Project)this.myProject);
        analyzer.restart(this.myXPathFile);
    }

    private Set<String> findUnresolvedPrefixes() {
        final HashSet<String> prefixes = new HashSet<String>();
        this.myXPathFile.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(){

            public void visitElement(PsiElement element) {
                if (element instanceof QNameElement) {
                    PsiReference[] references;
                    for (PsiReference reference : references = element.getReferences()) {
                        PrefixReference prefixReference;
                        if (!(reference instanceof PrefixReference) || !(prefixReference = (PrefixReference)reference).isUnresolved()) continue;
                        prefixes.add(prefixReference.getPrefix());
                    }
                }
                super.visitElement(element);
            }
        });
        return prefixes;
    }

    protected FormType getForm() {
        return this.myForm;
    }

    protected JComponent createCenterPanel() {
        return this.myForm.getComponent();
    }

    protected void updateOkAction() {
        this.getOKAction().setEnabled(this.isOkEnabled());
    }

    protected boolean isOkEnabled() {
        return this.myEditor.getField().getDocument().getTextLength() > 0;
    }

    @Nullable
    protected Editor getEditor() {
        if (this.getMode() == Mode.ADVANCED) {
            return this.myEditor.getField().getEditor();
        }
        return this.myComboBox.getEditorEx();
    }

    @Override
    protected void setModeImpl(Mode mode) {
        this.myForm.getEditContextButton().setVisible(mode == Mode.ADVANCED);
        if (mode == Mode.ADVANCED) {
            this.setEditor(this.myEditor, 4);
            this.myEditor.getField().selectAll();
        } else {
            this.setEditor((JComponent)this.myComboBox, 0);
            this.myComboBox.setModel((ComboBoxModel)this.myModel);
            this.myComboBox.getEditor().selectAll();
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Editor editor = InputExpressionDialog.this.getEditor();
                if (editor != null) {
                    editor.getContentComponent().grabFocus();
                }
            }
        });
    }

    private void setEditor(JComponent editor, int vSizePolicy) {
        if (this.myEditorComponent != null) {
            this.myForm.getEditorPanel().remove(this.myEditorComponent);
        }
        GridConstraints gridConstraints = new GridConstraints();
        gridConstraints.setFill(vSizePolicy == 4 ? 3 : 1);
        gridConstraints.setVSizePolicy(vSizePolicy);
        this.myEditorComponent = editor;
        this.myForm.getEditorPanel().add((Component)this.myEditorComponent, gridConstraints);
    }

    protected static Document createXPathDocument(Project project, HistoryElement historyElement) {
        String expression = historyElement != null ? historyElement.expression : "";
        PsiFile file = PsiFileFactory.getInstance((Project)project).createFileFromText("DummyFile.xpath", (FileType)XPathFileType.XPATH, (CharSequence)expression, LocalTimeCounter.currentTime(), true);
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument(file);
        assert (document != null);
        document.setReadOnly(false);
        assert (document.isWritable()) : "WTF, document is not writable? Text = <" + expression + ">";
        return document;
    }

    public boolean show(XmlElement contextElement) {
        this.prepareShow(contextElement);
        this.show();
        return this.isOK();
    }

    private void prepareShow(XmlElement contextElement) {
        NamespaceCollector.CollectedInfo collectedInfo;
        if (contextElement != null) {
            collectedInfo = NamespaceCollector.collectInfo((XmlFile)contextElement.getContainingFile());
            this.myNamespaceCache = collectedInfo.namespaces;
        } else {
            collectedInfo = NamespaceCollector.empty();
            this.myNamespaceCache = null;
        }
        this.myContextProvider = new InteractiveContextProvider(contextElement, collectedInfo, this.myModel);
        this.myContextProvider.attachTo(this.myXPathFile);
        HistoryElement historyElement = this.myModel.getSelectedItem();
        if (historyElement != null) {
            this.myContextProvider.getNamespaceContext().setMap(this.asMap(historyElement.namespaces));
        } else {
            this.myContextProvider.getNamespaceContext().setMap(this.asMap(null));
        }
        this.updateOkAction();
    }

    protected static Collection<Namespace> merge(Collection<Namespace> namespaces, Collection<Namespace> cache, boolean merge) {
        HashSet<Namespace> n;
        if (cache == null) {
            return namespaces;
        }
        if (merge) {
            n = new HashSet<Namespace>(cache);
            n.removeAll(namespaces);
            n.addAll(namespaces);
        } else {
            n = new HashSet<Namespace>(namespaces);
            for (Namespace namespace : n) {
                for (Namespace cached : cache) {
                    if (!namespace.getUri().equals(cached.getUri())) continue;
                    namespace.setPrefix(cached.prefix);
                }
            }
        }
        return n;
    }

    protected Map<String, String> asMap(Collection<Namespace> namespaces) {
        if (namespaces == null) {
            if (this.myNamespaceCache != null) {
                return Namespace.makeMap(this.myNamespaceCache);
            }
            return Collections.emptyMap();
        }
        if (this.myNamespaceCache != null) {
            namespaces = InputExpressionDialog.merge(this.myNamespaceCache, namespaces, false);
        }
        return Namespace.makeMap(namespaces);
    }

    public JComponent getPreferredFocusedComponent() {
        Editor editor = this.getEditor();
        if (editor != null) {
            return editor.getContentComponent();
        }
        return null;
    }

    public Context getContext() {
        HistoryElement context = this.myModel.getSelectedItem();
        if (context == null || context.expression == null) {
            Set<Namespace> cache = this.myNamespaceCache != null ? this.myNamespaceCache : Collections.emptySet();
            return new Context(new HistoryElement(this.myDocument.getText(), Collections.<Variable>emptySet(), cache), this.getMode());
        }
        Collection<Namespace> namespaces = this.myNamespaceCache != null ? InputExpressionDialog.merge(this.myNamespaceCache, context.namespaces, false) : context.namespaces;
        return new Context(new HistoryElement(context.expression, context.variables, namespaces), this.getMode());
    }

    private class MyRegisterPrefixAction
    implements IntentionAction {
        private final PsiReference myReference;

        public MyRegisterPrefixAction(PsiReference reference) {
            this.myReference = reference;
        }

        @NotNull
        public String getText() {
            if ("Register namespace prefix" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/xpathView/ui/InputExpressionDialog$MyRegisterPrefixAction", "getText"));
            }
            return "Register namespace prefix";
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getText();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/xpathView/ui/InputExpressionDialog$MyRegisterPrefixAction", "getFamilyName"));
            }
            return string;
        }

        public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/intellij/plugins/xpathView/ui/InputExpressionDialog$MyRegisterPrefixAction", "isAvailable"));
            }
            return this.myReference instanceof PrefixReference && this.myReference.getElement().isValid() && ((PrefixReference)this.myReference).isUnresolved();
        }

        public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
            Collection<String> list;
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/intellij/plugins/xpathView/ui/InputExpressionDialog$MyRegisterPrefixAction", "invoke"));
            }
            Set<String> prefix = Collections.singleton(this.myReference.getCanonicalText());
            BidirectionalMap myMap = InputExpressionDialog.this.myContextProvider.getNamespaceContext().myMap;
            if (InputExpressionDialog.this.myNamespaceCache == null) {
                ExternalResourceManager erm = ExternalResourceManager.getInstance();
                list = new ArrayList<String>(Arrays.asList(erm.getResourceUrls(null, true)));
                for (String namespace : myMap.values()) {
                    list.remove(namespace);
                }
                Collections.sort((List)list);
            } else {
                list = myMap.values();
            }
            AddNamespaceDialog dlg = new AddNamespaceDialog(project, prefix, list, InputExpressionDialog.this.myNamespaceCache == null ? AddNamespaceDialog.Mode.URI_EDITABLE : AddNamespaceDialog.Mode.FIXED);
            if (dlg.showAndGet()) {
                Collection<Variable> v;
                Set<Namespace> n;
                Namespace namespace = new Namespace(dlg.getPrefix(), dlg.getURI());
                HistoryElement selectedItem = InputExpressionDialog.this.myModel.getSelectedItem();
                if (selectedItem != null) {
                    n = new HashSet<Namespace>(selectedItem.namespaces);
                    n.remove(namespace);
                    n.add(namespace);
                    v = selectedItem.variables;
                } else {
                    n = Collections.singleton(namespace);
                    v = Collections.emptySet();
                }
                InputExpressionDialog.this.updateContext(n, v);
            }
        }

        public boolean startInWriteAction() {
            return false;
        }
    }

    protected class MyNamespaceContext
    implements NamespaceContext {
        private BidirectionalMap<String, String> myMap;

        protected MyNamespaceContext() {
        }

        @Override
        @Nullable
        public String getNamespaceURI(String prefix, XmlElement context) {
            String s = (String)this.myMap.get((Object)prefix);
            if (s == null && prefix.length() == 0) {
                return "";
            }
            return s;
        }

        @Override
        @Nullable
        public String getPrefixForURI(String uri, XmlElement context) {
            List list = this.myMap.getKeysByValue((Object)uri);
            return list != null && !list.isEmpty() ? (String)list.get(0) : null;
        }

        @Override
        @NotNull
        public Collection<String> getKnownPrefixes(XmlElement context) {
            Set set = this.myMap.keySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/xpathView/ui/InputExpressionDialog$MyNamespaceContext", "getKnownPrefixes"));
            }
            return set;
        }

        @Override
        @Nullable
        public PsiElement resolve(String prefix, XmlElement context) {
            return null;
        }

        public void setMap(Map<String, String> map) {
            this.myMap = new BidirectionalMap();
            this.myMap.putAll(map);
        }

        @Override
        public IntentionAction[] getUnresolvedNamespaceFixes(PsiReference reference, String localName) {
            return new IntentionAction[]{new MyRegisterPrefixAction(reference)};
        }

        @Override
        public String getDefaultNamespace(XmlElement context) {
            return null;
        }
    }

    private class InteractiveContextProvider
    extends ContextProvider {
        private final XmlElement myContextElement;
        private final NamespaceCollector.CollectedInfo myCollectedInfo;
        private final MyVariableResolver myVariableResolver;
        private final MyNamespaceContext myNamespaceContext;

        public InteractiveContextProvider(XmlElement contextElement, NamespaceCollector.CollectedInfo collectedInfo, HistoryModel model) {
            this.myContextElement = contextElement;
            this.myCollectedInfo = collectedInfo;
            this.myVariableResolver = new MyVariableResolver(model);
            this.myNamespaceContext = new MyNamespaceContext();
        }

        @Override
        @NotNull
        public ContextType getContextType() {
            ContextType contextType = XPathSupport.TYPE;
            if (contextType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/xpathView/ui/InputExpressionDialog$InteractiveContextProvider", "getContextType"));
            }
            return contextType;
        }

        @Override
        @Nullable
        public XmlElement getContextElement() {
            return this.myContextElement;
        }

        @Override
        @NotNull
        public MyNamespaceContext getNamespaceContext() {
            MyNamespaceContext myNamespaceContext = this.myNamespaceContext;
            if (myNamespaceContext == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/xpathView/ui/InputExpressionDialog$InteractiveContextProvider", "getNamespaceContext"));
            }
            return myNamespaceContext;
        }

        @Override
        public VariableContext getVariableContext() {
            return this.myVariableResolver;
        }

        @Override
        public Set<QName> getAttributes(boolean forValidation) {
            return this.myCollectedInfo.attributes;
        }

        private Set<QName> filterDefaultNamespace(Set<QName> _set) {
            HashSet<QName> set = new HashSet<QName>(_set);
            Iterator it = set.iterator();
            while (it.hasNext()) {
                String assignedPrefix;
                String uri;
                QName name = (QName)it.next();
                String prefix = name.getPrefix();
                if (prefix != null && prefix.length() != 0 || (uri = name.getNamespaceURI()) == null || uri.length() <= 0 || (assignedPrefix = this.myNamespaceContext.getPrefixForURI(uri, null)) != null && assignedPrefix.length() != 0) continue;
                it.remove();
            }
            return set;
        }

        @Override
        public Set<QName> getElements(boolean forValidation) {
            return this.filterDefaultNamespace(this.myCollectedInfo.elements);
        }
    }

    private static class MyVariableResolver
    extends SimpleVariableContext {
        private final HistoryModel myModel;

        public MyVariableResolver(HistoryModel model) {
            this.myModel = model;
        }

        @NotNull
        public String[] getVariablesInScope(XPathElement element) {
            HistoryElement selectedItem = this.myModel.getSelectedItem();
            if (selectedItem != null) {
                String[] stringArray = Variable.asSet(selectedItem.variables).toArray(new String[selectedItem.variables.size()]);
                if (stringArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/xpathView/ui/InputExpressionDialog$MyVariableResolver", "getVariablesInScope"));
                }
                return stringArray;
            }
            if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/xpathView/ui/InputExpressionDialog$MyVariableResolver", "getVariablesInScope"));
            }
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
    }

    public static class Context {
        public final HistoryElement input;
        public final Mode mode;

        Context(HistoryElement context, Mode mode) {
            this.input = context;
            this.mode = mode;
        }
    }
}

