/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class Queue<T> {
    private Object[] myArray;
    private int myFirst;
    private int myLast;
    private boolean isWrapped;

    public Queue(int initialCapacity) {
        this.myArray = initialCapacity > 0 ? new Object[initialCapacity] : ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    public void addLast(T object) {
        int currentSize = this.size();
        if (currentSize == this.myArray.length) {
            this.myArray = this.normalize(Math.max(currentSize * 2, 5));
            this.myFirst = 0;
            this.myLast = currentSize;
            this.isWrapped = false;
        }
        this.myArray[this.myLast] = object;
        ++this.myLast;
        if (this.myLast == this.myArray.length) {
            this.isWrapped = !this.isWrapped;
            this.myLast = 0;
        }
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int size() {
        return this.isWrapped ? this.myArray.length - this.myFirst + this.myLast : this.myLast - this.myFirst;
    }

    public T pullFirst() {
        T result2 = this.peekFirst();
        this.myArray[this.myFirst] = null;
        ++this.myFirst;
        if (this.myFirst == this.myArray.length) {
            this.myFirst = 0;
            this.isWrapped = !this.isWrapped;
        }
        return result2;
    }

    public T peekFirst() {
        if (this.isEmpty()) {
            throw new IndexOutOfBoundsException("queue is empty");
        }
        Object t = this.myArray[this.myFirst];
        return (T)t;
    }

    private int copyFromTo(int first, int last, Object[] result2, int destinationPos) {
        int length = last - first;
        System.arraycopy(this.myArray, first, result2, destinationPos, length);
        return length;
    }

    private T[] normalize(int capacity) {
        Object[] result2 = new Object[capacity];
        if (this.isWrapped) {
            int tailLength = this.copyFromTo(this.myFirst, this.myArray.length, result2, 0);
            this.copyFromTo(0, this.myLast, result2, tailLength);
        } else {
            this.copyFromTo(this.myFirst, this.myLast, result2, 0);
        }
        return result2;
    }

    public void clear() {
        Arrays.fill(this.myArray, null);
        this.myLast = 0;
        this.myFirst = 0;
        this.isWrapped = false;
    }

    public boolean process(@NotNull Processor<T> processor2) {
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/util/containers/Queue", "process"));
        }
        if (this.isWrapped) {
            Object t;
            int i;
            for (i = this.myFirst; i < this.myArray.length; ++i) {
                t = this.myArray[i];
                if (processor2.process(t)) continue;
                return false;
            }
            for (i = 0; i < this.myLast; ++i) {
                t = this.myArray[i];
                if (processor2.process(t)) continue;
                return false;
            }
        } else {
            for (int i = this.myFirst; i < this.myLast; ++i) {
                Object t = this.myArray[i];
                if (processor2.process(t)) continue;
                return false;
            }
        }
        return true;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "<empty>";
        }
        List<Object> list = Arrays.asList(this.myArray);
        if (this.isWrapped) {
            return "[[[ " + list.subList(0, this.myLast) + " ||| ... " + list.subList(this.myLast, this.myFirst) + " ... ||| " + list.subList(this.myFirst, this.myArray.length) + " ]]]";
        }
        return "[[[ ... " + list.subList(0, this.myFirst) + " ... ||| " + list.subList(this.myFirst, this.myLast) + " ||| ... " + list.subList(this.myFirst, this.myArray.length) + " ... ]]]";
    }
}

