/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization.fixStack;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.CollectionsKt;
import kotlin.MapsKt;
import kotlin.Pair;
import kotlin.PreconditionsKt;
import kotlin.SetsKt;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.optimization.common.UtilKt;
import org.jetbrains.kotlin.codegen.optimization.fixStack.DecompiledTryDescriptor;
import org.jetbrains.kotlin.codegen.pseudoInsns.PseudoInsn;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.LabelNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.TryCatchBlockNode;

@KotlinFileFacade(version={1, 0, 0}, abiVersion=32, data={"?\u0015\u0001Q!\u0001\u0005\u0002\u000b\u0001)\u0011\u0001#\n\u0006\u00031\tQ!\u0001\u0007\u0002\u000b\u0005!\u0011!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0011I)\u0011\u0001b\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0011\u001d)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001E\u0006\u001bw!\u0011\u0001\u0003\u0001\u000e\u0003a\u0005\u0011$\u0003\u0005\u0002\u001b\u001dI!!C\u0001\u0019\u0005%\u0011\u0011\"\u0001M\u00031\u0007I\u0012\u0002C\u0002\u000e\u000f%\u0011\u0011\"\u0001\r\u0003\u0013\tI\u0011\u0001'\u0002\u0019\u0004e\u0019\u0001rA\u0007\u00021\u0011!6\u0011BG\u001e\t\u0005AQ!D\u0001\u0019\u0002eI\u0001\"A\u0007\b\u0013\tI\u0011\u0001\u0007\u0002\n\u0005%\t\u0001T\u0001M\u00063\rA9!D\u0001\u0019\teI\u0001BB\u0007\b\u0013\tI\u0011\u0001\u0007\u0002\n\u0005%\t\u0001D\u0001M\u0002)\u000e%Q2\u0003\u0003\u0001\u0011\u001bi\u0011\u0001'\u0001\u001a\u0007!\u001dQ\"\u0001\r\u0005)\u000e%Qr\u0005\u0003\u0002\u0011\u001di\u0011\u0001'\u0001\u001a\u0007!\u001dQ\"\u0001\r\u00053%Aa!D\u0004\n\u0005%\t\u0001DA\u0005\u0003\u0013\u0005A\"\u0001g\u0004U\u0007\u0013iQ\u0002B\u0001\t\u00115\t\u0001\u0014C\u000b\u00021\u0011IJ\u0001C\u0005\u000e\u0003aM\u0001k!\u0001U\u0007\u0013iy\u0001B\u0001\t\u00155\t\u0001TC\u000b\u00021'!6\u0011\u0002"}, strings={"collectDecompiledTryDescriptors", "", "decompiledTryDescriptorForStart", "", "Lorg/jetbrains/org/objectweb/asm/tree/LabelNode;", "Lorg/jetbrains/kotlin/codegen/optimization/fixStack/DecompiledTryDescriptor;", "decompiledTryDescriptorForHandler", "methodNode", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "AnalyzeTryCatchBlocksKt", "insertSaveRestoreStackMarkers", "", "newTryStartLabels", "insertTryCatchBlocksMarkers", "transformTryCatchBlocks", "Ljava/util/HashMap;", "debugString", "", "tcb", "Lorg/jetbrains/org/objectweb/asm/tree/TryCatchBlockNode;", "isDefaultHandlerNode", ""}, moduleName="kotlin-compiler")
public final class AnalyzeTryCatchBlocksKt {
    private static final boolean isDefaultHandlerNode(TryCatchBlockNode $receiver) {
        return Intrinsics.areEqual($receiver.start, $receiver.handler);
    }

    private static final String debugString(MethodNode $receiver, TryCatchBlockNode tcb) {
        return "TCB<" + $receiver.instructions.indexOf(tcb.start) + ", " + $receiver.instructions.indexOf(tcb.end) + ", " + $receiver.instructions.indexOf(tcb.handler) + ">";
    }

    public static final void insertTryCatchBlocksMarkers(@NotNull MethodNode methodNode) {
        Intrinsics.checkParameterIsNotNull(methodNode, "methodNode");
        if (methodNode.tryCatchBlocks.isEmpty()) {
            return;
        }
        LinkedHashMap decompiledTryDescriptorForStart = MapsKt.linkedMapOf(new Pair[0]);
        HashMap decompiledTryDescriptorForHandler = MapsKt.hashMapOf(new Pair[0]);
        AnalyzeTryCatchBlocksKt.collectDecompiledTryDescriptors(decompiledTryDescriptorForStart, decompiledTryDescriptorForHandler, methodNode);
        HashMap<LabelNode, LabelNode> newTryStartLabels = MapsKt.hashMapOf(new Pair[0]);
        AnalyzeTryCatchBlocksKt.insertSaveRestoreStackMarkers(decompiledTryDescriptorForStart, methodNode, (Map<LabelNode, LabelNode>)newTryStartLabels);
        AnalyzeTryCatchBlocksKt.transformTryCatchBlocks(methodNode, newTryStartLabels);
    }

    /*
     * WARNING - void declaration
     */
    private static final void transformTryCatchBlocks(MethodNode methodNode, HashMap<LabelNode, LabelNode> newTryStartLabels) {
        List list;
        void destination;
        void $receiver;
        void $receiver2;
        Iterable iterable = methodNode.tryCatchBlocks;
        MethodNode methodNode2 = methodNode;
        void var3_4 = $receiver2;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver2, 10));
        for (Object item : $receiver) {
            void tcb;
            TryCatchBlockNode tryCatchBlockNode = (TryCatchBlockNode)item;
            list = destination;
            LabelNode newTryStartLabel = newTryStartLabels.get(tcb.start);
            TryCatchBlockNode tryCatchBlockNode2 = newTryStartLabel == null ? tcb : new TryCatchBlockNode(newTryStartLabel, tcb.end, tcb.handler, tcb.type);
            list.add(tryCatchBlockNode2);
        }
        methodNode2.tryCatchBlocks = list = (List)destination;
    }

    /*
     * WARNING - void declaration
     */
    private static final void insertSaveRestoreStackMarkers(Map<LabelNode, ? extends DecompiledTryDescriptor> decompiledTryDescriptorForStart, MethodNode methodNode, Map<LabelNode, LabelNode> newTryStartLabels) {
        DecompiledTryDescriptor $receiver;
        HashSet<LabelNode> doneTryStartLabels = SetsKt.hashSetOf(new LabelNode[0]);
        HashSet<LabelNode> doneHandlerLabels = SetsKt.hashSetOf(new LabelNode[0]);
        Map<LabelNode, ? extends DecompiledTryDescriptor> map2 = decompiledTryDescriptorForStart;
        for (DecompiledTryDescriptor decompiledTryDescriptor : $receiver.values()) {
            Object message;
            $receiver = decompiledTryDescriptor;
            if (!doneTryStartLabels.contains($receiver.getTryStartLabel())) {
                Unit unit;
                AbstractInsnNode nopNode;
                AbstractInsnNode it;
                AbstractInsnNode finger;
                doneTryStartLabels.add($receiver.getTryStartLabel());
                AbstractInsnNode $i$f$values = $receiver.getTryStartLabel();
                for (finger = $receiver2.getNext(); finger != null && !UtilKt.hasOpcode(it = finger); finger = finger.getNext()) {
                }
                if (finger == null) {
                    Intrinsics.throwNpe();
                }
                boolean $receiver2 = nopNode.getOpcode() == 0;
                if (PreconditionsKt.getASSERTIONS_ENABLED()) {
                    void value;
                    if (value == false) {
                        message = methodNode.instructions.indexOf(nopNode) + ": try block should start with NOP";
                        throw (Throwable)((Object)new AssertionError(message));
                    }
                    unit = Unit.INSTANCE;
                } else {
                    unit = Unit.INSTANCE;
                }
                LabelNode newTryStartLabel = new LabelNode(new Label());
                MapsKt.set(newTryStartLabels, $receiver.getTryStartLabel(), newTryStartLabel);
                methodNode.instructions.insertBefore(nopNode, PseudoInsn.SAVE_STACK_BEFORE_TRY.createInsnNode());
                methodNode.instructions.insertBefore(nopNode, newTryStartLabel);
                methodNode.instructions.insert(nopNode, PseudoInsn.RESTORE_STACK_IN_TRY_CATCH.createInsnNode());
            }
            for (LabelNode handlerStartLabel : $receiver.getHandlerStartLabels()) {
                Unit unit;
                AbstractInsnNode storeNode;
                AbstractInsnNode it;
                AbstractInsnNode finger;
                if (doneHandlerLabels.contains(handlerStartLabel)) continue;
                doneHandlerLabels.add(handlerStartLabel);
                message = handlerStartLabel;
                for (finger = $receiver3.getNext(); finger != null && !UtilKt.hasOpcode(it = finger); finger = finger.getNext()) {
                }
                if (finger == null) {
                    Intrinsics.throwNpe();
                }
                boolean $receiver3 = storeNode.getOpcode() == 58;
                if (PreconditionsKt.getASSERTIONS_ENABLED()) {
                    void value;
                    if (value == false) {
                        String message2 = methodNode.instructions.indexOf(storeNode) + ": handler should start with ASTORE";
                        throw (Throwable)((Object)new AssertionError((Object)message2));
                    }
                    unit = Unit.INSTANCE;
                } else {
                    unit = Unit.INSTANCE;
                }
                methodNode.instructions.insert(storeNode, PseudoInsn.RESTORE_STACK_IN_TRY_CATCH.createInsnNode());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void collectDecompiledTryDescriptors(Map<LabelNode, DecompiledTryDescriptor> decompiledTryDescriptorForStart, Map<LabelNode, DecompiledTryDescriptor> decompiledTryDescriptorForHandler, MethodNode methodNode) {
        for (TryCatchBlockNode tcb : methodNode.tryCatchBlocks) {
            Unit unit;
            Object object;
            void key22;
            DecompiledTryDescriptor $receiver;
            if (AnalyzeTryCatchBlocksKt.isDefaultHandlerNode(tcb)) {
                Unit unit2;
                boolean bl = decompiledTryDescriptorForHandler.containsKey(tcb.start);
                if (PreconditionsKt.getASSERTIONS_ENABLED()) {
                    void value;
                    if (value == false) {
                        StringBuilder stringBuilder = new StringBuilder();
                        TryCatchBlockNode tryCatchBlockNode = tcb;
                        Intrinsics.checkExpressionValueIsNotNull(tryCatchBlockNode, "tcb");
                        String message = stringBuilder.append(AnalyzeTryCatchBlocksKt.debugString(methodNode, tryCatchBlockNode)).append(": default handler should occur after some regular handler").toString();
                        throw (Throwable)((Object)new AssertionError((Object)message));
                    }
                    unit2 = Unit.INSTANCE;
                } else {
                    unit2 = Unit.INSTANCE;
                }
            }
            Map<LabelNode, DecompiledTryDescriptor> $i$a$1 = decompiledTryDescriptorForHandler;
            Intrinsics.checkExpressionValueIsNotNull(tcb.handler, "tcb.handler");
            Object value = $receiver.get(key22);
            if (value == null && !$receiver.containsKey(key22)) {
                Object object2;
                void key;
                void $receiver2;
                Map<LabelNode, DecompiledTryDescriptor> map2 = decompiledTryDescriptorForStart;
                Intrinsics.checkExpressionValueIsNotNull(tcb.start, "tcb.start");
                Object value2 = $receiver2.get(key);
                if (value2 == null && !$receiver2.containsKey(key)) {
                    LabelNode labelNode = tcb.start;
                    Intrinsics.checkExpressionValueIsNotNull(labelNode, "tcb.start");
                    DecompiledTryDescriptor answer = new DecompiledTryDescriptor(labelNode);
                    $receiver2.put(key, answer);
                    object2 = answer;
                } else {
                    object2 = value2;
                }
                DecompiledTryDescriptor answer = (DecompiledTryDescriptor)object2;
                $receiver.put(key22, answer);
                object = answer;
            } else {
                object = value;
            }
            DecompiledTryDescriptor decompiledTryDescriptor = (DecompiledTryDescriptor)object;
            $receiver = decompiledTryDescriptor;
            $receiver.getHandlerStartLabels().add(tcb.handler);
            if (!AnalyzeTryCatchBlocksKt.isDefaultHandlerNode(tcb)) continue;
            boolean key22 = $receiver.getDefaultHandlerTcb() == null;
            if (PreconditionsKt.getASSERTIONS_ENABLED()) {
                void value3;
                if (value3 == false) {
                    StringBuilder stringBuilder = new StringBuilder();
                    TryCatchBlockNode tryCatchBlockNode = tcb;
                    Intrinsics.checkExpressionValueIsNotNull(tryCatchBlockNode, "tcb");
                    StringBuilder stringBuilder2 = stringBuilder.append(AnalyzeTryCatchBlocksKt.debugString(methodNode, tryCatchBlockNode)).append(": default handler is already found: ");
                    TryCatchBlockNode tryCatchBlockNode2 = $receiver.getDefaultHandlerTcb();
                    if (tryCatchBlockNode2 == null) {
                        Intrinsics.throwNpe();
                    }
                    String message = stringBuilder2.append(AnalyzeTryCatchBlocksKt.debugString(methodNode, tryCatchBlockNode2)).toString();
                    throw (Throwable)((Object)new AssertionError((Object)message));
                }
                unit = Unit.INSTANCE;
            } else {
                unit = Unit.INSTANCE;
            }
            $receiver.setDefaultHandlerTcb(tcb);
        }
    }
}

