/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.util.rewriters;

import com.google.dart.compiler.backend.js.ast.JsContext;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsFunction;
import com.google.dart.compiler.backend.js.ast.JsFunctionScope;
import com.google.dart.compiler.backend.js.ast.JsLabel;
import com.google.dart.compiler.backend.js.ast.JsName;
import com.google.dart.compiler.backend.js.ast.JsVisitorWithContextImpl;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.inline.context.NamingContext;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"3\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!1!B\u0001\t\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\t\u00012B\u0003\u0002\u0019\u0005a\u0001!G\u0001\u0019\u0002\u0005V\u0011b\u0001\u0005\u0002\u001b\u0005A\u001a!C\u0002\t\u00055\t\u0001TA)\u0004\u0003!\u0019QE\u0004\u0003\f\u0011\u0017i\u0011\u0001\u0007\u0004\u001a\u0007!5Q\"\u0001\r\b3\u0015Ay!D\u0002\n\u0003\u0011\r\u0001\u0004C\u0013\u000f\t-A\t\"D\u0001\u0019\u0013e\u0019\u0001RB\u0007\u00021'IR\u0001c\u0004\u000e\u0007%\tA1\u0001\r\tK9!1\u0002#\u0005\u000e\u0003aI\u0011d\u0001E\u0007\u001b\u0005Ar!G\u0003\t\u00105\u0019\u0011\"\u0001C\u00021!I#\u0002B\"\t\u0011\u0005i\u0011\u0001g\u0001R\u0007\u0011)\u0001!\u0004\u0002\u0005\b!!\u0011F\u0003\u0003D\u0011!\u0011Q\"\u0001M\u0003#\u000e!Q\u0001A\u0007\u0003\t\u0013AQ\u0001"}, strings={"Lorg/jetbrains/kotlin/js/inline/util/rewriters/LabelNameRefreshingVisitor;", "Lcom/google/dart/compiler/backend/js/ast/JsVisitorWithContextImpl;", "context", "Lorg/jetbrains/kotlin/js/inline/context/NamingContext;", "functionScope", "Lcom/google/dart/compiler/backend/js/ast/JsFunctionScope;", "(Lorg/jetbrains/kotlin/js/inline/context/NamingContext;Lcom/google/dart/compiler/backend/js/ast/JsFunctionScope;)V", "getContext", "()Lorg/jetbrains/kotlin/js/inline/context/NamingContext;", "getFunctionScope", "()Lcom/google/dart/compiler/backend/js/ast/JsFunctionScope;", "endVisit", "", "x", "Lcom/google/dart/compiler/backend/js/ast/JsLabel;", "ctx", "Lcom/google/dart/compiler/backend/js/ast/JsContext;", "visit", "", "Lcom/google/dart/compiler/backend/js/ast/JsFunction;"}, moduleName="kotlin-compiler")
public final class LabelNameRefreshingVisitor
extends JsVisitorWithContextImpl {
    @NotNull
    private final NamingContext context;
    @NotNull
    private final JsFunctionScope functionScope;

    public boolean visit(@NotNull JsFunction x, @NotNull JsContext<?> ctx) {
        Intrinsics.checkParameterIsNotNull(x, "x");
        Intrinsics.checkParameterIsNotNull(ctx, "ctx");
        return false;
    }

    public boolean visit(@NotNull JsLabel x, @NotNull JsContext<?> ctx) {
        Intrinsics.checkParameterIsNotNull(x, "x");
        Intrinsics.checkParameterIsNotNull(ctx, "ctx");
        JsName labelName = x.getName();
        String string = labelName.getIdent();
        Intrinsics.checkExpressionValueIsNotNull(string, "labelName.getIdent()");
        JsName freshName = this.functionScope.enterLabel(string);
        if (Intrinsics.areEqual(freshName.getIdent(), labelName.getIdent()) ^ true) {
            JsName jsName = labelName;
            Intrinsics.checkExpressionValueIsNotNull(jsName, "labelName");
            JsExpression jsExpression = freshName.makeRef();
            Intrinsics.checkExpressionValueIsNotNull(jsExpression, "freshName.makeRef()");
            this.context.replaceName(jsName, jsExpression);
        }
        return super.visit(x, ctx);
    }

    public void endVisit(@NotNull JsLabel x, @NotNull JsContext<?> ctx) {
        Intrinsics.checkParameterIsNotNull(x, "x");
        Intrinsics.checkParameterIsNotNull(ctx, "ctx");
        super.endVisit(x, ctx);
        this.functionScope.exitLabel();
    }

    @NotNull
    public final NamingContext getContext() {
        return this.context;
    }

    @NotNull
    public final JsFunctionScope getFunctionScope() {
        return this.functionScope;
    }

    public LabelNameRefreshingVisitor(@NotNull NamingContext context, @NotNull JsFunctionScope functionScope) {
        Intrinsics.checkParameterIsNotNull(context, "context");
        Intrinsics.checkParameterIsNotNull(functionScope, "functionScope");
        this.context = context;
        this.functionScope = functionScope;
    }
}

