/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.intellij.psi.PsiElement;
import java.util.Iterator;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;

@KotlinFileFacade(version={1, 0, 0}, abiVersion=32, data={"\u001d\u0015\u0001Q!\u0001E\u0006\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ!\u0001\u0003\u0002\u000b\u0005A\u0011!B\u0001\r\u00035a\u0001\u0002A\u0007\u00021\u0003)\u0012\u0001G\u0001\u001a\n!\rQ\"\u0001\r\u0003!\u000e\u0005Ak!\u0002\u000e\u0019!\u0019Q\"\u0001M\u0004+\u0005AB!'\u0003\t\u00045\t\u0001D\u0001)\u0004\u0002Q\u001b)\u0001"}, strings={"checkNotEnumEntry", "", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "DeclarationsCheckerKt", "checkTypeReferences", "", "Lorg/jetbrains/kotlin/psi/KtDeclaration;"}, moduleName="kotlin-compiler")
public final class DeclarationsCheckerKt {
    public static final void checkTypeReferences(KtDeclaration $receiver, @NotNull BindingTrace trace) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        if ($receiver instanceof KtCallableDeclaration) {
            KtTypeReference ktTypeReference = ((KtCallableDeclaration)$receiver).getTypeReference();
            Boolean bl = ktTypeReference != null ? Boolean.valueOf(DeclarationsCheckerKt.checkNotEnumEntry(ktTypeReference, trace)) : null;
            KtTypeReference ktTypeReference2 = ((KtCallableDeclaration)$receiver).getReceiverTypeReference();
            Boolean bl2 = ktTypeReference2 != null ? Boolean.valueOf(DeclarationsCheckerKt.checkNotEnumEntry(ktTypeReference2, trace)) : null;
        }
        if ($receiver instanceof KtDeclarationWithBody) {
            for (KtParameter parameter : ((KtDeclarationWithBody)$receiver).getValueParameters()) {
                KtTypeReference ktTypeReference = parameter.getTypeReference();
                Boolean bl = ktTypeReference != null ? Boolean.valueOf(DeclarationsCheckerKt.checkNotEnumEntry(ktTypeReference, trace)) : null;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean checkNotEnumEntry(KtTypeReference $receiver, @NotNull BindingTrace trace) {
        void result2;
        Unit unit;
        Unit unit2;
        Object it2;
        Object $receiver2;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        Ref.BooleanRef booleanRef = new Ref.BooleanRef();
        booleanRef.element = false;
        KotlinType kotlinType = (KotlinType)trace.getBindingContext().get(BindingContext.TYPE, $receiver);
        if (kotlinType != null) {
            $receiver2 = kotlinType;
            it2 = $receiver2;
            ClassDescriptor targetDescriptor = TypeUtils.getClassDescriptor((KotlinType)it2);
            if (targetDescriptor != null && DescriptorUtils.isEnumEntry(targetDescriptor)) {
                trace.report(Errors.ENUM_ENTRY_AS_TYPE.on((KtTypeReference)((PsiElement)$receiver)));
                result2.element = true;
            }
            unit2 = Unit.INSTANCE;
        } else {
            unit2 = null;
        }
        KtTypeElement ktTypeElement = $receiver.getTypeElement();
        if (ktTypeElement != null) {
            $receiver2 = ktTypeElement;
            it2 = (KtTypeElement)$receiver2;
            Iterator<KtTypeReference> iterator2 = it2.getTypeArgumentsAsTypes().iterator();
            while (iterator2.hasNext()) {
                KtTypeReference typeArgument;
                KtTypeReference ktTypeReference = typeArgument = iterator2.next();
                Boolean bl = ktTypeReference != null ? Boolean.valueOf(DeclarationsCheckerKt.checkNotEnumEntry(ktTypeReference, trace)) : null;
            }
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return result2.element;
    }
}

