/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.inference;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.CollectionsKt;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystem;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemStatus;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemUtilsKt;
import org.jetbrains.kotlin.resolve.calls.inference.TypeBounds;
import org.jetbrains.kotlin.resolve.calls.inference.TypeVariable;
import org.jetbrains.kotlin.resolve.calls.inference.TypeVariableKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeIntersector;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;

public class ConstraintsUtil {
    @Nullable
    public static TypeVariable getFirstConflictingVariable(@NotNull ConstraintSystem constraintSystem) {
        if (constraintSystem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constraintSystem", "org/jetbrains/kotlin/resolve/calls/inference/ConstraintsUtil", "getFirstConflictingVariable"));
        }
        for (TypeVariable typeVariable : constraintSystem.getTypeVariables()) {
            TypeBounds constraints = constraintSystem.getTypeBounds(typeVariable);
            if (constraints.getValues().size() <= 1) continue;
            return typeVariable;
        }
        return null;
    }

    @NotNull
    public static Collection<TypeSubstitutor> getSubstitutorsForConflictingParameters(@NotNull ConstraintSystem constraintSystem) {
        if (constraintSystem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constraintSystem", "org/jetbrains/kotlin/resolve/calls/inference/ConstraintsUtil", "getSubstitutorsForConflictingParameters"));
        }
        TypeVariable firstConflictingVariable = ConstraintsUtil.getFirstConflictingVariable(constraintSystem);
        if (firstConflictingVariable == null) {
            List<TypeSubstitutor> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/inference/ConstraintsUtil", "getSubstitutorsForConflictingParameters"));
            }
            return list;
        }
        TypeParameterDescriptor firstConflictingParameter = firstConflictingVariable.getOriginalTypeParameter();
        Collection<KotlinType> conflictingTypes = constraintSystem.getTypeBounds(firstConflictingVariable).getValues();
        ArrayList substitutionContexts = Lists.newArrayList();
        for (KotlinType type2 : conflictingTypes) {
            LinkedHashMap<TypeConstructor, TypeProjectionImpl> linkedHashMap = Maps.newLinkedHashMap();
            linkedHashMap.put(firstConflictingParameter.getTypeConstructor(), new TypeProjectionImpl(type2));
            substitutionContexts.add(linkedHashMap);
        }
        for (TypeVariable typeVariable : constraintSystem.getTypeVariables()) {
            if (typeVariable == firstConflictingVariable) continue;
            KotlinType kotlinType = ConstraintsUtil.getSafeValue(constraintSystem, typeVariable);
            for (Map map2 : substitutionContexts) {
                TypeProjectionImpl typeProjection = new TypeProjectionImpl(kotlinType);
                map2.put(typeVariable.getOriginalTypeParameter().getTypeConstructor(), typeProjection);
            }
        }
        ArrayList<TypeSubstitutor> typeSubstitutors = new ArrayList<TypeSubstitutor>(substitutionContexts.size());
        for (Map map3 : substitutionContexts) {
            typeSubstitutors.add(TypeSubstitutor.create(map3));
        }
        ArrayList<TypeSubstitutor> arrayList = typeSubstitutors;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/inference/ConstraintsUtil", "getSubstitutorsForConflictingParameters"));
        }
        return arrayList;
    }

    @NotNull
    private static KotlinType getSafeValue(@NotNull ConstraintSystem constraintSystem, @NotNull TypeVariable typeVariable) {
        if (constraintSystem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constraintSystem", "org/jetbrains/kotlin/resolve/calls/inference/ConstraintsUtil", "getSafeValue"));
        }
        if (typeVariable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeVariable", "org/jetbrains/kotlin/resolve/calls/inference/ConstraintsUtil", "getSafeValue"));
        }
        KotlinType type2 = constraintSystem.getTypeBounds(typeVariable).getValue();
        if (type2 != null) {
            KotlinType kotlinType = type2;
            if (kotlinType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/inference/ConstraintsUtil", "getSafeValue"));
            }
            return kotlinType;
        }
        KotlinType kotlinType = TypeIntersector.getUpperBoundsAsType(typeVariable.getOriginalTypeParameter());
        if (kotlinType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/inference/ConstraintsUtil", "getSafeValue"));
        }
        return kotlinType;
    }

    public static boolean checkUpperBoundIsSatisfied(@NotNull ConstraintSystem constraintSystem, @NotNull TypeParameterDescriptor typeParameter, @NotNull Call call, boolean substituteOtherTypeParametersInBound) {
        if (constraintSystem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constraintSystem", "org/jetbrains/kotlin/resolve/calls/inference/ConstraintsUtil", "checkUpperBoundIsSatisfied"));
        }
        if (typeParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameter", "org/jetbrains/kotlin/resolve/calls/inference/ConstraintsUtil", "checkUpperBoundIsSatisfied"));
        }
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/kotlin/resolve/calls/inference/ConstraintsUtil", "checkUpperBoundIsSatisfied"));
        }
        TypeVariable typeVariable = ConstraintSystemUtilsKt.descriptorToVariable(constraintSystem, TypeVariableKt.toHandle(call), typeParameter);
        KotlinType type2 = constraintSystem.getTypeBounds(typeVariable).getValue();
        if (type2 == null) {
            return true;
        }
        List<TypeParameterDescriptor> typeParametersUsedInSystem = CollectionsKt.map(constraintSystem.getTypeVariables(), new Function1<TypeVariable, TypeParameterDescriptor>(){

            @Override
            public TypeParameterDescriptor invoke(TypeVariable variable) {
                return variable.getOriginalTypeParameter();
            }
        });
        for (KotlinType upperBound : typeParameter.getUpperBounds()) {
            if (!substituteOtherTypeParametersInBound && TypeUtils.dependsOnTypeParameters(upperBound, typeParametersUsedInSystem)) continue;
            KotlinType substitutedUpperBound = constraintSystem.getResultingSubstitutor().substitute(upperBound, Variance.INVARIANT);
            assert (substitutedUpperBound != null) : "We wanted to substitute projections as a result for " + typeParameter;
            if (KotlinTypeChecker.DEFAULT.isSubtypeOf(type2, substitutedUpperBound)) continue;
            return false;
        }
        return true;
    }

    public static String getDebugMessageForStatus(@NotNull ConstraintSystemStatus status2) {
        if (status2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "status", "org/jetbrains/kotlin/resolve/calls/inference/ConstraintsUtil", "getDebugMessageForStatus"));
        }
        StringBuilder sb = new StringBuilder();
        ArrayList<Method> interestingMethods = Lists.newArrayList();
        for (Method method : status2.getClass().getMethods()) {
            boolean isInteresting;
            String name = method.getName();
            boolean bl = isInteresting = name.startsWith("is") || name.startsWith("has") && !name.equals("hashCode");
            if (method.getParameterTypes().length != 0 || !isInteresting) continue;
            interestingMethods.add(method);
        }
        Collections.sort(interestingMethods, new Comparator<Method>(){

            @Override
            public int compare(@NotNull Method method1, @NotNull Method method2) {
                if (method1 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method1", "org/jetbrains/kotlin/resolve/calls/inference/ConstraintsUtil$2", "compare"));
                }
                if (method2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method2", "org/jetbrains/kotlin/resolve/calls/inference/ConstraintsUtil$2", "compare"));
                }
                return method1.getName().compareTo(method2.getName());
            }
        });
        Iterator iterator2 = interestingMethods.iterator();
        while (iterator2.hasNext()) {
            Method method = (Method)iterator2.next();
            try {
                sb.append("-").append(method.getName()).append(": ").append(method.invoke((Object)status2, new Object[0]));
                if (!iterator2.hasNext()) continue;
                sb.append("\n");
            }
            catch (IllegalAccessException e) {
                sb.append(e.getMessage());
            }
            catch (InvocationTargetException e) {
                sb.append(e.getMessage());
            }
        }
        return sb.toString();
    }
}

