/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.tasks;

import com.intellij.openapi.project.Project;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.TaskState;
import com.intellij.tasks.config.TaskRepositoryEditor;
import com.intellij.tasks.impl.BaseRepositoryType;
import com.intellij.util.Consumer;
import icons.TasksIcons;
import java.util.EnumSet;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.tasks.GithubRepository;
import org.jetbrains.plugins.github.tasks.GithubRepositoryEditor;

public class GithubRepositoryType
extends BaseRepositoryType<GithubRepository> {
    @NotNull
    public String getName() {
        if ("GitHub" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/tasks/GithubRepositoryType", "getName"));
        }
        return "GitHub";
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = TasksIcons.Github;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/tasks/GithubRepositoryType", "getIcon"));
        }
        return icon;
    }

    @NotNull
    public TaskRepository createRepository() {
        GithubRepository githubRepository = new GithubRepository(this);
        if (githubRepository == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/tasks/GithubRepositoryType", "createRepository"));
        }
        return githubRepository;
    }

    public Class<GithubRepository> getRepositoryClass() {
        return GithubRepository.class;
    }

    @NotNull
    public TaskRepositoryEditor createEditor(GithubRepository repository, Project project, Consumer<GithubRepository> changeListener) {
        GithubRepositoryEditor githubRepositoryEditor = new GithubRepositoryEditor(project, repository, changeListener);
        if (githubRepositoryEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/tasks/GithubRepositoryType", "createEditor"));
        }
        return githubRepositoryEditor;
    }

    public EnumSet<TaskState> getPossibleTaskStates() {
        return EnumSet.of(TaskState.OPEN, TaskState.RESOLVED);
    }
}

