/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.structure.gradle;

import com.android.builder.model.ApiVersion;
import com.android.ide.common.repository.GradleCoordinate;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.gradle.IdeaAndroidProject;
import com.android.tools.idea.templates.RepositoryUrlManager;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.xpath.XPath;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.model.MavenArtifactInfo;
import org.jetbrains.idea.maven.utils.MavenLog;

public class MavenDependencyLookupDialog
extends DialogWrapper {
    private static final String AAR_PACKAGING = "@aar";
    private static final String JAR_PACKAGING = "@jar";
    private static final int RESULT_LIMIT = 50;
    private static final String MAVEN_CENTRAL_SEARCH_URL = "https://search.maven.org/solrsearch/select?rows=%d&wt=xml&q=\"%s\"";
    private static final Logger LOG = Logger.getInstance(MavenDependencyLookupDialog.class);
    private static final List<Artifact> COMMON_LIBRARIES = ImmutableList.of((Object)((Object)new Artifact("com.google.code.gson", "gson", "2.2.4", "GSON")), (Object)((Object)new Artifact("joda-time", "joda-time", "2.3", "Joda-time")), (Object)((Object)new Artifact("com.squareup.picasso", "picasso", "2.3.2", "Picasso")), (Object)((Object)new Artifact("com.squareup", "otto", "1.3.5", "Otto")), (Object)((Object)new Artifact("org.slf4j", "slf4j-android", "1.7.7", "slf4j")), (Object)((Object)new Artifact("de.keyboardsurfer.android.widget", "crouton", "1.8.4", "Crouton")), (Object)((Object)new Artifact("com.nineoldandroids", "library", "2.4.0", "Nine Old Androids")), (Object)((Object)new Artifact("com.jakewharton", "butterknife", "5.1.1", "Butterknife")), (Object)((Object)new Artifact("com.google.guava", "guava", "16.0.1", "Guava")), (Object)((Object)new Artifact("com.squareup.okhttp", "okhttp", "2.0.0", "okhttp")), (Object)((Object)new Artifact("com.squareup.dagger", "dagger", "1.2.1", "Dagger")));
    private static final Map<String, String> SEARCH_OVERRIDES = ImmutableMap.builder().put((Object)"jodatime", (Object)"joda-time").put((Object)"slf4j", (Object)"org.slf4j:slf4j-android").put((Object)"slf4j-android", (Object)"org.slf4j:slf4j-android").put((Object)"animation", (Object)"com.nineoldandroids:library").put((Object)"pulltorefresh", (Object)"com.github.chrisbanes.actionbarpulltorefresh:library").put((Object)"wire", (Object)"wire-runtime").put((Object)"tape", (Object)"com.squareup:tape").put((Object)"annotations", (Object)"androidannotations").put((Object)"svg", (Object)"svg-android").put((Object)"commons", (Object)"org.apache.commons").build();
    private AsyncProcessIcon myProgressIcon;
    private TextFieldWithBrowseButton mySearchField;
    private JTextField mySearchTextField;
    private JPanel myPanel;
    private JBList myResultList;
    private final List<Artifact> myShownItems;
    private final ExecutorService mySearchWorker;
    private final boolean myAndroidModule;
    private final List<String> myAndroidSdkLibraries;

    public MavenDependencyLookupDialog(@NotNull Project project, @Nullable Module module) {
        ApiVersion minSdkVersion;
        IdeaAndroidProject androidProject;
        AndroidFacet facet;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/structure/gradle/MavenDependencyLookupDialog", "<init>"));
        }
        super(project, true);
        this.$$$setupUI$$$();
        this.myShownItems = Lists.newArrayList();
        this.mySearchWorker = Executors.newSingleThreadExecutor(ConcurrencyUtil.newNamedThreadFactory((String)"Maven dependency lookup"));
        this.myAndroidSdkLibraries = Lists.newArrayList();
        this.myAndroidModule = module != null && AndroidFacet.getInstance(module) != null;
        this.myProgressIcon.suspend();
        this.mySearchField.setButtonIcon(AllIcons.Actions.Menu_find);
        this.mySearchField.getButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MavenDependencyLookupDialog.this.startSearch();
            }
        });
        this.mySearchTextField = this.mySearchField.getTextField();
        this.mySearchTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (StringUtil.isEmpty((String)MavenDependencyLookupDialog.this.mySearchField.getText())) {
                    return;
                }
                if (!MavenDependencyLookupDialog.this.isValidCoordinateSelected()) {
                    MavenDependencyLookupDialog.this.startSearch();
                } else {
                    MavenDependencyLookupDialog.this.close(0);
                }
            }
        });
        boolean preview = false;
        if (module != null && (facet = AndroidFacet.getInstance(module)) != null && (androidProject = facet.getIdeaAndroidProject()) != null && (minSdkVersion = androidProject.getSelectedVariant().getMergedFlavor().getMinSdkVersion()) != null) {
            preview = new AndroidVersion(minSdkVersion.getApiLevel(), minSdkVersion.getCodename()).isPreview();
        }
        RepositoryUrlManager manager = RepositoryUrlManager.get();
        for (String libraryId : RepositoryUrlManager.EXTRAS_REPOSITORY.keySet()) {
            Artifact artifact;
            String libraryCoordinate = manager.getLibraryCoordinate(libraryId, null, preview);
            if (libraryCoordinate == null || (artifact = Artifact.fromCoordinate(libraryCoordinate, libraryId)) == null) continue;
            this.myAndroidSdkLibraries.add(libraryCoordinate);
            this.myShownItems.add(artifact);
        }
        this.myShownItems.addAll(COMMON_LIBRARIES);
        this.myResultList.setModel((ListModel)new CollectionComboBoxModel(this.myShownItems, null));
        this.myResultList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                Artifact value = (Artifact)((Object)MavenDependencyLookupDialog.this.myResultList.getSelectedValue());
                if (value != null) {
                    MavenDependencyLookupDialog.this.mySearchTextField.setText(value.getCoordinates());
                }
            }
        });
        this.myResultList.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2 && MavenDependencyLookupDialog.this.isValidCoordinateSelected()) {
                    MavenDependencyLookupDialog.this.close(0);
                }
            }
        });
        this.myOKAction = new DialogWrapper.OkAction(){

            protected void doAction(ActionEvent e) {
                String text = MavenDependencyLookupDialog.this.mySearchField.getText();
                if (text != null && !MavenDependencyLookupDialog.hasVersion(text) && RepositoryUrlManager.EXTRAS_REPOSITORY.containsKey(MavenDependencyLookupDialog.getArtifact(text))) {
                    MavenDependencyLookupDialog.this.mySearchField.setText(text + ':' + "0.0.+");
                }
                super.doAction(e);
            }
        };
        this.init();
    }

    private static String getArtifact(String coordinate) {
        int i = coordinate.indexOf(58);
        if (i >= 0 && i + 1 < coordinate.length()) {
            if ((i = (coordinate = coordinate.substring(i + 1)).indexOf(58)) < 0) {
                i = coordinate.length();
            }
            return coordinate.substring(0, i);
        }
        return null;
    }

    @NotNull
    public String getSearchText() {
        String string = this.mySearchTextField.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/structure/gradle/MavenDependencyLookupDialog", "getSearchText"));
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startSearch() {
        if (this.myProgressIcon.isRunning()) {
            return;
        }
        this.myProgressIcon.resume();
        List<Artifact> list = this.myShownItems;
        synchronized (list) {
            this.myResultList.clearSelection();
            this.myShownItems.clear();
            ((CollectionComboBoxModel)this.myResultList.getModel()).update();
        }
        String text = this.mySearchTextField.getText();
        if (StringUtil.isEmpty((String)text)) {
            return;
        }
        String override = SEARCH_OVERRIDES.get(text.toLowerCase(Locale.US));
        if (override != null) {
            text = override;
        }
        final String finalText = text;
        this.mySearchWorker.submit(new Runnable(){

            @Override
            public void run() {
                MavenDependencyLookupDialog.this.searchAllRepositories(finalText);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void searchAllRepositories(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/android/tools/idea/structure/gradle/MavenDependencyLookupDialog", "searchAllRepositories"));
        }
        try {
            if (!this.myProgressIcon.isRunning()) {
                return;
            }
            ArrayList results = Lists.newArrayList();
            results.addAll(MavenDependencyLookupDialog.searchMavenCentral(text));
            results.addAll(this.searchSdkRepositories(text));
            if (!this.myProgressIcon.isRunning()) {
                return;
            }
            List<Artifact> list = this.myShownItems;
            synchronized (list) {
                for (Object s : results) {
                    Artifact wrappedArtifact = Artifact.fromCoordinate((String)s, null);
                    if (this.myShownItems.contains((Object)wrappedArtifact)) continue;
                    this.myShownItems.add(wrappedArtifact);
                }
                Collections.sort(this.myShownItems, new ArtifactComparator(text));
                if (this.myAndroidModule) {
                    HashSet itemsToRemove = Sets.newHashSet();
                    for (Artifact art : this.myShownItems) {
                        String s = art.getCoordinates();
                        if (!s.endsWith(AAR_PACKAGING)) continue;
                        itemsToRemove.add(s.replace(AAR_PACKAGING, JAR_PACKAGING));
                    }
                    Iterator<Artifact> i = this.myShownItems.iterator();
                    while (i.hasNext()) {
                        Artifact art;
                        art = i.next();
                        if (!itemsToRemove.contains(art.getCoordinates())) continue;
                        i.remove();
                    }
                }
            }
            SwingUtilities.invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    List list = MavenDependencyLookupDialog.this.myShownItems;
                    synchronized (list) {
                        ((CollectionComboBoxModel)MavenDependencyLookupDialog.this.myResultList.getModel()).update();
                        if (MavenDependencyLookupDialog.this.myResultList.getSelectedIndex() == -1 && !MavenDependencyLookupDialog.this.myShownItems.isEmpty()) {
                            MavenDependencyLookupDialog.this.myResultList.setSelectedIndex(0);
                        }
                        if (!MavenDependencyLookupDialog.this.myShownItems.isEmpty()) {
                            MavenDependencyLookupDialog.this.myResultList.requestFocus();
                        }
                    }
                }
            });
        }
        catch (Exception e) {
            MavenLog.LOG.error((Throwable)e);
        }
        finally {
            this.myProgressIcon.suspend();
        }
    }

    @NotNull
    private List<String> searchSdkRepositories(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/android/tools/idea/structure/gradle/MavenDependencyLookupDialog", "searchSdkRepositories"));
        }
        ArrayList results = Lists.newArrayList();
        for (String library : this.myAndroidSdkLibraries) {
            if (!library.contains(text)) continue;
            results.add(library);
        }
        ArrayList arrayList = results;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/structure/gradle/MavenDependencyLookupDialog", "searchSdkRepositories"));
        }
        return arrayList;
    }

    @NotNull
    private static List<String> searchMavenCentral(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/android/tools/idea/structure/gradle/MavenDependencyLookupDialog", "searchMavenCentral"));
        }
        List list = (List)HttpRequests.request((String)String.format(MAVEN_CENTRAL_SEARCH_URL, 50, text)).accept("application/xml").connect((HttpRequests.RequestProcessor)new HttpRequests.RequestProcessor<List<String>>(){

            public List<String> process(@NotNull HttpRequests.Request request) throws IOException {
                if (request == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/android/tools/idea/structure/gradle/MavenDependencyLookupDialog$8", "process"));
                }
                try {
                    XPath idPath = XPath.newInstance((String)"str[@name='id']");
                    XPath versionPath = XPath.newInstance((String)"str[@name='latestVersion']");
                    List artifacts = XPath.newInstance((String)"/response/result/doc").selectNodes((Object)new SAXBuilder().build((Reader)request.getReader()));
                    ArrayList results = Lists.newArrayListWithExpectedSize((int)artifacts.size());
                    for (Element element : artifacts) {
                        try {
                            String id = ((Element)idPath.selectSingleNode((Object)element)).getValue();
                            results.add(id + ":" + ((Element)versionPath.selectSingleNode((Object)element)).getValue());
                        }
                        catch (NullPointerException nullPointerException) {}
                    }
                    return results;
                }
                catch (JDOMException e) {
                    LOG.error((Throwable)e);
                    return Collections.emptyList();
                }
            }
        }, Collections.emptyList(), LOG);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/structure/gradle/MavenDependencyLookupDialog", "searchMavenCentral"));
        }
        return list;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.mySearchTextField;
    }

    @Nullable
    protected ValidationInfo doValidate() {
        if (!this.isValidCoordinateSelected()) {
            return new ValidationInfo("Please enter a valid coordinate, discover it or select one from the list", this.getPreferredFocusedComponent());
        }
        return super.doValidate();
    }

    @NotNull
    protected JComponent createCenterPanel() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/structure/gradle/MavenDependencyLookupDialog", "createCenterPanel"));
        }
        return jPanel;
    }

    protected void dispose() {
        Disposer.dispose((Disposable)this.myProgressIcon);
        this.mySearchWorker.shutdown();
        super.dispose();
    }

    @NotNull
    protected String getDimensionServiceKey() {
        String string = MavenDependencyLookupDialog.class.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/structure/gradle/MavenDependencyLookupDialog", "getDimensionServiceKey"));
        }
        return string;
    }

    private boolean isValidCoordinateSelected() {
        String text = this.mySearchTextField.getText();
        return GradleCoordinate.parseCoordinateString((String)text) != null;
    }

    private void createUIComponents() {
        this.myProgressIcon = new AsyncProcessIcon("Progress");
    }

    public static boolean hasVersion(String coordinateText) {
        return StringUtil.countChars((CharSequence)coordinateText, (char)':') > 1;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBList jBList;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JPanel jPanel;
        this.createUIComponents();
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel).setEnabled(true);
        this.mySearchField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 0, 1, 1, 0, 1, 7, 3, null, null, null));
        AsyncProcessIcon asyncProcessIcon = this.myProgressIcon;
        jPanel.add((Component)asyncProcessIcon, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("<html>Enter terms for Maven Central search, or fully-qualified coordinates (e.g. <i>com.google.code.gson:gson:2.2.4</i>)</html>");
        jBLabel.setFontColor(UIUtil.FontColor.BRIGHTER);
        jBLabel.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        jPanel.add((Component)jBLabel, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 1, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jBScrollPane.setVerticalScrollBarPolicy(22);
        jBScrollPane.setHorizontalScrollBarPolicy(31);
        jPanel.add((Component)jBScrollPane, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 7, null, null, null));
        this.myResultList = jBList = new JBList();
        jBList.setSelectionMode(0);
        jBScrollPane.setViewportView((Component)jBList);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private static class ArtifactComparator
    implements Comparator<Artifact> {
        @NotNull
        private final String mySearchText;

        private ArtifactComparator(@NotNull String searchText) {
            if (searchText == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchText", "com/android/tools/idea/structure/gradle/MavenDependencyLookupDialog$ArtifactComparator", "<init>"));
            }
            this.mySearchText = searchText;
        }

        @Override
        public int compare(@NotNull Artifact artifact1, @NotNull Artifact artifact2) {
            if (artifact1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact1", "com/android/tools/idea/structure/gradle/MavenDependencyLookupDialog$ArtifactComparator", "compare"));
            }
            if (artifact2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact2", "com/android/tools/idea/structure/gradle/MavenDependencyLookupDialog$ArtifactComparator", "compare"));
            }
            int score = ArtifactComparator.calculateScore(this.mySearchText, artifact2) - ArtifactComparator.calculateScore(this.mySearchText, artifact1);
            if (score != 0) {
                return score;
            }
            return artifact2.getVersion().compareTo(artifact1.getVersion());
        }

        private static int calculateScore(@NotNull String searchText, @NotNull MavenArtifactInfo artifact) {
            if (searchText == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchText", "com/android/tools/idea/structure/gradle/MavenDependencyLookupDialog$ArtifactComparator", "calculateScore"));
            }
            if (artifact == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "com/android/tools/idea/structure/gradle/MavenDependencyLookupDialog$ArtifactComparator", "calculateScore"));
            }
            int score = 0;
            if (artifact.getArtifactId().equals(searchText)) {
                ++score;
            }
            if (artifact.getArtifactId().contains(searchText)) {
                ++score;
            }
            if (artifact.getGroupId().contains(searchText)) {
                ++score;
            }
            return score;
        }
    }

    private static class Artifact
    extends MavenArtifactInfo {
        private final String myDescription;

        public Artifact(@NotNull String groupId, @NotNull String artifactId, @NotNull String version, @Nullable String description) {
            if (groupId == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupId", "com/android/tools/idea/structure/gradle/MavenDependencyLookupDialog$Artifact", "<init>"));
            }
            if (artifactId == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifactId", "com/android/tools/idea/structure/gradle/MavenDependencyLookupDialog$Artifact", "<init>"));
            }
            if (version == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/android/tools/idea/structure/gradle/MavenDependencyLookupDialog$Artifact", "<init>"));
            }
            super(groupId, artifactId, version, null, null, null, null);
            this.myDescription = description;
        }

        @Nullable
        public static Artifact fromCoordinate(@NotNull String libraryCoordinate, @Nullable String libraryId) {
            if (libraryCoordinate == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryCoordinate", "com/android/tools/idea/structure/gradle/MavenDependencyLookupDialog$Artifact", "fromCoordinate"));
            }
            GradleCoordinate gradleCoordinate = GradleCoordinate.parseCoordinateString((String)libraryCoordinate);
            if (gradleCoordinate == null) {
                return null;
            }
            String groupId = gradleCoordinate.getGroupId();
            String artifactId = gradleCoordinate.getArtifactId();
            if (groupId == null || artifactId == null) {
                return null;
            }
            return new Artifact(groupId, artifactId, gradleCoordinate.getFullRevision(), libraryId);
        }

        @NotNull
        public String toString() {
            if (this.myDescription != null) {
                String string = this.myDescription + " (" + this.getCoordinates() + ")";
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/structure/gradle/MavenDependencyLookupDialog$Artifact", "toString"));
                }
                return string;
            }
            String string = this.getCoordinates();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/structure/gradle/MavenDependencyLookupDialog$Artifact", "toString"));
            }
            return string;
        }

        @NotNull
        public String getCoordinates() {
            String version = "0.0.+".equals(this.getVersion()) ? "" : ':' + this.getVersion();
            String string = this.getGroupId() + ":" + this.getArtifactId() + version;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/structure/gradle/MavenDependencyLookupDialog$Artifact", "getCoordinates"));
            }
            return string;
        }
    }
}

