/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.structure.services;

import com.android.tools.idea.gradle.parser.BuildFileStatement;
import com.android.tools.idea.gradle.parser.Dependency;
import com.android.tools.idea.gradle.parser.GradleBuildFile;
import com.android.tools.idea.structure.services.DeveloperServiceMetadata;
import com.android.tools.idea.structure.services.ServiceCategory;
import com.android.tools.idea.structure.services.ServiceContext;
import com.android.tools.idea.structure.services.ServicePanelBuilder;
import com.android.tools.idea.templates.FreemarkerConfiguration;
import com.android.tools.idea.templates.FreemarkerUtils;
import com.android.tools.idea.templates.PrefixTemplateLoader;
import com.android.tools.idea.templates.TemplateUtils;
import com.android.tools.idea.templates.TypedVariable;
import com.android.tools.idea.templates.parse.SaxUtils;
import com.android.tools.idea.templates.recipe.Recipe;
import com.android.tools.idea.templates.recipe.RecipeContext;
import com.android.tools.idea.ui.properties.Observable;
import com.android.tools.idea.ui.properties.ObservableValue;
import com.android.tools.idea.ui.properties.collections.ObservableList;
import com.android.tools.idea.ui.properties.core.BoolProperty;
import com.android.tools.idea.ui.properties.core.IntProperty;
import com.android.tools.idea.ui.properties.core.StringProperty;
import com.android.tools.idea.ui.properties.expressions.bool.BooleanExpression;
import com.android.tools.idea.ui.properties.expressions.integer.IntExpression;
import com.android.tools.idea.ui.properties.expressions.string.StringExpression;
import com.android.tools.idea.ui.properties.swing.EnabledProperty;
import com.android.tools.idea.ui.properties.swing.SelectedIndexProperty;
import com.android.tools.idea.ui.properties.swing.SelectedProperty;
import com.android.tools.idea.ui.properties.swing.TextProperty;
import com.android.tools.idea.ui.properties.swing.VisibleProperty;
import com.google.common.base.CaseFormat;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.util.containers.Stack;
import freemarker.template.TemplateException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.xml.bind.JAXBException;
import org.jetbrains.annotations.NotNull;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

final class ServiceXmlParser
extends DefaultHandler {
    private static final Logger LOG = Logger.getInstance(ServiceXmlParser.class);
    private static final int CURRENT_FORMAT = 1;
    private static final Pattern VAR_PATTERN = Pattern.compile("^\\$\\{(.+)\\}$");
    private static final Pattern ACTION_PATTERN = Pattern.compile("^\\$\\{(.+)\\(\\)\\}$");
    @NotNull
    private final Module myModule;
    @NotNull
    private final File myRootPath;
    @NotNull
    private final ServiceContext myContext;
    @NotNull
    private final Stack<String> myTagStack;
    @NotNull
    private ServicePanelBuilder myPanelBuilder;
    @NotNull
    private ServiceCategory myServiceCategory;
    @NotNull
    private DeveloperServiceMetadata myDeveloperServiceMetadata;
    @NotNull
    private File myRecipeFile;

    public ServiceXmlParser(@NotNull Module module, @NotNull File rootPath, @NotNull ServiceContext serviceContext) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/structure/services/ServiceXmlParser", "<init>"));
        }
        if (rootPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootPath", "com/android/tools/idea/structure/services/ServiceXmlParser", "<init>"));
        }
        if (serviceContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serviceContext", "com/android/tools/idea/structure/services/ServiceXmlParser", "<init>"));
        }
        this.myTagStack = new Stack();
        this.myModule = module;
        this.myRootPath = rootPath;
        this.myContext = serviceContext;
        this.myPanelBuilder = new ServicePanelBuilder();
    }

    @NotNull
    private static URI toUri(@NotNull String urlString) {
        URI uRI;
        block3: {
            if (urlString == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "urlString", "com/android/tools/idea/structure/services/ServiceXmlParser", "toUri"));
            }
            try {
                uRI = new URI(urlString);
                if (uRI != null) break block3;
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(String.format("Malformed link argument: %1$s", urlString), e);
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/structure/services/ServiceXmlParser", "toUri"));
        }
        return uRI;
    }

    @NotNull
    public Module getModule() {
        Module module = this.myModule;
        if (module == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/structure/services/ServiceXmlParser", "getModule"));
        }
        return module;
    }

    @NotNull
    public ServiceContext getContext() {
        ServiceContext serviceContext = this.myContext;
        if (serviceContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/structure/services/ServiceXmlParser", "getContext"));
        }
        return serviceContext;
    }

    public DeveloperServiceMetadata getDeveloperServiceMetadata() {
        return this.myDeveloperServiceMetadata;
    }

    public ServiceCategory getServiceCategory() {
        return this.myServiceCategory;
    }

    public JPanel getServicePanel() {
        return this.myPanelBuilder.getPanel();
    }

    @Override
    public void startElement(String uri, String localName, @NotNull String tagName, @NotNull Attributes attributes) throws SAXException {
        if (tagName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tagName", "com/android/tools/idea/structure/services/ServiceXmlParser", "startElement"));
        }
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/android/tools/idea/structure/services/ServiceXmlParser", "startElement"));
        }
        this.myTagStack.push((Object)tagName);
        if (tagName.equals("service")) {
            this.parseServiceTag(attributes);
        } else if (tagName.equals("uiGrid")) {
            this.parseUiGridTag(attributes);
        } else if (tagName.equals("uiItem")) {
            this.parseUiItemTag(attributes);
        } else {
            LOG.warn("WARNING: Unknown service directive " + tagName);
        }
    }

    @Override
    public void endElement(String uri, String localName, @NotNull String tagName) throws SAXException {
        if (tagName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tagName", "com/android/tools/idea/structure/services/ServiceXmlParser", "endElement"));
        }
        if (tagName.equals("service")) {
            this.closeServiceTag();
        } else if (tagName.equals("uiGrid")) {
            this.closeUiGridTag();
        }
        this.myTagStack.pop();
    }

    @NotNull
    public Recipe createRecipe(boolean executeRecipe) {
        Recipe recipe;
        FreemarkerConfiguration freemarker = new FreemarkerConfiguration();
        PrefixTemplateLoader loader = new PrefixTemplateLoader(this.myRootPath.getPath());
        Map<String, Object> paramMap = FreemarkerUtils.createParameterMap(this.myContext.toValueMap());
        try {
            freemarker.setTemplateLoader(loader);
            String xml = FreemarkerUtils.processFreemarkerTemplate(freemarker, paramMap, this.myRecipeFile);
            Recipe recipe2 = Recipe.parse(new StringReader(xml));
            if (executeRecipe) {
                RecipeContext recipeContext = new RecipeContext(this.myModule, loader, freemarker, paramMap, this.myRootPath, false);
                recipe2.execute(recipeContext);
                List<File> relFilesToOpen = recipe2.getFilesToOpen();
                ArrayList absFilesToOpen = Lists.newArrayListWithCapacity((int)relFilesToOpen.size());
                for (File file : relFilesToOpen) {
                    absFilesToOpen.add(recipeContext.getTargetFile(file));
                }
                TemplateUtils.openEditors(this.myModule.getProject(), absFilesToOpen, true);
            }
            recipe = recipe2;
        }
        catch (TemplateException e) {
            throw new RuntimeException(e);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (recipe == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/structure/services/ServiceXmlParser", "createRecipe"));
        }
        return recipe;
    }

    private void parseServiceTag(@NotNull Attributes attributes) {
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/android/tools/idea/structure/services/ServiceXmlParser", "parseServiceTag"));
        }
        String format = this.requireAttr(attributes, "format");
        try {
            if (Integer.parseInt(format) > 1) {
                throw new RuntimeException(String.format("Definition found with format %1$s newer than newest known format %2$s", format, 1));
            }
        }
        catch (NumberFormatException e) {
            throw new RuntimeException(String.format("Non-numeric value passed to format attribute: %1$s", format));
        }
        String name = this.requireAttr(attributes, "name");
        String description = this.requireAttr(attributes, "description");
        String category = this.requireAttr(attributes, "category");
        File iconFile = new File(this.myRootPath, this.requireAttr(attributes, "icon"));
        String learnLink = attributes.getValue("learnMore");
        String apiLink = attributes.getValue("apiDocs");
        this.myRecipeFile = new File(this.myRootPath, this.requireAttr(attributes, "execute"));
        try {
            this.myServiceCategory = ServiceCategory.valueOf(CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, category));
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(String.format("Invalid category %1$s, should be one of %2$s", category, Arrays.toString((Object[])ServiceCategory.values())));
        }
        ImageIcon icon = new ImageIcon(iconFile.getPath());
        this.myDeveloperServiceMetadata = new DeveloperServiceMetadata(name, description, icon);
        if (learnLink != null) {
            this.myDeveloperServiceMetadata.setLearnMoreLink(ServiceXmlParser.toUri(learnLink));
        }
        if (apiLink != null) {
            this.myDeveloperServiceMetadata.setApiLink(ServiceXmlParser.toUri(apiLink));
        }
    }

    private void closeServiceTag() {
        Recipe recipe = this.createRecipe(false);
        for (String d : recipe.getDependencies()) {
            this.myDeveloperServiceMetadata.addDependency(d);
        }
        for (File f : recipe.getFilesToModify()) {
            this.myDeveloperServiceMetadata.addModifiedFile(f);
        }
        ArrayList moduleDependencyNames = Lists.newArrayList();
        GradleBuildFile gradleBuildFile = GradleBuildFile.get(this.myModule);
        if (gradleBuildFile != null) {
            for (BuildFileStatement dependency : gradleBuildFile.getDependencies()) {
                Object data;
                if (!(dependency instanceof Dependency) || !((data = ((Dependency)dependency).data) instanceof String)) continue;
                String dependencyString = (String)data;
                ArrayList dependencyParts = Lists.newArrayList((Iterable)Splitter.on((char)':').split((CharSequence)dependencyString));
                if (dependencyParts.size() != 3) continue;
                moduleDependencyNames.add(dependencyParts.get(1));
            }
        }
        boolean allDependenciesFound = true;
        for (String serviceDependency : this.myDeveloperServiceMetadata.getDependencies()) {
            boolean thisDependencyFound = false;
            for (String moduleDependencyName : moduleDependencyNames) {
                if (!serviceDependency.contains(moduleDependencyName)) continue;
                thisDependencyFound = true;
                break;
            }
            if (thisDependencyFound) continue;
            allDependenciesFound = false;
            break;
        }
        this.myContext.installed().set(allDependenciesFound);
        this.myContext.snapshot();
    }

    private void parseUiGridTag(@NotNull Attributes attributes) {
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/android/tools/idea/structure/services/ServiceXmlParser", "parseUiGridTag"));
        }
        this.parseGridCoords(attributes);
        String weights = this.requireAttr(attributes, "colDefinitions");
        JPanel grid = this.myPanelBuilder.startGrid(weights);
        this.bindComponentProperties(grid, attributes);
    }

    private void closeUiGridTag() {
        this.myPanelBuilder.endGrid();
    }

    private void parseUiItemTag(@NotNull Attributes attributes) {
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/android/tools/idea/structure/services/ServiceXmlParser", "parseUiItemTag"));
        }
        this.parseGridCoords(attributes);
        String type = this.requireAttr(attributes, "type");
        if (type.equals("button")) {
            JButton button = this.myPanelBuilder.addButton();
            this.bindButtonProperties(button, attributes);
            this.bindComponentProperties(button, attributes);
        } else if (type.equals("checkbox")) {
            JCheckBox checkbox = this.myPanelBuilder.addCheckbox();
            this.bindComponentProperties(checkbox, attributes);
            this.bindCheckboxProperties(checkbox, attributes);
        } else if (type.equals("input")) {
            JTextField field = this.myPanelBuilder.addField();
            this.bindComponentProperties(field, attributes);
            this.bindFieldProperties(field, attributes);
        } else if (type.equals("label")) {
            JLabel label = this.myPanelBuilder.addLabel();
            this.bindComponentProperties(label, attributes);
            this.bindLabelProperties(label, attributes);
        } else if (type.equals("link")) {
            HyperlinkLabel link = this.myPanelBuilder.addLink(this.requireAttr(attributes, "text"), ServiceXmlParser.toUri(this.requireAttr(attributes, "url")));
            this.bindComponentProperties((JComponent)link, attributes);
        } else if (type.equals("pulldown")) {
            String listKey = this.requireAttr(attributes, "list");
            ObservableList<String> backingList = this.getList(listKey);
            JComboBox comboBox = this.myPanelBuilder.addComboBox(backingList);
            this.bindComponentProperties(comboBox, attributes);
            this.bindComboBoxProperties(comboBox, attributes);
        }
    }

    private void parseGridCoords(@NotNull Attributes attributes) {
        String col;
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/android/tools/idea/structure/services/ServiceXmlParser", "parseGridCoords"));
        }
        String row = attributes.getValue("row");
        if (row != null) {
            this.myPanelBuilder.setRow(Integer.parseInt(row));
        }
        if ((col = attributes.getValue("col")) != null) {
            this.myPanelBuilder.setCol(Integer.parseInt(col));
        }
    }

    private void bindButtonProperties(@NotNull JButton button, @NotNull Attributes attributes) {
        String actionKey;
        if (button == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "button", "com/android/tools/idea/structure/services/ServiceXmlParser", "bindButtonProperties"));
        }
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/android/tools/idea/structure/services/ServiceXmlParser", "bindButtonProperties"));
        }
        String textKey = attributes.getValue("text");
        if (textKey != null) {
            TextProperty textProperty = new TextProperty(button);
            this.myPanelBuilder.getBindings().bind(textProperty, this.parseString(textKey));
        }
        if ((actionKey = attributes.getValue("action")) != null) {
            final Runnable action = this.parseAction(actionKey);
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    action.run();
                }
            });
        }
    }

    private void bindComponentProperties(@NotNull JComponent component, @NotNull Attributes attributes) {
        String enabledKey;
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/structure/services/ServiceXmlParser", "bindComponentProperties"));
        }
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/android/tools/idea/structure/services/ServiceXmlParser", "bindComponentProperties"));
        }
        String visibleKey = attributes.getValue("visible");
        if (visibleKey != null) {
            VisibleProperty visibleProperty = new VisibleProperty(component);
            this.myPanelBuilder.getBindings().bind(visibleProperty, this.parseBool(visibleKey));
        }
        if ((enabledKey = attributes.getValue("enabled")) != null) {
            EnabledProperty enabledProperty = new EnabledProperty(component);
            this.myPanelBuilder.getBindings().bind(enabledProperty, this.parseBool(enabledKey));
        }
    }

    private void bindCheckboxProperties(@NotNull JCheckBox checkbox, @NotNull Attributes attributes) {
        String checkedKey;
        if (checkbox == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checkbox", "com/android/tools/idea/structure/services/ServiceXmlParser", "bindCheckboxProperties"));
        }
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/android/tools/idea/structure/services/ServiceXmlParser", "bindCheckboxProperties"));
        }
        String textKey = attributes.getValue("text");
        if (textKey != null) {
            TextProperty textProperty = new TextProperty(checkbox);
            this.myPanelBuilder.getBindings().bind(textProperty, this.parseString(textKey));
        }
        if ((checkedKey = attributes.getValue("checked")) != null) {
            SelectedProperty selectedProperty = new SelectedProperty(checkbox);
            BoolProperty checkedValue = (BoolProperty)this.parseBool(checkedKey);
            this.myPanelBuilder.getBindings().bindTwoWay(selectedProperty, checkedValue);
        }
    }

    private void bindComboBoxProperties(@NotNull JComboBox comboBox, @NotNull Attributes attributes) {
        if (comboBox == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comboBox", "com/android/tools/idea/structure/services/ServiceXmlParser", "bindComboBoxProperties"));
        }
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/android/tools/idea/structure/services/ServiceXmlParser", "bindComboBoxProperties"));
        }
        String indexKey = attributes.getValue("index");
        if (indexKey != null) {
            SelectedIndexProperty indexProperty = new SelectedIndexProperty(comboBox);
            IntProperty indexValue = (IntProperty)this.parseInt(indexKey);
            this.myPanelBuilder.getBindings().bindTwoWay(indexProperty, indexValue);
        }
    }

    private void bindFieldProperties(@NotNull JTextField field, @NotNull Attributes attributes) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/android/tools/idea/structure/services/ServiceXmlParser", "bindFieldProperties"));
        }
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/android/tools/idea/structure/services/ServiceXmlParser", "bindFieldProperties"));
        }
        String textKey = attributes.getValue("text");
        if (textKey != null) {
            TextProperty textProperty = new TextProperty(field);
            StringProperty textValue = (StringProperty)this.parseString(textKey);
            this.myPanelBuilder.getBindings().bindTwoWay(textProperty, textValue);
        }
    }

    private void bindLabelProperties(@NotNull JLabel label, @NotNull Attributes attributes) {
        if (label == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "label", "com/android/tools/idea/structure/services/ServiceXmlParser", "bindLabelProperties"));
        }
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/android/tools/idea/structure/services/ServiceXmlParser", "bindLabelProperties"));
        }
        String textKey = attributes.getValue("text");
        if (textKey != null) {
            TextProperty textProperty = new TextProperty(label);
            this.myPanelBuilder.getBindings().bind(textProperty, this.parseString(textKey));
        }
    }

    @NotNull
    private Runnable parseAction(String value) {
        Matcher matcher = ACTION_PATTERN.matcher(value);
        if (matcher.find()) {
            String varName = matcher.group(1);
            Runnable runnable = this.myContext.getAction(varName);
            if (runnable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/structure/services/ServiceXmlParser", "parseAction"));
            }
            return runnable;
        }
        throw new RuntimeException("Invalid action value (did you forget ${...()}): " + value);
    }

    @NotNull
    private ObservableValue<Boolean> parseBool(@NotNull String value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/structure/services/ServiceXmlParser", "parseBool"));
        }
        Matcher matcher = VAR_PATTERN.matcher(value);
        if (matcher.find()) {
            String varName = matcher.group(1);
            ObservableValue observableValue = (ObservableValue)this.myContext.getValue(varName);
            if (observableValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/structure/services/ServiceXmlParser", "parseBool"));
            }
            return observableValue;
        }
        final Boolean boolValue = (Boolean)TypedVariable.parse(TypedVariable.Type.BOOLEAN, value);
        if (boolValue == null) {
            throw new RuntimeException("Invalid bool value (did you forget ${...}): " + value);
        }
        BooleanExpression booleanExpression = new BooleanExpression(new Observable[0]){

            @Override
            @NotNull
            public Boolean get() {
                Boolean bl = boolValue;
                if (bl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/structure/services/ServiceXmlParser$2", "get"));
                }
                return bl;
            }
        };
        if (booleanExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/structure/services/ServiceXmlParser", "parseBool"));
        }
        return booleanExpression;
    }

    @NotNull
    private ObservableValue<String> parseString(final @NotNull String value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/structure/services/ServiceXmlParser", "parseString"));
        }
        Matcher matcher = VAR_PATTERN.matcher(value);
        if (matcher.find()) {
            String varName = matcher.group(1);
            ObservableValue observableValue = (ObservableValue)this.myContext.getValue(varName);
            if (observableValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/structure/services/ServiceXmlParser", "parseString"));
            }
            return observableValue;
        }
        StringExpression stringExpression = new StringExpression(new Observable[0]){

            @Override
            @NotNull
            public String get() {
                String string = value;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/structure/services/ServiceXmlParser$3", "get"));
                }
                return string;
            }
        };
        if (stringExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/structure/services/ServiceXmlParser", "parseString"));
        }
        return stringExpression;
    }

    @NotNull
    private ObservableValue<Integer> parseInt(@NotNull String value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/structure/services/ServiceXmlParser", "parseInt"));
        }
        Matcher matcher = VAR_PATTERN.matcher(value);
        if (matcher.find()) {
            String varName = matcher.group(1);
            ObservableValue observableValue = (ObservableValue)this.myContext.getValue(varName);
            if (observableValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/structure/services/ServiceXmlParser", "parseInt"));
            }
            return observableValue;
        }
        final Integer intValue = (Integer)TypedVariable.parse(TypedVariable.Type.INTEGER, value);
        if (intValue == null) {
            throw new RuntimeException("Invalid integer value (did you forget ${...}): " + value);
        }
        IntExpression intExpression = new IntExpression(new Observable[0]){

            @Override
            @NotNull
            public Integer get() {
                Integer n = intValue;
                if (n == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/structure/services/ServiceXmlParser$4", "get"));
                }
                return n;
            }
        };
        if (intExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/structure/services/ServiceXmlParser", "parseInt"));
        }
        return intExpression;
    }

    @NotNull
    private <E> ObservableList<E> getList(@NotNull String value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/structure/services/ServiceXmlParser", "getList"));
        }
        Matcher matcher = VAR_PATTERN.matcher(value);
        if (matcher.find()) {
            String varName = matcher.group(1);
            ObservableList observableList = (ObservableList)this.myContext.getValue(varName);
            if (observableList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/structure/services/ServiceXmlParser", "getList"));
            }
            return observableList;
        }
        throw new RuntimeException("Invalid list value (did you forget ${...}): " + value);
    }

    private String requireAttr(@NotNull Attributes attributes, @NotNull String attrFormat) {
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/android/tools/idea/structure/services/ServiceXmlParser", "requireAttr"));
        }
        if (attrFormat == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attrFormat", "com/android/tools/idea/structure/services/ServiceXmlParser", "requireAttr"));
        }
        return SaxUtils.requireAttr((String)this.myTagStack.peek(), attributes, attrFormat);
    }

    private static final class Schema {
        private Schema() {
        }

        public static final class UiItem
        extends UiTag {
            public static final String TAG = "uiItem";
            public static final String ATTR_TYPE = "type";

            public static final class Type {
                public static final String VALUE_BUTTON = "button";
                public static final String VALUE_CHECKBOX = "checkbox";
                public static final String VALUE_INPUT = "input";
                public static final String VALUE_LABEL = "label";
                public static final String VALUE_LINK = "link";
                public static final String VALUE_PULLDOWN = "pulldown";

                public static final class Pulldown {
                    public static final String ATTR_LIST = "list";
                    public static final String ATTR_INDEX = "index";
                }

                public static final class Text {
                    public static final String ATTR_TEXT = "text";
                }

                public static final class Link {
                    public static final String ATTR_URL = "url";
                }

                public static final class CheckBox {
                    public static final String ATTR_CHECKED = "checked";
                }

                public static final class Button {
                    public static final String ATTR_ACTION = "action";
                }

                public static final class Component {
                    public static final String ATTR_ENABLED = "enabled";
                    public static final String ATTR_VISIBLE = "visible";
                }
            }
        }

        public static final class UiGrid
        extends UiTag {
            public static final String TAG = "uiGrid";
            public static final String ATTR_COL_DEFINITIONS = "colDefinitions";
        }

        public static class UiTag {
            public static final String ATTR_COL = "col";
            public static final String ATTR_ROW = "row";
        }

        public static final class Service {
            public static final String TAG = "service";
            public static final String ATTR_API_DOCS = "apiDocs";
            public static final String ATTR_CATEGORY = "category";
            public static final String ATTR_DESCRIPTION = "description";
            public static final String ATTR_EXECUTE = "execute";
            public static final String ATTR_FORMAT = "format";
            public static final String ATTR_ICON = "icon";
            public static final String ATTR_INITIALIZE = "initialize";
            public static final String ATTR_LEARN_MORE = "learnMore";
            public static final String ATTR_MIN_API = "minApi";
            public static final String ATTR_NAME = "name";
        }
    }
}

