/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jps.incremental;

import com.google.protobuf.MessageLite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.CollectionsKt;
import kotlin.PreconditionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.jps.incremental.DifferenceCalculator;
import org.jetbrains.kotlin.jps.incremental.DifferenceCalculatorForClass;
import org.jetbrains.kotlin.jps.incremental.DifferenceCalculatorForPackageFacade;
import org.jetbrains.kotlin.jps.incremental.DifferenceKind;
import org.jetbrains.kotlin.jps.incremental.storage.ProtoMapValue;
import org.jetbrains.kotlin.serialization.Flags;
import org.jetbrains.kotlin.serialization.ProtoBuf;
import org.jetbrains.kotlin.serialization.deserialization.Deserialization;
import org.jetbrains.kotlin.serialization.deserialization.NameResolver;

@KotlinFileFacade(version={1, 0, 0}, abiVersion=32, data={"-\u0015\u0001Q!\u0001E\u0006\u000b\u0005a\u0011!B\u0001\u0005\u0004\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!B\u0001\u0005\u0003\u0015\t\u0001bB\u0003\u0001\u000b\u0005a\u0011!\u0002\u0001\u0006\u0003!\u0001R\u0012\u0004E\u0003\u001b\u0005A2!G\u0002\t\b5\t\u0001\u0004B\r\u0004\u0011\u0013i\u0011\u0001\u0007\u0003U\u0007\tiQ\u0002B\u0001\t\u000b5\t\u00014B\u000b\u00021\u0005IJ\u0001\u0003\u0004\u000e\u0003a5\u0001k!\u0001U\u0007\ti1\u0003\u0002\u0001\t\u000f5!\u0011BA\u0005\u00021\u0017Az!\u0006\u0003\n\u0005%\t\u0001$\u0001M\b3\u0013Aa!D\u0001\u0019\u000eA\u001b\t\u0001V\u0002\u0003#7!\u0001\t\u0003\u0005\u0001\u001b\u0005A\n!F\u0001\u0019\u0003q\u0001\u0013kA\u0002\u000e\u0005\u0011\u0001\u00012\u0001+\u0004\u0005\u0001"}, strings={"isPrivate", "", "Lcom/google/protobuf/MessageLite;", "(Lcom/google/protobuf/MessageLite;)Z", "ProtoDifferenceUtilsKt", "difference", "Lorg/jetbrains/kotlin/jps/incremental/DifferenceKind;", "oldData", "Lorg/jetbrains/kotlin/jps/incremental/storage/ProtoMapValue;", "newData", "name", "", "nameResolver", "Lorg/jetbrains/kotlin/serialization/deserialization/NameResolver;", "names", ""}, moduleName="jps-plugin")
public final class ProtoDifferenceUtilsKt {
    @NotNull
    public static final DifferenceKind difference(@NotNull ProtoMapValue oldData, @NotNull ProtoMapValue newData) {
        Intrinsics.checkParameterIsNotNull((Object)oldData, (String)"oldData");
        Intrinsics.checkParameterIsNotNull((Object)newData, (String)"newData");
        if (oldData.isPackageFacade() != newData.isPackageFacade()) {
            return DifferenceKind.CLASS_SIGNATURE.INSTANCE;
        }
        DifferenceCalculator differenceObject = oldData.isPackageFacade() ? (DifferenceCalculator)new DifferenceCalculatorForPackageFacade(oldData, newData) : (DifferenceCalculator)new DifferenceCalculatorForClass(oldData, newData);
        return differenceObject.difference();
    }

    public static final boolean isPrivate(MessageLite $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        MessageLite messageLite = $receiver;
        return Visibilities.isPrivate((Visibility)Deserialization.visibility(messageLite instanceof ProtoBuf.Constructor ? Flags.VISIBILITY.get(((ProtoBuf.Constructor)$receiver).getFlags()) : (messageLite instanceof ProtoBuf.Function ? Flags.VISIBILITY.get(((ProtoBuf.Function)$receiver).getFlags()) : (messageLite instanceof ProtoBuf.Property ? Flags.VISIBILITY.get(((ProtoBuf.Property)$receiver).getFlags()) : (ProtoBuf.Visibility)((Object)PreconditionsKt.error((Object)("Unknown message: " + $receiver)))))));
    }

    private static final String name(MessageLite $receiver, NameResolver nameResolver) {
        String string;
        MessageLite messageLite = $receiver;
        if (messageLite instanceof ProtoBuf.Constructor) {
            string = "<init>";
        } else if (messageLite instanceof ProtoBuf.Function) {
            String string2 = nameResolver.getString(((ProtoBuf.Function)$receiver).getName());
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"nameResolver.getString(name)");
        } else if (messageLite instanceof ProtoBuf.Property) {
            String string3 = nameResolver.getString(((ProtoBuf.Property)$receiver).getName());
            string = string3;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"nameResolver.getString(name)");
        } else {
            string = (String)((Object)PreconditionsKt.error((Object)("Unknown message: " + $receiver)));
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<String> names(List<? extends MessageLite> $receiver, @NotNull NameResolver nameResolver) {
        void destination;
        void $receiver2;
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)nameResolver, (String)"nameResolver");
        Iterable $receiver3 = $receiver;
        Iterable iterable = $receiver3;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver3, (int)10));
        for (Object item : $receiver2) {
            void it;
            MessageLite messageLite = (MessageLite)item;
            void var11_8 = destination;
            String string = ProtoDifferenceUtilsKt.name((MessageLite)it, nameResolver);
            var11_8.add(string);
        }
        return (List)destination;
    }
}

