/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jps.incremental.storage;

import java.io.File;
import java.util.Map;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.jps.incremental.storage.BasicMap;
import org.jetbrains.kotlin.jps.incremental.storage.FileKeyDescriptor;
import org.jetbrains.kotlin.jps.incremental.storage.IntExternalizer;
import org.jetbrains.kotlin.utils.CollectionsKt;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={")\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001D\u0001\u0006\u0003!!Q!\u0001C\u0002\u000b\u0005Aq!B\u0001\u0005\u0007\u0015\t\u0001\"A\u0003\u0002\t\u0007)\u0011\u0001\u0003\n\u0005\u00011\u0001\u0011dB\u0005\u0003\u0013\u0005A\u0012!\u0003\u0002\n\u0003a\r\u0001\u0014AQ\u0007\u0013\rA!!D\u0001\u0019\u0003E\u001b\u0011\u0001#\u0002&\u0011\u0011Q\u0001bA\u0007\u00021\u000fI2\u0001\u0003\u0003\u000e\u0003a\tQ\u0005\u0003\u0003\u000b\u0011\u0013i\u0011\u0001g\u0002\u001a\u0007!)Q\"\u0001M\u0002K1!1\t\u0002E\u0006\u001b\ta\t\u0001g\u0001\u001a\u0007!\u0011Q\"\u0001\r\u0002#\u000e\t\u0001BB\u0013\b\u0011\u001bi\u0011\u0001G\u0004\u001a\u0007!\u0011Q\"\u0001\r\u0002K3!1\t\u0002E\b\u001b\u0005Ar!G\u0002\t\u00055\t\u0001$A\r\u0004\u0011!i\u0011\u0001g\u0001&\u0013!EQbB\u0005\u0003\u0013\u0005A\u0012!\u0003\u0002\n\u0003a\r\u0001$\u0003"}, strings={"Lorg/jetbrains/kotlin/jps/incremental/storage/FileToIdMap;", "Lorg/jetbrains/kotlin/jps/incremental/storage/BasicMap;", "Ljava/io/File;", "", "file", "(Ljava/io/File;)V", "dumpKey", "", "key", "dumpValue", "value", "get", "(Ljava/io/File;)Ljava/lang/Integer;", "remove", "", "set", "id", "toMap", ""}, moduleName="jps-plugin")
public final class FileToIdMap
extends BasicMap<File, Integer> {
    @Override
    @NotNull
    protected String dumpKey(@NotNull File key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        String string = key.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"key.toString()");
        return string;
    }

    @Override
    @NotNull
    protected String dumpValue(int value) {
        return String.valueOf(value);
    }

    @Nullable
    public final Integer get(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        return (Integer)this.getStorage().get(file);
    }

    public final void set(@NotNull File file, int id) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        this.getStorage().set(file, id);
    }

    public final void remove(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        this.getStorage().remove(file);
    }

    @NotNull
    public final Map<File, Integer> toMap() {
        return CollectionsKt.keysToMap(this.getStorage().getKeys(), (Function1)new Function1<File, Integer>(this){
            final /* synthetic */ FileToIdMap this$0;

            public final int invoke(@NotNull File it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                V v = this.this$0.getStorage().get(it);
                if (v == null) {
                    Intrinsics.throwNpe();
                }
                return ((Number)v).intValue();
            }
            {
                this.this$0 = fileToIdMap;
                super(1);
            }
        });
    }

    public FileToIdMap(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        super(file, FileKeyDescriptor.INSTANCE, IntExternalizer.INSTANCE);
    }
}

