/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.impl.references;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.javaee.ExternalResourceManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.IncorrectOperationException;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.intellij.lang.xpath.xslt.quickfix.DownloadResourceFix;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ExternalResourceReference
implements PsiReference,
LocalQuickFixProvider {
    private final XmlAttribute myAttribute;
    private final ExternalResourceManager myResourceManager = ExternalResourceManager.getInstance();

    public ExternalResourceReference(XmlAttribute attribute) {
        this.myAttribute = attribute;
    }

    @Nullable
    public LocalQuickFix[] getQuickFixes() {
        return new LocalQuickFix[]{new DownloadResourceFix(this.myAttribute.getValue())};
    }

    @Nullable
    public PsiElement getElement() {
        return this.myAttribute.getValueElement();
    }

    public TextRange getRangeInElement() {
        XmlAttributeValue value = this.myAttribute.getValueElement();
        return value != null ? TextRange.from((int)1, (int)(value.getTextLength() - 2)) : TextRange.from((int)0, (int)0);
    }

    @Nullable
    public PsiElement resolve() {
        String value = this.myAttribute.getValue();
        String resourceLocation = this.myResourceManager.getResourceLocation(value);
        if (resourceLocation != value) {
            VirtualFile file;
            try {
                file = VfsUtil.findFileByURL((URL)new URL(resourceLocation));
            }
            catch (MalformedURLException e) {
                try {
                    file = VfsUtil.findFileByURL((URL)new File(resourceLocation).toURI().toURL());
                }
                catch (MalformedURLException e1) {
                    file = null;
                }
            }
            if (file != null) {
                return this.myAttribute.getManager().findFile(file);
            }
        }
        return null;
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.myAttribute.getValue();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/impl/references/ExternalResourceReference", "getCanonicalText"));
        }
        return string;
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        this.myAttribute.setValue(newElementName);
        XmlAttributeValue value = this.myAttribute.getValueElement();
        assert (value != null);
        return value;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/lang/xpath/xslt/impl/references/ExternalResourceReference", "bindToElement"));
        }
        throw new UnsupportedOperationException();
    }

    public boolean isReferenceTo(PsiElement element) {
        return element == this.resolve();
    }

    @NotNull
    public Object[] getVariants() {
        Object[] objectArray = this.myResourceManager.getResourceUrls(null, false);
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/impl/references/ExternalResourceReference", "getVariants"));
        }
        return objectArray;
    }

    public boolean isSoft() {
        return false;
    }
}

