/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository;

import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.settingsRepository.IcsSettings;
import org.jetbrains.settingsRepository.MyPrettyPrinter;

@KotlinFileFacade(version={1, 0, 0}, abiVersion=32, data={"\u001d\u0015\u0001Q!\u0001\u0005\u0005\u000b\u0005!\u0011!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001C\u0001\u0006\u00015E\u00012A\u0007\u00021\tI2\u0001#\u0002\u000e\u0003a\u0019AkA\u0001\u000e\u001a!\u001dQ\"\u0001\r\u00053\rAI!D\u0001\u0019\u0005e\u0019\u0001RA\u0007\u00021\r!6!A\t\n\t\u0005C\u0015\u0001\u0003\u0001\u000e\u0003a\u0005\u0011kA\u0001\u0006\u0001Q\u001b\u0011\u0001"}, strings={"DEFAULT_COMMIT_DELAY", "", "IcsSettingsKt", "loadSettings", "Lorg/jetbrains/settingsRepository/IcsSettings;", "settingsFile", "Ljava/io/File;", "saveSettings", "", "settings"}, moduleName="settings-repository")
public final class IcsSettingsKt {
    private static final int DEFAULT_COMMIT_DELAY = 600000;

    public static final void saveSettings(@NotNull IcsSettings settings, @NotNull File settingsFile) {
        Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
        Intrinsics.checkParameterIsNotNull((Object)settingsFile, (String)"settingsFile");
        byte[] serialized = new ObjectMapper().writer((PrettyPrinter)new MyPrettyPrinter()).writeValueAsBytes((Object)settings);
        if (serialized.length <= 2) {
            FileUtil.delete((File)settingsFile);
        } else {
            FileUtil.writeToFile((File)settingsFile, (byte[])serialized);
        }
    }

    @NotNull
    public static final IcsSettings loadSettings(@NotNull File settingsFile) {
        Intrinsics.checkParameterIsNotNull((Object)settingsFile, (String)"settingsFile");
        if (!settingsFile.exists()) {
            return new IcsSettings();
        }
        IcsSettings settings = (IcsSettings)new ObjectMapper().readValue(settingsFile, IcsSettings.class);
        if (settings.getCommitDelay() <= 0) {
            settings.setCommitDelay(DEFAULT_COMMIT_DELAY);
        }
        IcsSettings icsSettings = settings;
        Intrinsics.checkExpressionValueIsNotNull((Object)icsSettings, (String)"settings");
        return icsSettings;
    }

    static {
        DEFAULT_COMMIT_DELAY = 10 * 60000;
    }

    public static final /* synthetic */ int access$getDEFAULT_COMMIT_DELAY$p() {
        return DEFAULT_COMMIT_DELAY;
    }
}

