/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.concurrency;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.AsyncResult;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.ThreeState;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncFunction;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.CountDownConsumer;
import org.jetbrains.concurrency.DonePromise;
import org.jetbrains.concurrency.RejectedPromise;

public abstract class Promise<T> {
    public static final Promise<Void> DONE = new DonePromise<Object>(null);
    public static final Promise<Void> REJECTED = new RejectedPromise<Void>(Promise.createError("rejected"));

    @NotNull
    public static RuntimeException createError(@NotNull String error) {
        if (error == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "error", "org/jetbrains/concurrency/Promise", "createError"));
        }
        MessageError messageError = new MessageError(error);
        if (messageError == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/concurrency/Promise", "createError"));
        }
        return messageError;
    }

    @NotNull
    public static <T> Promise<T> resolve(T result) {
        if (result == null) {
            Promise<Void> promise = DONE;
            if (promise == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/concurrency/Promise", "resolve"));
            }
            return promise;
        }
        DonePromise<T> donePromise = new DonePromise<T>(result);
        if (donePromise == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/concurrency/Promise", "resolve"));
        }
        return donePromise;
    }

    @NotNull
    public static <T> Promise<T> reject(@NotNull String error) {
        if (error == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "error", "org/jetbrains/concurrency/Promise", "reject"));
        }
        Promise<T> promise = Promise.reject(Promise.createError(error));
        if (promise == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/concurrency/Promise", "reject"));
        }
        return promise;
    }

    @NotNull
    public static <T> Promise<T> reject(@Nullable Throwable error) {
        if (error == null) {
            Promise<Void> promise = REJECTED;
            if (promise == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/concurrency/Promise", "reject"));
            }
            return promise;
        }
        RejectedPromise rejectedPromise = new RejectedPromise(error);
        if (rejectedPromise == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/concurrency/Promise", "reject"));
        }
        return rejectedPromise;
    }

    @NotNull
    public static Promise<?> all(@NotNull Collection<Promise<?>> promises) {
        if (promises == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "promises", "org/jetbrains/concurrency/Promise", "all"));
        }
        if (promises.size() == 1) {
            Promise promise = promises instanceof List ? (Promise)((List)promises).get(0) : promises.iterator().next();
            if (promise == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/concurrency/Promise", "all"));
            }
            return promise;
        }
        Promise<Object> promise = Promise.all(promises, null);
        if (promise == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/concurrency/Promise", "all"));
        }
        return promise;
    }

    @NotNull
    public static <T> Promise<T> all(@NotNull Collection<Promise<?>> promises, @Nullable T totalResult) {
        if (promises == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "promises", "org/jetbrains/concurrency/Promise", "all"));
        }
        if (promises.isEmpty()) {
            Promise<Void> promise = DONE;
            if (promise == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/concurrency/Promise", "all"));
            }
            return promise;
        }
        final AsyncPromise totalPromise = new AsyncPromise();
        CountDownConsumer done = new CountDownConsumer(promises.size(), totalPromise, totalResult);
        Consumer<Throwable> rejected = new Consumer<Throwable>(){

            public void consume(Throwable error) {
                totalPromise.setError(error);
            }
        };
        for (Promise<?> promise : promises) {
            promise.done(done);
            promise.rejected(rejected);
        }
        AsyncPromise asyncPromise = totalPromise;
        if (asyncPromise == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/concurrency/Promise", "all"));
        }
        return asyncPromise;
    }

    @NotNull
    public static Promise<Void> wrapAsVoid(@NotNull ActionCallback asyncResult) {
        if (asyncResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "asyncResult", "org/jetbrains/concurrency/Promise", "wrapAsVoid"));
        }
        final AsyncPromise<Void> promise = new AsyncPromise<Void>();
        asyncResult.doWhenDone(new Runnable(){

            @Override
            public void run() {
                promise.setResult(null);
            }
        }).doWhenRejected(new Consumer<String>(){

            public void consume(String error) {
                promise.setError(Promise.createError(error == null ? "Internal error" : error));
            }
        });
        AsyncPromise<Void> asyncPromise = promise;
        if (asyncPromise == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/concurrency/Promise", "wrapAsVoid"));
        }
        return asyncPromise;
    }

    @NotNull
    public static <T> Promise<T> wrap(@NotNull AsyncResult<T> asyncResult) {
        if (asyncResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "asyncResult", "org/jetbrains/concurrency/Promise", "wrap"));
        }
        final AsyncPromise promise = new AsyncPromise();
        asyncResult.doWhenDone(new Consumer<T>(){

            public void consume(T result) {
                promise.setResult(result);
            }
        }).doWhenRejected(new Consumer<String>(){

            public void consume(String error) {
                promise.setError(error);
            }
        });
        AsyncPromise asyncPromise = promise;
        if (asyncPromise == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/concurrency/Promise", "wrap"));
        }
        return asyncPromise;
    }

    @NotNull
    public abstract Promise<T> done(@NotNull Consumer<T> var1);

    @NotNull
    public abstract Promise<T> processed(@NotNull AsyncPromise<T> var1);

    @NotNull
    public abstract Promise<T> rejected(@NotNull Consumer<Throwable> var1);

    public abstract Promise<T> processed(@NotNull Consumer<T> var1);

    @NotNull
    public abstract <SUB_RESULT> Promise<SUB_RESULT> then(@NotNull Function<T, SUB_RESULT> var1);

    @NotNull
    public abstract <SUB_RESULT> Promise<SUB_RESULT> then(@NotNull AsyncFunction<T, SUB_RESULT> var1);

    @NotNull
    public abstract State getState();

    public static void logError(@NotNull Logger logger, @NotNull Throwable e) {
        if (logger == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logger", "org/jetbrains/concurrency/Promise", "logError"));
        }
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/concurrency/Promise", "logError"));
        }
        if (e instanceof MessageError) {
            ThreeState log = ((MessageError)e).log;
            if (log == ThreeState.YES || log == ThreeState.UNSURE && ApplicationManager.getApplication().isUnitTestMode()) {
                logger.error(e);
            }
        } else if (!(e instanceof ProcessCanceledException)) {
            logger.error(e);
        }
    }

    public abstract void notify(@NotNull AsyncPromise<T> var1);

    public static class MessageError
    extends RuntimeException {
        private final ThreeState log;

        public MessageError(@NotNull String error) {
            if (error == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "error", "org/jetbrains/concurrency/Promise$MessageError", "<init>"));
            }
            super(error);
            this.log = ThreeState.UNSURE;
        }

        public MessageError(@NotNull String error, boolean log) {
            if (error == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "error", "org/jetbrains/concurrency/Promise$MessageError", "<init>"));
            }
            super(error);
            this.log = ThreeState.fromBoolean((boolean)log);
        }

        @Override
        @NotNull
        public final synchronized Throwable fillInStackTrace() {
            MessageError messageError = this;
            if (messageError == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/concurrency/Promise$MessageError", "fillInStackTrace"));
            }
            return messageError;
        }
    }

    public static enum State {
        PENDING,
        FULFILLED,
        REJECTED;

    }
}

