/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.FS_Win32;
import org.eclipse.jgit.util.FileUtil;
import org.eclipse.jgit.util.ProcessResult;

public class FS_Win32_Cygwin
extends FS_Win32 {
    private static String cygpath;

    public static boolean isCygwin() {
        String path = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("java.library.path");
            }
        });
        if (path == null) {
            return false;
        }
        File found = FS.searchPath(path, "cygpath.exe");
        if (found != null) {
            cygpath = found.getPath();
        }
        return cygpath != null;
    }

    public FS_Win32_Cygwin() {
    }

    protected FS_Win32_Cygwin(FS src) {
        super(src);
    }

    @Override
    public FS newInstance() {
        return new FS_Win32_Cygwin(this);
    }

    @Override
    public File resolve(File dir, String pn) {
        String w;
        String useCygPath = System.getProperty("jgit.usecygpath");
        if (useCygPath != null && useCygPath.equals("true") && (w = FS_Win32_Cygwin.readPipe(dir, new String[]{cygpath, "--windows", "--absolute", pn}, "UTF-8")) != null) {
            return new File(w);
        }
        return super.resolve(dir, pn);
    }

    @Override
    protected File userHomeImpl() {
        String home = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getenv("HOME");
            }
        });
        if (home == null || home.length() == 0) {
            return super.userHomeImpl();
        }
        return this.resolve(new File("."), home);
    }

    @Override
    public ProcessBuilder runInShell(String cmd, String[] args) {
        ArrayList<String> argv = new ArrayList<String>(4 + args.length);
        argv.add("sh.exe");
        argv.add("-c");
        argv.add(cmd + " \"$@\"");
        argv.add(cmd);
        argv.addAll(Arrays.asList(args));
        ProcessBuilder proc = new ProcessBuilder(new String[0]);
        proc.command(argv);
        return proc;
    }

    @Override
    public String relativize(String base, String other) {
        String relativized = super.relativize(base, other);
        return relativized.replace(File.separatorChar, '/');
    }

    @Override
    public ProcessResult runHookIfPresent(Repository repository, String hookName, String[] args, PrintStream outRedirect, PrintStream errRedirect, String stdinArgs) throws JGitInternalException {
        return this.internalRunHookIfPresent(repository, hookName, args, outRedirect, errRedirect, stdinArgs);
    }

    @Override
    public boolean supportsSymlinks() {
        return false;
    }

    @Override
    public boolean isSymLink(File path) throws IOException {
        return FileUtil.isSymlink(path);
    }

    @Override
    public long lastModified(File path) throws IOException {
        return FileUtil.lastModified(path);
    }

    @Override
    public void setLastModified(File path, long time) throws IOException {
        FileUtil.setLastModified(path, time);
    }

    @Override
    public void delete(File path) throws IOException {
        FileUtil.delete(path);
    }

    @Override
    public long length(File f) throws IOException {
        return FileUtil.getLength(f);
    }

    @Override
    public boolean exists(File path) {
        return FileUtil.exists(path);
    }

    @Override
    public boolean isDirectory(File path) {
        return FileUtil.isDirectory(path);
    }

    @Override
    public boolean isFile(File path) {
        return FileUtil.isFile(path);
    }

    @Override
    public boolean isHidden(File path) throws IOException {
        return FileUtil.isHidden(path);
    }

    @Override
    public void setHidden(File path, boolean hidden) throws IOException {
        FileUtil.setHidden(path, hidden);
    }

    @Override
    public String readSymLink(File path) throws IOException {
        return FileUtil.readSymlink(path);
    }

    @Override
    public void createSymLink(File path, String target) throws IOException {
        FileUtil.createSymLink(path, target);
    }

    @Override
    public FS.Attributes getAttributes(File path) {
        return FileUtil.getFileAttributesBasic(this, path);
    }

    @Override
    public File findHook(Repository repository, String hookName) {
        File gitdir = repository.getDirectory();
        File hookPath = new File(gitdir, "hooks" + File.separatorChar + hookName);
        if (FileUtil.canExecute(hookPath)) {
            return hookPath;
        }
        return null;
    }
}

