/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.android.jps;

import com.intellij.util.PathUtil;
import java.io.File;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import kotlin.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.android.AndroidJpsUtil;
import org.jetbrains.jps.android.model.JpsAndroidModuleExtension;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.kotlin.jps.build.KotlinJpsCompilerArgumentsProvider;
import org.w3c.dom.Document;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={";\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\t\u000f\u0015\u0001Q!\u0001\u0005\u0011\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0002\t\u0005)\u0011\u0001c\u0003\u0006\u0003\u0011\tA\u0002\u0001I\n3\u0005A\n!(A\nC\u000b\t6!\u0001\u0005\u0002K%!\u0011\u0001c\u0001\u000e\u00051\u0005\u0001DA\r\u0004\u0011\u000bi\u0011\u0001G\u0002&\u0013\u0011\t\u0001rA\u0007\u0003\u0019\u0003AB!G\u0002\t\u00065\t\u0001dA\u0013\u0010\t-AI!\u0004\u0003\n\u0005%\t\u0001\u0004\u0002\r\u00063\rAY!D\u0001\u0019\re\u0019\u0001RB\u0007\u00021\u001d)s\u0002B\u0006\t\u00105!\u0011BA\u0005\u00021\u0011AR!G\u0002\t\f5\t\u0001DB\r\u0004\u0011\u001bi\u0011\u0001G\u0004&\t\u0011\t\u0001\u0002C\u0007\u00021#)\u0003\u0002B\u0001\t\u00135\t\u0001\u0014C\r\u0004\u0011\u000bi\u0011\u0001G\u0002"}, strings={"Lorg/jetbrains/kotlin/android/jps/KotlinAndroidJpsPlugin;", "Lorg/jetbrains/kotlin/jps/build/KotlinJpsCompilerArgumentsProvider;", "()V", "getAndroidManifest", "Ljava/io/File;", "module", "Lorg/jetbrains/jps/model/module/JpsModule;", "getAndroidResPath", "", "getClasspath", "", "moduleBuildTarget", "Lorg/jetbrains/jps/incremental/ModuleBuildTarget;", "context", "Lorg/jetbrains/jps/incremental/CompileContext;", "getExtraArguments", "hasAndroidJpsPlugin", "", "isAndroidModuleWithoutGradle", "Companion"}, moduleName="android-jps-plugin")
public final class KotlinAndroidJpsPlugin
implements KotlinJpsCompilerArgumentsProvider {
    private static final String ANDROID_JPS_UTIL_CLASS_FQNAME = "org.jetbrains.jps.android.AndroidJpsUtil";
    private static final String JAR_FILE_NAME = "kotlin-android-extensions-compiler-plugin.jar";
    private static final String ANDROID_COMPILER_PLUGIN_ID = "org.jetbrains.kotlin.android";
    private static final String VARIANT_OPTION_NAME = "variant";
    private static final String PACKAGE_OPTION_NAME = "package";
    public static final Companion Companion = org.jetbrains.kotlin.android.jps.KotlinAndroidJpsPlugin$Companion.INSTANCE;

    static {
        ANDROID_JPS_UTIL_CLASS_FQNAME = ANDROID_JPS_UTIL_CLASS_FQNAME;
        JAR_FILE_NAME = JAR_FILE_NAME;
        ANDROID_COMPILER_PLUGIN_ID = ANDROID_COMPILER_PLUGIN_ID;
        VARIANT_OPTION_NAME = VARIANT_OPTION_NAME;
        PACKAGE_OPTION_NAME = PACKAGE_OPTION_NAME;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<String> getExtraArguments(@NotNull ModuleBuildTarget moduleBuildTarget, @NotNull CompileContext context) {
        String string;
        JpsModule module;
        block6: {
            block5: {
                Intrinsics.checkParameterIsNotNull((Object)moduleBuildTarget, (String)"moduleBuildTarget");
                Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
                module = moduleBuildTarget.getModule();
                if (!this.hasAndroidJpsPlugin()) break block5;
                JpsModule jpsModule = module;
                Intrinsics.checkExpressionValueIsNotNull((Object)jpsModule, (String)"module");
                if (this.isAndroidModuleWithoutGradle(jpsModule)) break block6;
            }
            return CollectionsKt.emptyList();
        }
        String pluginId = KotlinAndroidJpsPlugin.Companion.getANDROID_COMPILER_PLUGIN_ID();
        JpsModule jpsModule = module;
        Intrinsics.checkExpressionValueIsNotNull((Object)jpsModule, (String)"module");
        String resPath = this.getAndroidResPath(jpsModule);
        JpsModule jpsModule2 = module;
        Intrinsics.checkExpressionValueIsNotNull((Object)jpsModule2, (String)"module");
        File file = this.getAndroidManifest(jpsModule2);
        if (file != null) {
            void $receiver;
            File file2 = file;
            File it = (File)$receiver;
            string = KotlinAndroidJpsPlugin.Companion.getApplicationPackageFromManifest(it);
        } else {
            string = null;
        }
        String applicationId = string;
        return resPath != null && applicationId != null ? CollectionsKt.listOf((Object[])new String[]{KotlinAndroidJpsPlugin.Companion.getPluginOptionString(pluginId, KotlinAndroidJpsPlugin.Companion.getVARIANT_OPTION_NAME(), "main;" + resPath), KotlinAndroidJpsPlugin.Companion.getPluginOptionString(pluginId, KotlinAndroidJpsPlugin.Companion.getPACKAGE_OPTION_NAME(), applicationId)}) : CollectionsKt.emptyList();
    }

    private final boolean isAndroidModuleWithoutGradle(JpsModule module) {
        JpsAndroidModuleExtension jpsAndroidModuleExtension = AndroidJpsUtil.getExtension((JpsModule)module);
        if (jpsAndroidModuleExtension == null) {
            return false;
        }
        JpsAndroidModuleExtension androidFacet = jpsAndroidModuleExtension;
        return !androidFacet.isGradleProject();
    }

    private final boolean hasAndroidJpsPlugin() {
        try {
            Class.forName(KotlinAndroidJpsPlugin.Companion.getANDROID_JPS_UTIL_CLASS_FQNAME());
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    @Override
    @NotNull
    public List<String> getClasspath(@NotNull ModuleBuildTarget moduleBuildTarget, @NotNull CompileContext context) {
        List list;
        block8: {
            block7: {
                Intrinsics.checkParameterIsNotNull((Object)moduleBuildTarget, (String)"moduleBuildTarget");
                Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
                JpsModule module = moduleBuildTarget.getModule();
                if (!this.hasAndroidJpsPlugin()) break block7;
                JpsModule jpsModule = module;
                Intrinsics.checkExpressionValueIsNotNull((Object)jpsModule, (String)"module");
                if (this.isAndroidModuleWithoutGradle(jpsModule)) break block8;
            }
            return CollectionsKt.emptyList();
        }
        boolean inJar = new File(PathUtil.getJarPathForClass(this.getClass())).isFile();
        JpsModule jpsModule = moduleBuildTarget.getModule();
        Intrinsics.checkExpressionValueIsNotNull((Object)jpsModule, (String)"moduleBuildTarget.module");
        File manifestFile = this.getAndroidManifest(jpsModule);
        if (manifestFile != null) {
            String string;
            if (inJar) {
                File libDirectory = new File(PathUtil.getJarPathForClass(this.getClass())).getParentFile().getParentFile();
                string = new File(libDirectory, KotlinAndroidJpsPlugin.Companion.getJAR_FILE_NAME()).getAbsolutePath();
            } else {
                File kotlinProjectDirectory = new File(PathUtil.getJarPathForClass(this.getClass())).getParentFile().getParentFile().getParentFile();
                string = new File(kotlinProjectDirectory, "dist/kotlinc/lib/" + KotlinAndroidJpsPlugin.Companion.getJAR_FILE_NAME()).getAbsolutePath();
            }
            list = CollectionsKt.listOf((Object)string);
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private final String getAndroidResPath(JpsModule module) {
        JpsAndroidModuleExtension jpsAndroidModuleExtension = AndroidJpsUtil.getExtension((JpsModule)module);
        if (jpsAndroidModuleExtension == null) {
            return null;
        }
        JpsAndroidModuleExtension extension = jpsAndroidModuleExtension;
        File file = AndroidJpsUtil.getResourceDirForCompilationPath((JpsAndroidModuleExtension)extension);
        return file != null ? file.getAbsolutePath() : null;
    }

    private final File getAndroidManifest(JpsModule module) {
        JpsAndroidModuleExtension jpsAndroidModuleExtension = AndroidJpsUtil.getExtension((JpsModule)module);
        if (jpsAndroidModuleExtension == null) {
            return null;
        }
        JpsAndroidModuleExtension extension = jpsAndroidModuleExtension;
        return AndroidJpsUtil.getManifestFileForCompilationPath((JpsAndroidModuleExtension)extension);
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"!\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u0003!9Q!\u0001\u0003\u0007\u000b\u0005a\u0011!B\u0001\u0005\u0006\u0015\tA\"\u0001\u0003D\u00041\u0001\u0011$\u0001M\u0001C\u000f!\u0011!U\u0002\u0002\u0011\u0005)\u0013\u0002B\u0001\t\u00105\u0011A\u0012\u0001\r\u00033\rA\u0001\"D\u0001\u0019\u0012\u0015\u0002B!\u0001\u0005\n\u001b\u0005A\"!G\u0002\t\u00145\t\u0001DA\r\u0004\u0011)i\u0011\u0001\u0007\u0002\u001a\u0007!UQ\"\u0001\r\u0003K\u0019!\u0011\u0001C\u0006\u000e\u0003a]Q#\u0001M\tS/!\u0011\tS\u0001\t\u00045\t\u0001DA)\u0004\u000b\u0015\tA\u0012A\u0007\u0003\t\u000bA1!k\u0006\u0005\u0003\"\u000b\u0001rA\u0007\u00021\t\t6!B\u0003\u0002\u0019\u0003i!\u0001\u0002\u0003\t\u0007%^A!\u0011%\u0002\u0011\u0013i\u0011\u0001\u0007\u0002R\u0007\u0015)\u0011\u0001$\u0001\u000e\u0005\u0011)\u0001bAU\f\t\u0005C\u0015\u0001c\u0003\u000e\u0003a\u0011\u0011kA\u0003\u0006\u00031\u0005QB\u0001\u0003\u0007\u0011\rI;\u0002B!I\u0003!5Q\"\u0001\r\u0003#\u000e)Q!\u0001G\u0001\u001b\t!q\u0001C\u0002"}, strings={"Lorg/jetbrains/kotlin/android/jps/KotlinAndroidJpsPlugin$Companion;", "", "()V", "ANDROID_COMPILER_PLUGIN_ID", "", "getANDROID_COMPILER_PLUGIN_ID", "()Ljava/lang/String;", "ANDROID_JPS_UTIL_CLASS_FQNAME", "getANDROID_JPS_UTIL_CLASS_FQNAME", "JAR_FILE_NAME", "getJAR_FILE_NAME", "PACKAGE_OPTION_NAME", "getPACKAGE_OPTION_NAME", "VARIANT_OPTION_NAME", "getVARIANT_OPTION_NAME", "getApplicationPackageFromManifest", "manifestFile", "Ljava/io/File;", "getPluginOptionString", "pluginId", "key", "value", "parseXml", "Lorg/w3c/dom/Document;"}, moduleName="android-jps-plugin")
    public static final class Companion {
        public static final Companion INSTANCE;

        private final String getANDROID_JPS_UTIL_CLASS_FQNAME() {
            return ANDROID_JPS_UTIL_CLASS_FQNAME;
        }

        private final String getJAR_FILE_NAME() {
            return JAR_FILE_NAME;
        }

        private final String getANDROID_COMPILER_PLUGIN_ID() {
            return ANDROID_COMPILER_PLUGIN_ID;
        }

        private final String getVARIANT_OPTION_NAME() {
            return VARIANT_OPTION_NAME;
        }

        private final String getPACKAGE_OPTION_NAME() {
            return PACKAGE_OPTION_NAME;
        }

        private final String getApplicationPackageFromManifest(File manifestFile) {
            try {
                return this.parseXml(manifestFile).getDocumentElement().getAttribute(KotlinAndroidJpsPlugin.PACKAGE_OPTION_NAME);
            }
            catch (Exception e) {
                return null;
            }
        }

        private final Document parseXml(File $receiver) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse($receiver);
            Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"builder.parse(this)");
            return document;
        }

        private final String getPluginOptionString(String pluginId, String key, String value) {
            return "plugin:" + pluginId + ":" + key + "=" + value;
        }

        static {
            new Companion();
        }

        private Companion() {
            INSTANCE = this;
        }
    }
}

